/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.oms.entity.importFile;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.oms.entity.importFile.ImportDispatchOrder;
import cc.lechun.oms.entity.sale.vo.DispatchDetailVo;
import cc.lechun.oms.entity.sale.vo.DispatchOrderVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ImportToDispatchOrder {
    private ImportDispatchOrder importDispatchOrderEntity;
    private List<ImportDispatchOrder> importDispatchOrderDetails;
    private DispatchOrderVo dispatchOrderEntity;
    private List<DispatchDetailVo> dispatchOrderDetails = new ArrayList<DispatchDetailVo>();

    public void importDispatchOrderEntityToDispatchOrderEntity() {
        if (this.importDispatchOrderEntity != null) {
            DispatchOrderVo dispatchOrderEntity = new DispatchOrderVo();
            String id = IDGenerate.getUniqueIdStr();
            dispatchOrderEntity.setPickupdate(DateUtils.StrToDate((String)this.importDispatchOrderEntity.getPickupdate(), (String)"yyyy-MM-dd"));
            dispatchOrderEntity.setCcontacts(this.importDispatchOrderEntity.getCcontacts());
            dispatchOrderEntity.setCcontactnumber(this.importDispatchOrderEntity.getCcontactnumber());
            dispatchOrderEntity.setCdeliveryaddresses(this.importDispatchOrderEntity.getCdeliveryaddresses());
            dispatchOrderEntity.setCcustomerid(this.importDispatchOrderEntity.getCustomerid());
            dispatchOrderEntity.setCwarehouseid(this.importDispatchOrderEntity.getCwarehouseid());
            dispatchOrderEntity.setStoreName(this.importDispatchOrderEntity.getCwarehouseName());
            dispatchOrderEntity.setCremark(this.importDispatchOrderEntity.getCremark());
            dispatchOrderEntity.setcCreatorName(this.importDispatchOrderEntity.getcCreatorName());
            dispatchOrderEntity.setDcreatetime(this.importDispatchOrderEntity.getDcreatetime());
            dispatchOrderEntity.setOuterOrderNo(this.importDispatchOrderEntity.getOuterOrderNo());
            dispatchOrderEntity.setProvincename(this.importDispatchOrderEntity.getProvincename());
            dispatchOrderEntity.setCityname(this.importDispatchOrderEntity.getCityname());
            dispatchOrderEntity.setAreaname(this.importDispatchOrderEntity.getAreaname());
            dispatchOrderEntity.setBuyerMessage(this.importDispatchOrderEntity.getBuyerMessage());
            dispatchOrderEntity.setFromType(1);
            dispatchOrderEntity.setOrderType(1);
            this.dispatchOrderEntity = dispatchOrderEntity;
            this.importDispatchOrderDetailsToDispatchOrderDetailEntity(id);
        }
    }

    private void importDispatchOrderDetailsToDispatchOrderDetailEntity(String headId) {
        ArrayList<DispatchDetailVo> newList = new ArrayList<DispatchDetailVo>();
        if (this.importDispatchOrderDetails != null && this.importDispatchOrderDetails.size() > 0) {
            for (ImportDispatchOrder importDispatchOrder : this.importDispatchOrderDetails) {
                DispatchDetailVo dde = new DispatchDetailVo();
                dde.setCguid(IDGenerate.getUniqueIdStr());
                dde.setFreshness(Integer.valueOf(importDispatchOrder.getFreshness()));
                dde.setIqty(new BigDecimal(importDispatchOrder.getIqty()));
                dde.setItotal(new BigDecimal(importDispatchOrder.getItotal()));
                dde.setIquotedtaxprice(new BigDecimal(importDispatchOrder.getIquotedtaxprice()));
                dde.setCmatid(importDispatchOrder.getCmatid());
                dde.setCmatname(importDispatchOrder.getMatname());
                dde.setCshipmentid(headId);
                Double sum = Double.valueOf(importDispatchOrder.getItotal()) * (1.0 - Double.valueOf(importDispatchOrder.getItaxrate()) / 100.0);
                dde.setIamt(new BigDecimal(sum));
                dde.setIdeductions(new BigDecimal(100));
                dde.setItaxrate(new BigDecimal(importDispatchOrder.getItaxrate()));
                dde.setIgiveaway("\u5426");
                newList.add(dde);
            }
        }
        this.dispatchOrderDetails = newList;
    }

    public ImportDispatchOrder getImportDispatchOrderEntity() {
        return this.importDispatchOrderEntity;
    }

    public void setImportDispatchOrderEntity(ImportDispatchOrder importDispatchOrderEntity) {
        this.importDispatchOrderEntity = importDispatchOrderEntity;
    }

    public List<ImportDispatchOrder> getImportDispatchOrderDetails() {
        return this.importDispatchOrderDetails;
    }

    public void setImportDispatchOrderDetails(List<ImportDispatchOrder> importDispatchOrderDetails) {
        this.importDispatchOrderDetails = importDispatchOrderDetails;
    }

    public DispatchOrderVo getDispatchOrderEntity() {
        return this.dispatchOrderEntity;
    }

    public void setDispatchOrderEntity(DispatchOrderVo dispatchOrderEntity) {
        this.dispatchOrderEntity = dispatchOrderEntity;
    }

    public List<DispatchDetailVo> getDispatchOrderDetails() {
        return this.dispatchOrderDetails;
    }

    public void setDispatchOrderDetails(List<DispatchDetailVo> dispatchOrderDetails) {
        this.dispatchOrderDetails = dispatchOrderDetails;
    }
}

