/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.oms.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum MessageTagEnum {
    omsOrderCreate("omsOrderCreate", "EC", "\u521b\u5efa\u8ba2\u5355"),
    omsOrderPay("omsOrderPay", "EC", "\u8ba2\u5355\u652f\u4ed8"),
    omsOrderCancel("omsOrderCancel", "EC", "\u53d6\u6d88\u8ba2\u5355"),
    omsOrderDelete("omsOrderDelete", "EC", "\u5220\u9664\u8ba2\u5355"),
    omsOrderUpdate("omsOrderUpdate", "EC", "\u8ba2\u5355\u4fee\u6539"),
    omsOrderAppraisal("omsOrderAppraisal", "EC", "\u8ba2\u5355\u8bc4\u4ef7");

    private String state;
    private String value;
    private String stateDesc;

    private MessageTagEnum(String state, String value, String stateDesc) {
        this.state = state;
        this.stateDesc = stateDesc;
        this.value = value;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStateDesc() {
        return this.stateDesc;
    }

    public void setStateDesc(String stateDesc) {
        this.stateDesc = stateDesc;
    }

    public static MessageTagEnum getCoordinateStateEnumByState(String state) {
        MessageTagEnum messageTag = null;
        if (StringUtils.isBlank((CharSequence)state)) {
            return messageTag;
        }
        for (MessageTagEnum stateEnum : MessageTagEnum.values()) {
            if (!state.equals(stateEnum.state)) continue;
            messageTag = stateEnum;
            break;
        }
        return messageTag;
    }

    public static String getCoordinateStateDescByState(String state) {
        String stateDesc = null;
        if (StringUtils.isBlank((CharSequence)state)) {
            return stateDesc;
        }
        for (MessageTagEnum stateEnum : MessageTagEnum.values()) {
            if (!state.equals(stateEnum.state)) continue;
            stateDesc = stateEnum.stateDesc;
            break;
        }
        return stateDesc;
    }

    public static List<Map<String, Object>> getMap2List() {
        ArrayList list = Lists.newArrayList();
        for (MessageTagEnum ele : MessageTagEnum.values()) {
            HashMap map = Maps.newHashMap();
            map.put("value", ele.getState());
            map.put("label", ele.getStateDesc());
            list.add(map);
        }
        return list;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

