/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.service.BalancEinventoryService;
import cc.lechun.pro.util.BalancEinventoryBuildData;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class BalancEinventoryControl {
    protected String cachKey = "_BalancStoreDatas";
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private BalancEinventoryService balancEinventoryService;
    private Logger log = LoggerFactory.getLogger((String)BalancEinventoryControl.class.getName());

    @RequestMapping(value={"/balanc/einventory"})
    public BaseJsonVo balancEinventory(String flag) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        try {
            Object flagRedis = this.redisCacheUtil.get(this.cachKey);
            String flagW = "";
            if (flagRedis != null) {
                flagW = (String)flagRedis;
                if (flagW.equals("true")) {
                    this.redisCacheUtil.set(this.cachKey, (Object)"false", Long.valueOf(1800L));
                    baseJsonVo = this.balancEinventoryService.balancEinventoryService(flag);
                    this.redisCacheUtil.set(this.cachKey, (Object)"true", Long.valueOf(1800L));
                } else {
                    baseJsonVo.setStatus(500);
                    baseJsonVo.setMessage("\u6570\u636e\u6b63\u5728\u5339\u914d\u6279\u6b21\u4e2d\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            } else {
                this.redisCacheUtil.set(this.cachKey, (Object)"false", Long.valueOf(1800L));
                baseJsonVo = this.balancEinventoryService.balancEinventoryService(flag);
                this.redisCacheUtil.set(this.cachKey, (Object)"true", Long.valueOf(1800L));
            }
        }
        catch (Exception e) {
            this.redisCacheUtil.remove(this.cachKey);
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u672a\u77e5\u5f02\u5e38 \uff1a " + e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/balanc/removeBalancStoreDatasReidsLock"})
    public BaseJsonVo removeBalancStoreDatasReidsLock() {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.redisCacheUtil.remove(this.cachKey);
            baseJsonVo.setMessage("\u5e93\u5b58\u5339\u914d\u6279\u6b21-\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff08key:" + this.cachKey + "\uff09\u6e05\u9664\u6210\u529f");
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u672a\u77e5\u5f02\u5e38 \uff1a " + e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/balanc/setBctIds"})
    public BaseJsonVo balancEinventory(@RequestBody List<String> ids) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            BalancEinventoryBuildData.setIds(ids);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u5ba2\u6237ID\u8bbe\u7f6e\u5931\u8d25 \uff1a " + e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/balanc/findRelationData"})
    public Object findRelationData(Integer page, Integer rows, String id, String storeid, String matNameSearch, String proDateTime, String pickupdate, Integer freshness) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            param.put("id", id);
        }
        if (StringUtils.isNotBlank((CharSequence)storeid)) {
            param.put("storeid", storeid);
        }
        if (StringUtils.isNotBlank((CharSequence)matNameSearch)) {
            param.put("matNameSearch", matNameSearch);
        }
        if (StringUtils.isNotBlank((CharSequence)proDateTime)) {
            param.put("proDateTime", proDateTime.replace("-", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)pickupdate)) {
            param.put("pickupdate", pickupdate.replace("-", ""));
        }
        if (freshness != null) {
            param.put("freshness", freshness);
        }
        BaseJsonVo baseJsonVo = this.balancEinventoryService.findRelationData(page, rows, param);
        JqGridData gridData = null;
        if (baseJsonVo.getStatus() != 200) {
            return baseJsonVo;
        }
        gridData = new JqGridData((List)baseJsonVo.getValue());
        return gridData;
    }

    @RequestMapping(value={"/balanc/freshnessStatistics"})
    public Object freshnessStatistics(String storeid, String matNameSearch, Integer freshness) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> param = null;
        param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)storeid)) {
            param.put("storeid", storeid);
        }
        if (StringUtils.isNotBlank((CharSequence)matNameSearch)) {
            param.put("matNameSearch", matNameSearch);
        }
        if (freshness != null) {
            param.put("freshness", freshness);
        }
        BaseJsonVo baseJsonVo = this.balancEinventoryService.freshnessStatistics(param);
        long endTime = System.currentTimeMillis();
        this.log.info("  freshnessStatistics : " + (endTime - startTime) + " \u6beb\u79d2 \u5927\u5c0f :" + (baseJsonVo.getValue() != null ? ((List)baseJsonVo.getValue()).size() : 0));
        return baseJsonVo.getValue();
    }
}

