/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.util.ExcelUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RefreshScope
public class ExcelUtilControl {
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;

    @RequestMapping(value={"/excel/downloadTemplate"})
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response) {
        String str = ExcelUtilControl.class.getProtectionDomain().getCodeSource().getLocation().getFile() + "downloadTemplate/1.xls";
        File f = new File(str);
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u6cca\u4f4d\u4fe1\u606f\u6807\u51c6\u6a21\u677f.xlsx".getBytes(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(f));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/excel/importFile"})
    public BaseJsonVo importFile(HttpServletRequest request, MultipartFile file, String type, String ws) {
        BaseJsonVo message = new BaseJsonVo();
        message.setStatus(200);
        message.setMessage("\u5bfc\u5165\u6210\u529f");
        try {
            String filename = file.getOriginalFilename();
            if (null == filename || !filename.endsWith(".xls") && !filename.endsWith(".xlsx")) {
                message.setStatus(500);
                message.setMessage("\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u53ea\u80fd\u4e3a .xls \u7ed3\u5c3e\u6216 .xlsx \u7ed3\u5c3e\u7684 excel \u6587\u4ef6\uff01");
                return message;
            }
            BaseUser user = null;
            try {
                user = JedisUtils.getBaseUser((HttpServletRequest)request);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List initInventoryVOs = ExcelUtil.readInitInventory((InputStream)file.getInputStream(), (String)file.getOriginalFilename());
            if (initInventoryVOs != null && initInventoryVOs.size() > 0) {
                this.proStoreMaterialMapper.deleteAll();
                for (ProStoreMaterialEntity proStoreMaterialEntity : initInventoryVOs) {
                    proStoreMaterialEntity.setTpsmid(IDGenerate.getUniqueIdStr());
                }
                this.proStoreMaterialMapper.addRecordsBatch(initInventoryVOs);
                this.proStoreMaterialMapper.updateStoreIdAndMatId();
            }
        }
        catch (Exception e) {
            message.setStatus(500);
            message.setMessage("\u5bfc\u5165\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        return message;
    }
}

