/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.entity.vo.ProFactoryV;
import cc.lechun.pro.service.ProFactoryConfigAllotService;
import cc.lechun.pro.service.ProFactoryConfigBatchService;
import cc.lechun.pro.service.ProFactoryConfigCycleService;
import cc.lechun.pro.service.ProFactoryService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class ProFactoryControl {
    @Autowired
    private ProFactoryConfigAllotService proFactoryConfigAllotService;
    @Autowired
    private ProFactoryConfigBatchService proFactoryConfigBatchService;
    @Autowired
    private ProFactoryConfigCycleService proFactoryConfigCycleService;
    @Autowired
    private ProFactoryService proFactoryService;

    @RequestMapping(value={"/proFactory/findpage"})
    public Object findpage(Integer page, Integer rows, String searchFactory) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("page", page);
        param.put("rows", rows);
        param.put("searchFactory", searchFactory);
        BaseJsonVo baseJsonVo = this.proFactoryService.findProFactoryVS(param);
        if (baseJsonVo.getStatus() == 200) {
            return new JqGridData((List)baseJsonVo.getValue());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/proFactory/findFactoryDatasById"})
    public BaseJsonVo findFactoryDatasById(String id) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", id);
        return this.proFactoryService.findfacoryAndSun(paramMap);
    }

    @RequestMapping(value={"/proFactory/saveOrUpdate"})
    public BaseJsonVo saveOrUpdate(@RequestBody ProFactoryV proFactoryV) {
        return this.proFactoryService.saveOrUpdate(proFactoryV);
    }

    @RequestMapping(value={"/proFactory/deleteById"})
    public BaseJsonVo deleteById(String id) {
        return this.proFactoryService.delete(id);
    }

    @RequestMapping(value={"/proFactory/deleteByIds"})
    public BaseJsonVo deleteById(@RequestBody List<String> ids) {
        return this.proFactoryService.deletes(ids);
    }

    @RequestMapping(value={"/proFactory/configAllot/deleteById"})
    public BaseJsonVo deleteByAllotId(String id) {
        return this.proFactoryConfigAllotService.deleteById(id);
    }

    @RequestMapping(value={"/proFactory/configBatch/deleteById"})
    public BaseJsonVo deleteByBatchId(String id) {
        return this.proFactoryConfigBatchService.deleteById(id);
    }

    @RequestMapping(value={"/proFactory/configCycle/deleteById"})
    public BaseJsonVo deleteByCycleId(String id) {
        return this.proFactoryConfigCycleService.deleteById(id);
    }
}

