/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.serviceresult.Message;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import cc.lechun.pro.entity.ProStorePredictRangeEntity;
import cc.lechun.pro.entity.bo.ProStorePredictRangeForm;
import cc.lechun.pro.service.BuildStoreRangeAndFactoryCalendarService;
import cc.lechun.pro.service.ProStorePredictRangeService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class ProStorePredictRangeControl {
    @Autowired
    private ProStorePredictRangeService proStorePredictRangeService;
    @Autowired
    private BuildStoreRangeAndFactoryCalendarService buildStoreRangeAndFactoryCalendarService;

    @RequestMapping(value={"/storerange/saveOrUpdate"})
    public BaseJsonVo saveOrUpdate(HttpServletRequest request, @RequestBody ProStorePredictRangeForm mpForm) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        List materialProds = this.getProStorePredictRangeEntitys(mpForm, user);
        try {
            if (mpForm.getDel() != null && mpForm.getDel().size() > 0) {
                this.proStorePredictRangeService.deleteByIds(mpForm.getDel());
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            return baseJsonVo;
        }
        return this.proStorePredictRangeService.saveOrUpdateList(materialProds);
    }

    @RequestMapping(value={"/storerange/findpage"})
    public Object findpage(Integer page, Integer rows, String storeid) {
        JqGridData gridData = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)storeid) && !storeid.equals("null")) {
                params.put("storeid", storeid);
            }
            BaseJsonVo baseJsonVo = this.proStorePredictRangeService.findList(page, rows, params);
            List list = null;
            if (baseJsonVo.getStatus() == 200) {
                list = (List)baseJsonVo.getValue();
            }
            gridData = new JqGridData(list);
        }
        catch (Exception e) {
            Message message = new Message(false, "\u67e5\u8be2\u5931\u8d25");
            return message;
        }
        return gridData;
    }

    private List<ProStorePredictRangeEntity> getProStorePredictRangeEntitys(ProStorePredictRangeForm materialProdForm, BaseUser user) {
        ArrayList<ProStorePredictRangeEntity> list = new ArrayList<ProStorePredictRangeEntity>();
        Date date = new Date();
        if (null != materialProdForm.getAdd() && materialProdForm.getAdd().size() > 0) {
            for (ProStorePredictRangeEntity materialProd : materialProdForm.getAdd()) {
                if (user != null) {
                    materialProd.setModifier(user.getEmployeeName());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{materialProd.getStartdate()})) {
                    materialProd.setStartdate(materialProd.getStartdate().replace("-", ""));
                }
                materialProd.setModifytime(date);
                list.add(materialProd);
            }
        }
        if (null != materialProdForm.getModify() && materialProdForm.getModify().size() > 0) {
            for (ProStorePredictRangeEntity materialProd : materialProdForm.getModify()) {
                if (user != null) {
                    materialProd.setModifier(user.getEmployeeName());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{materialProd.getStartdate()})) {
                    materialProd.setStartdate(materialProd.getStartdate().replace("-", ""));
                }
                materialProd.setModifytime(date);
                list.add(materialProd);
            }
        }
        return list;
    }
}

