/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.dao.impl;

import cc.lechun.bd.entity.vo.EdbMaterialRelationEntityV;
import cc.lechun.bd.entity.vo.EdbWarehouseRelationEntityV;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.apiinvoke.EdbClient;
import cc.lechun.pro.apiinvoke.EdbMaterialRelationClient;
import cc.lechun.pro.apiinvoke.EdbWarehouseRelationClient;
import cc.lechun.pro.apiinvoke.getdata.pro.edbstoredatas.Edbstoredatas;
import cc.lechun.pro.dao.FormEdianBaoGetStoreMateralMapper;
import cc.lechun.pro.entity.FormEdianBaoGetStoreMateral;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetEdbDatasDao {
    @Autowired
    private EdbClient edbClient;
    @Autowired
    private EdbMaterialRelationClient edbMaterialRelationClient;
    @Autowired
    private EdbWarehouseRelationClient edbWarehouseRelationClient;
    @Autowired
    private FormEdianBaoGetStoreMateralMapper formEdianBaoGetStoreMateralMapper;
    private Logger log = LoggerFactory.getLogger(GetEdbDatasDao.class);

    public List<FormEdianBaoGetStoreMateral> getEDBstoreDatas() {
        List formEdianBaoGetStoreMaterals = null;
        try {
            String jsonstr = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("format", "json");
            long time5 = System.currentTimeMillis();
            jsonstr = this.edbClient.edbRequstPost("edbProductGet_LC", map);
            long time7 = System.currentTimeMillis();
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            Edbstoredatas Edbstoredatas2 = (Edbstoredatas)new Gson().fromJson(jsonstr, type);
            formEdianBaoGetStoreMaterals = Edbstoredatas2.getSuccess().getItems().getItem();
            long time8 = System.currentTimeMillis();
            this.log.info("==========\u83b7\u53d6edb\u539f\u59cb\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2  \u8f6c\u6362\u4e3a\u672c\u5730\u5b58\u50a8\u6240\u9700\u6570\u636e  " + (time7 - time5) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6Edb \u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        return formEdianBaoGetStoreMaterals;
    }

    public List<EdbWarehouseRelationEntityV> getWarehouseRelations() {
        long time7 = System.currentTimeMillis();
        List list = null;
        try {
            BaseJsonVo basejson = this.edbWarehouseRelationClient.findAll();
            if (basejson.getStatus() == 200 && basejson.getValue() != null) {
                list = (List)basejson.getValue();
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u4ed3\u5e93\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
        }
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u83b7\u53d6\u4ed3\u5e93\u6620\u5c04\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        return list;
    }

    public List<EdbMaterialRelationEntityV> getMaterialRelations() {
        long time7 = System.currentTimeMillis();
        List list = null;
        try {
            BaseJsonVo basejson = this.edbMaterialRelationClient.findAll();
            if (basejson.getStatus() == 200 && basejson.getValue() != null) {
                list = (List)basejson.getValue();
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u7269\u54c1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
        }
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u83b7\u53d6\u7269\u54c1\u6620\u5c04\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        return list;
    }

    public void deleteEdbDatasAll() {
        long time7 = System.currentTimeMillis();
        this.formEdianBaoGetStoreMateralMapper.deleteAll();
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u5220\u9664\u6613\u5e97\u5b9d\u6240\u6709\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
    }

    public List<FormEdianBaoGetStoreMateral> gropSumEdbDatas() {
        long time7 = System.currentTimeMillis();
        List list = this.formEdianBaoGetStoreMateralMapper.findGropSum();
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u5206\u7ec4\u6c42\u548c\u6240\u6709\u6613\u5e97\u5b9d\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        return list;
    }

    public void addRecordsBatch(List<FormEdianBaoGetStoreMateral> formEdianBaoGetStoreMaterals) {
        long time7 = System.currentTimeMillis();
        if (formEdianBaoGetStoreMaterals != null && formEdianBaoGetStoreMaterals.size() > 0) {
            Date date = new Date();
            for (FormEdianBaoGetStoreMateral formEdianBaoGetStoreMateral : formEdianBaoGetStoreMaterals) {
                formEdianBaoGetStoreMateral.setId(IDGenerate.getUniqueIdStr());
                formEdianBaoGetStoreMateral.setUpdateTime(date);
            }
            int length = formEdianBaoGetStoreMaterals.size() / 40 + 1;
            int mod = formEdianBaoGetStoreMaterals.size() % 40;
            for (int i = 0; i < length; ++i) {
                int end = (i + 1) * 40 > formEdianBaoGetStoreMaterals.size() ? i * 40 + mod : 40 * (i + 1);
                List<FormEdianBaoGetStoreMateral> sub = formEdianBaoGetStoreMaterals.subList(i * 40, end);
                this.formEdianBaoGetStoreMateralMapper.addRecordsBatch(sub);
            }
            long time8 = System.currentTimeMillis();
            this.log.info("=========\u6613\u5e97\u5b9d\u539f\u59cb\u6570\u636e\uff08" + formEdianBaoGetStoreMaterals.size() + "\uff09\u63d2\u5165\u6570\u636e\u5e93==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        }
    }

    public List<ProStoreMaterialEntity> edbToloclDatas(List<FormEdianBaoGetStoreMateral> formEdianBaoGetStoreMaterals, List<EdbWarehouseRelationEntityV> edbWarehouseRelatios, List<EdbMaterialRelationEntityV> edbMaterialRelations) {
        if (formEdianBaoGetStoreMaterals != null && formEdianBaoGetStoreMaterals.size() > 0) {
            long time7 = System.currentTimeMillis();
            ArrayList<ProStoreMaterialEntity> proStoreMaterials = new ArrayList<ProStoreMaterialEntity>();
            for (FormEdianBaoGetStoreMateral pebgsm : formEdianBaoGetStoreMaterals) {
                ProStoreMaterialEntity psm;
                block11: {
                    psm = null;
                    if (pebgsm == null) {
                        this.log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a pebgsm" + pebgsm.getBar_code());
                        continue;
                    }
                    try {
                        block10: {
                            try {
                                psm = pebgsm.myToProStoreMaterialEntity(pebgsm);
                                if (psm == null) {
                                    this.log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a " + pebgsm.getBar_code());
                                }
                                break block10;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.log.info("\u8f6c\u6362\u4ed3\u5e93\u4fe1\u606f\u5f02\u5e38  pebgsm.myToProStoreMaterialEntity" + e.getMessage());
                            }
                            continue;
                        }
                        EdbMaterialRelationEntityV edbMaterialRelation = this.getMaterialRelationByEdbCode(pebgsm, edbMaterialRelations);
                        if (edbMaterialRelation == null) {
                            this.log.info("\u7269\u54c1\u6c92\u6709\u5339\u914d\u4e0a code " + pebgsm.getBar_code());
                            continue;
                        }
                        psm.setMatid(edbMaterialRelation.getCmatid());
                        psm.setMatcode(edbMaterialRelation.getCmatcode());
                        psm.setMatname(edbMaterialRelation.getCmatname());
                        EdbWarehouseRelationEntityV warehouseRelation = this.getWarehouseRelationByEdbCode(pebgsm, edbWarehouseRelatios);
                        if (warehouseRelation != null) {
                            psm.setStoreid(warehouseRelation.getCwarehouseid());
                            psm.setStorecode(warehouseRelation.getCwarehousecode());
                            psm.setStorename(warehouseRelation.getCwarehousename());
                            break block11;
                        }
                        this.log.info("\u4ed3\u5e93\u6c92\u6709\u5339\u914d\u4e0a code " + pebgsm.getWarehouse_id());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.info("======\u83b7\u53d6\u6613\u5e97\u5b9d\u6570\u636e\u7ec4\u5408\u6210erp\u5e93\u5b58\u6240\u9700\u6570\u636e \u5f02\u5e38 " + e.getMessage());
                    }
                    continue;
                }
                proStoreMaterials.add(psm);
            }
            long time8 = System.currentTimeMillis();
            this.log.info("=========\u6613\u5e97\u5b9d\u6570\u636e\u6784\u5efa\u4f4derp \u5e93\u5b58\u6570\u636e\uff08" + formEdianBaoGetStoreMaterals.size() + "\uff09\u8017\u65f6==\u300b" + (time8 - time7) + "\u6beb\u79d2");
            return proStoreMaterials;
        }
        return null;
    }

    private EdbWarehouseRelationEntityV getWarehouseRelationByEdbCode(FormEdianBaoGetStoreMateral pebgsm, List<EdbWarehouseRelationEntityV> list) {
        EdbWarehouseRelationEntityV relation = null;
        if (list != null && list.size() > 0) {
            for (EdbWarehouseRelationEntityV relationV : list) {
                if (null == relationV.getEdbwarehousecode()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488 getEdbwarehousecode()" + new Gson().toJson((Object)relationV));
                    continue;
                }
                if (null == pebgsm.getWarehouse_id()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488(pebgsm.getWarehouse_id()) " + new Gson().toJson((Object)pebgsm));
                    continue;
                }
                if (null == relationV.getType()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488  relationV.getType()  " + new Gson().toJson((Object)relationV));
                    continue;
                }
                if (!relationV.getEdbwarehousecode().equals(pebgsm.getWarehouse_id()) || relationV.getType() != 1 && !(relationV.getType() + "").equals("1")) continue;
                relation = relationV;
                break;
            }
        }
        return relation;
    }

    private EdbMaterialRelationEntityV getMaterialRelationByEdbCode(FormEdianBaoGetStoreMateral pebgsm, List<EdbMaterialRelationEntityV> list) {
        EdbMaterialRelationEntityV relation = null;
        if (list != null && list.size() > 0) {
            for (EdbMaterialRelationEntityV relationV : list) {
                if (null == relationV.getEdbmatcode()) {
                    this.log.info("\u7269\u54c1\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488 (relationV.getEdbmatcode())" + new Gson().toJson((Object)relationV));
                    continue;
                }
                if (null == pebgsm.getBar_code()) {
                    this.log.info("\u7269\u54c1\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488(pebgsm.getBar_code()) " + new Gson().toJson((Object)pebgsm));
                    continue;
                }
                if (!relationV.getEdbmatcode().equals(pebgsm.getBar_code())) continue;
                relation = relationV;
                break;
            }
        }
        return relation;
    }
}

