/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.dao.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.pro.apiinvoke.CodingSchemeServiceClient;
import cc.lechun.pro.dao.ProFactoryMapper;
import cc.lechun.pro.dao.impl.ProFactoryConfigAllotDao;
import cc.lechun.pro.dao.impl.ProFactoryConfigBatchDao;
import cc.lechun.pro.dao.impl.ProFactoryConfigCycleDao;
import cc.lechun.pro.entity.ProFactoryEntity;
import cc.lechun.pro.entity.vo.ProFactoryConfigAllotV;
import cc.lechun.pro.entity.vo.ProFactoryConfigBatchV;
import cc.lechun.pro.entity.vo.ProFactoryConfigCycleV;
import cc.lechun.pro.entity.vo.ProFactoryV;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProFactoryDao {
    private Logger log = LoggerFactory.getLogger(ProFactoryDao.class);
    @Autowired
    private ProFactoryMapper proFactoryMapper;
    @Autowired
    private CodingSchemeServiceClient codingSchemeServiceClient;
    @Autowired
    private ProFactoryConfigAllotDao proFactoryConfigAllotDao;
    @Autowired
    private ProFactoryConfigBatchDao proFactoryConfigBatchDao;
    @Autowired
    private ProFactoryConfigCycleDao proFactoryConfigCycleDao;

    private String checkCodeExit() {
        String code = this.codingSchemeServiceClient.generateCode("016", "");
        ProFactoryEntity proFactoryEntity = new ProFactoryEntity();
        proFactoryEntity.setCode(code);
        if (this.proFactoryMapper.getSingle((Object)proFactoryEntity) != null) {
            this.codingSchemeServiceClient.updategenerateCode("016", "");
            code = this.checkCodeExit();
        }
        this.codingSchemeServiceClient.updategenerateCode("016", "");
        return code;
    }

    public void saveOrUpdate(ProFactoryV proFactoryV) throws Exception {
        if (StringUtils.isBlank((CharSequence)proFactoryV.getId())) {
            proFactoryV.setId(IDGenerate.getUniqueIdStr());
            proFactoryV.setCode(this.checkCodeExit());
            this.proFactoryMapper.insert((Object)proFactoryV);
        } else {
            this.proFactoryMapper.updateByPrimaryKey((Object)proFactoryV);
        }
        if (proFactoryV.getProFactoryConfigAllots() != null && proFactoryV.getProFactoryConfigAllots().size() > 0) {
            for (ProFactoryConfigAllotV proFactoryConfigAllotV : proFactoryV.getProFactoryConfigAllots()) {
                proFactoryConfigAllotV.setParentid(proFactoryV.getId());
            }
            this.proFactoryConfigAllotDao.saveOrUpdate(proFactoryV.getProFactoryConfigAllots());
        }
        if (proFactoryV.getProFactoryConfigBatchs() != null && proFactoryV.getProFactoryConfigBatchs().size() > 0) {
            for (ProFactoryConfigBatchV proFactoryConfigBatchV : proFactoryV.getProFactoryConfigBatchs()) {
                proFactoryConfigBatchV.setParentid(proFactoryV.getId());
            }
            this.proFactoryConfigBatchDao.saveOrUpdate(proFactoryV.getProFactoryConfigBatchs());
        }
        if (proFactoryV.getProFactoryConfigCycles() != null && proFactoryV.getProFactoryConfigCycles().size() > 0) {
            for (ProFactoryConfigCycleV proFactoryConfigCycleV : proFactoryV.getProFactoryConfigCycles()) {
                proFactoryConfigCycleV.setParentid(proFactoryV.getId());
            }
            this.proFactoryConfigCycleDao.saveOrUpdate(proFactoryV.getProFactoryConfigCycles());
        }
    }

    public List<ProFactoryV> findProFactoryVS(Map<String, Object> paramMap) throws Exception {
        Integer pageNo = 0;
        if (paramMap.get("page") != null) {
            pageNo = Integer.valueOf(paramMap.get("page").toString());
        }
        Integer pageSize = 0;
        if (paramMap.get("rows") != null) {
            pageSize = Integer.valueOf(paramMap.get("rows").toString());
        }
        if (pageNo > 0 && pageSize > 0) {
            PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        return this.proFactoryMapper.findfacory(paramMap);
    }

    public ProFactoryV findProFactoryV(Map<String, Object> paramMap) throws Exception {
        List list = this.findProFactoryVS(paramMap);
        if (list != null) {
            return (ProFactoryV)list.get(0);
        }
        return null;
    }

    public List<ProFactoryV> findfacoryAndSuns(Map<String, Object> paramMap) throws Exception {
        return this.proFactoryMapper.findfacoryAndSuns(paramMap);
    }

    public ProFactoryV findfacoryAndSun(Map<String, Object> paramMap) throws Exception {
        List list = this.findfacoryAndSuns(paramMap);
        if (list != null) {
            return (ProFactoryV)list.get(0);
        }
        return null;
    }

    public void deleteById(String id) throws Exception {
        this.proFactoryMapper.deleteById(id);
    }

    public void deleteByIds(List<String> ids) throws Exception {
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                ProFactoryEntity proFactoryEntity = (ProFactoryEntity)this.proFactoryMapper.selectByPrimaryKey((Serializable)((Object)id));
                if (proFactoryEntity == null || proFactoryEntity.getFlag() != 2) continue;
                this.proFactoryMapper.deleteById(id);
            }
        }
    }
}

