/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.dao.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.pro.dao.ProMaterialPlanHistoryOccupyMapper;
import cc.lechun.pro.entity.ProMaterialPlanHistoryOccupyEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProMaterialPlanHistoryOccupyDao {
    @Autowired
    private ProMaterialPlanHistoryOccupyMapper proMaterialPlanHistoryOccupyMapper;
    private Logger log = LoggerFactory.getLogger(ProMaterialPlanHistoryOccupyDao.class);

    private void save(ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy) throws Exception {
        proMaterialPlanHistoryOccupy.setId(IDGenerate.getUniqueIdStr());
        this.proMaterialPlanHistoryOccupyMapper.insert((Object)proMaterialPlanHistoryOccupy);
    }

    public void saveFromToBuildPlans(List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys) throws Exception {
        Date date = new Date();
        String today = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
        this.proMaterialPlanHistoryOccupyMapper.deleteAll(today);
        this.saves(proMaterialPlanHistoryOccupys, today, date);
    }

    public void saves(List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, String today, Date date) throws Exception {
        if (proMaterialPlanHistoryOccupys != null && proMaterialPlanHistoryOccupys.size() > 0) {
            for (ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy : proMaterialPlanHistoryOccupys) {
                if (today != null && proMaterialPlanHistoryOccupy.getProdatetime().equals(today)) continue;
                proMaterialPlanHistoryOccupy.setUpdatetime(date);
                this.save(proMaterialPlanHistoryOccupy);
            }
        }
    }

    public void savesFromChangePlan(List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys) throws Exception {
        if (proMaterialPlanHistoryOccupys != null && proMaterialPlanHistoryOccupys.size() > 0) {
            for (ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy : proMaterialPlanHistoryOccupys) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("matid", proMaterialPlanHistoryOccupy.getMatid());
                param.put("storeid", proMaterialPlanHistoryOccupy.getStoreid());
                param.put("prodatetime", proMaterialPlanHistoryOccupy.getProdatetime());
                this.proMaterialPlanHistoryOccupyMapper.deleteFromChangePlan(param);
            }
        }
        this.saves(proMaterialPlanHistoryOccupys, null, new Date());
    }

    public List<ProMaterialPlanHistoryOccupyEntity> findTosupportAmount(String today) {
        Date date = DateUtils.StrToDate((String)today, (String)"yyyyMMdd");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("updatetime", date);
        List list = this.proMaterialPlanHistoryOccupyMapper.findTosupportAmount(param);
        if (list.size() < 1) {
            param.clear();
            param.put("today", today);
            return this.proMaterialPlanHistoryOccupyMapper.findTosupportAmount(param);
        }
        param.clear();
        param.put("twoDays", "true");
        param.put("today1", today);
        param.put("today2", DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)1), (String)"yyyyMMdd"));
        return this.proMaterialPlanHistoryOccupyMapper.findTosupportAmount(param);
    }
}

