/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.apiinvoke.OmsServiceClient;
import cc.lechun.pro.apiinvoke.WmsServiceClient;
import cc.lechun.pro.dao.ProBalancEinventoryRelationMapper;
import cc.lechun.pro.dao.ProFactoryCalendarBuildMapper;
import cc.lechun.pro.dao.ProPredictDetailMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.dao.impl.FreshnessStatisticsDao;
import cc.lechun.pro.dao.impl.ProBalancEinventoryRelationDao;
import cc.lechun.pro.dao.impl.ProFactoryCalendarBuilDao;
import cc.lechun.pro.dao.impl.ProMaterialPlanHistoryOccupyDao;
import cc.lechun.pro.entity.ProFactoryCalendarBuildEntity;
import cc.lechun.pro.entity.ProMaterialPlanHistoryOccupyEntity;
import cc.lechun.pro.entity.ProPredictDetailEntity;
import cc.lechun.pro.entity.ProPredictSumEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.vo.EinventoryRelationV;
import cc.lechun.pro.entity.vo.FreshnessStatisticsV;
import cc.lechun.pro.entity.vo.ProFactoryCalendarBuildV;
import cc.lechun.pro.service.BalancEinventoryService;
import cc.lechun.pro.service.ProTransportCalendarService;
import cc.lechun.pro.util.BalancEinventoryBuildData;
import cc.lechun.pro.util.mythread.ThreadUtil;
import cc.lechun.pro.util.mythread.myclass.ToRunTaskMethod;
import com.github.pagehelper.PageHelper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BalancEinventoryServiceImpl
implements BalancEinventoryService {
    @Autowired
    ProFactoryCalendarBuildMapper proFactoryCalendarBuildMapper;
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private ProPredictDetailMapper proPredictDetailMapper;
    @Autowired
    private ProBalancEinventoryRelationMapper proBalancEinventoryRelationMapper;
    @Autowired
    private ProTransportCalendarService proTransportCalendarService;
    @Autowired
    private OmsServiceClient omsServiceClient;
    @Autowired
    private WmsServiceClient wmsServiceClient;
    @Autowired
    private ProMaterialPlanHistoryOccupyDao proMaterialPlanHistoryOccupyDao;
    @Autowired
    private ProBalancEinventoryRelationDao proBalancEinventoryRelationDao;
    @Autowired
    private FreshnessStatisticsDao freshnessStatisticsDao;
    @Autowired
    private ProFactoryCalendarBuilDao proFactoryCalendarBuilDao;
    private Logger log = LoggerFactory.getLogger((String)BalancEinventoryServiceImpl.class.getName());

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo balancEinventoryService(String flag) {
        long time3 = System.currentTimeMillis();
        BaseJsonVo baseJsonVoObject = new BaseJsonVo();
        baseJsonVoObject.setStatus(200);
        try {
            long timenew1;
            long timenew2;
            long timenew22;
            long timenew23;
            long timenew12;
            Date date = new Date();
            List storeMaterials = null;
            List storeMaterialsA = null;
            BaseJsonVo baseJsonVo = null;
            List saleMaterials = null;
            List predictMaterialsBeforTwoDays = null;
            List predictDetaiBeforTwoDays = null;
            List allocationMaterials = null;
            BaseJsonVo baseJsonVoallocation = null;
            List transportAllocationDatas = null;
            BaseJsonVo baseJsonVoTransportAllocation = null;
            ThreadUtil threadUtilstoreMaterialsA = new ThreadUtil();
            ThreadUtil threadUtilProNeedDispatchOrderData = new ThreadUtil();
            ThreadUtil threadUtilpredictMaterialsBeforTwoDays = new ThreadUtil();
            ThreadUtil threadUtilpredictDetaiBeforTwoDays = new ThreadUtil();
            ThreadUtil threadUtilIcAllotDetailPro = new ThreadUtil();
            ThreadUtil threadUtilbaseJsonVoTransportAllocation = new ThreadUtil();
            long time6 = System.currentTimeMillis();
            this.log.info("\u5e93\u5b58\u5e73\u8861 \u65b0\u5efa\u73b0\u7a0b\u8017\u65f6 =============\u300b " + (time6 - time3) + " \u6beb\u79d2");
            threadUtilstoreMaterialsA.toRunTask("threadUtilstoreMaterialsA", (ToRunTaskMethod)new /* Unavailable Anonymous Inner Class!! */);
            threadUtilProNeedDispatchOrderData.toRunTask("threadUtilProNeedDispatchOrderData", (ToRunTaskMethod)new /* Unavailable Anonymous Inner Class!! */);
            HashMap<String, Object> param1 = new HashMap<String, Object>();
            String beforTwoDays = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)0), (String)"yyyyMMdd");
            param1.put("beforDays", beforTwoDays);
            threadUtilpredictMaterialsBeforTwoDays.toRunTask("threadUtilpredictMaterialsBeforTwoDays", (ToRunTaskMethod)new /* Unavailable Anonymous Inner Class!! */);
            param1.put("proIsTrue", true);
            threadUtilpredictDetaiBeforTwoDays.toRunTask("threadUtilpredictDetaiBeforTwoDays", (ToRunTaskMethod)new /* Unavailable Anonymous Inner Class!! */);
            threadUtilIcAllotDetailPro.toRunTask("threadUtilIcAllotDetailPro", (ToRunTaskMethod)new /* Unavailable Anonymous Inner Class!! */);
            threadUtilbaseJsonVoTransportAllocation.toRunTask("threadUtilbaseJsonVoTransportAllocation", (ToRunTaskMethod)new /* Unavailable Anonymous Inner Class!! */);
            long time4 = System.currentTimeMillis();
            this.log.info("\u5e93\u5b58\u5e73\u8861 \u73b0\u7a0b\u8bf7\u6c42\u6570\u636e\u8017\u65f6 =============\u300b " + (time4 - time3) + " \u6beb\u79d2");
            try {
                timenew12 = System.currentTimeMillis();
                storeMaterialsA = (List)threadUtilstoreMaterialsA.toRunTask("threadUtilstoreMaterialsA");
                storeMaterials = this.initializeDatas(storeMaterialsA);
                timenew23 = System.currentTimeMillis();
                this.log.info("\u83b7\u53d6\u5e93\u5b58\u4fe1\u606f\u5355\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew23 - timenew12) + " \u6beb\u79d2 \u5927\u5c0f \uff1a" + (storeMaterialsA != null ? storeMaterialsA.size() : 0));
            }
            catch (Exception el) {
                el.printStackTrace();
                this.log.error("\u4ed3\u5e93\u6570\u636e\u83b7\u53d6\u5f02\u5e38 ", (Throwable)el);
                baseJsonVoObject.setStatus(500);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u4ed3\u5e93\u6570\u636e\u83b7\u53d6\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            try {
                timenew12 = System.currentTimeMillis();
                baseJsonVo = (BaseJsonVo)threadUtilProNeedDispatchOrderData.toRunTask("threadUtilProNeedDispatchOrderData");
                if (baseJsonVo.getStatus() == 200) {
                    saleMaterials = (List)baseJsonVo.getValue();
                }
                timenew23 = System.currentTimeMillis();
                this.log.info("\u83b7\u53d6\u53d1\u8d27\u5355\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew23 - timenew12) + " \u6beb\u79d2 \u5927\u5c0f \uff1a" + (saleMaterials != null ? saleMaterials.size() : 0));
            }
            catch (Exception e) {
                e.printStackTrace();
                baseJsonVoObject.setStatus(500);
                this.log.error("OMS\u6570\u636e\u83b7\u53d6\u5f02\u5e38 ", (Throwable)e);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u9500\u552e\u53d1\u8d27\u5355\u6570\u636e\u83b7\u53d6\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            try {
                timenew12 = System.currentTimeMillis();
                predictMaterialsBeforTwoDays = (List)threadUtilpredictMaterialsBeforTwoDays.toRunTask("threadUtilpredictMaterialsBeforTwoDays");
                Set checkPredictSums = this.checkPredictSumFreshness(predictMaterialsBeforTwoDays);
                if (checkPredictSums.size() > 0) {
                    baseJsonVoObject.setStatus(500);
                    baseJsonVoObject.setMessage(new Gson().toJson((Object)checkPredictSums));
                    return baseJsonVoObject;
                }
                Collections.sort(predictMaterialsBeforTwoDays, new /* Unavailable Anonymous Inner Class!! */);
                timenew22 = System.currentTimeMillis();
                this.log.info("\u83b7\u53d6\u9884\u6d4b\u6c47\u603b\u6570\u636e\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew22 - timenew12) + " \u6beb\u79d2 \u5927\u5c0f \uff1a" + (predictMaterialsBeforTwoDays != null ? predictMaterialsBeforTwoDays.size() : 0));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("\u83b7\u53d6\u9884\u6d4b\u6c47\u603b\u5f02\u5e38 ", (Throwable)e);
                baseJsonVoObject.setStatus(500);
                baseJsonVoObject.setMessage("\u83b7\u53d6\u9884\u6d4b\u6c47\u603b\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            try {
                timenew12 = System.currentTimeMillis();
                predictDetaiBeforTwoDays = (List)threadUtilpredictDetaiBeforTwoDays.toRunTask("threadUtilpredictDetaiBeforTwoDays");
                Set checkPredictDetailFreshness = this.checkPredictDetailFreshness(predictDetaiBeforTwoDays);
                if (checkPredictDetailFreshness.size() > 0) {
                    baseJsonVoObject.setStatus(500);
                    baseJsonVoObject.setMessage(new Gson().toJson((Object)checkPredictDetailFreshness));
                    return baseJsonVoObject;
                }
                Collections.sort(predictDetaiBeforTwoDays, new /* Unavailable Anonymous Inner Class!! */);
                timenew22 = System.currentTimeMillis();
                this.log.info("\u83b7\u53d6\u9884\u6d4b\u8be6\u60c5\u6570\u636e\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew22 - timenew12) + " \u6beb\u79d2 \u5927\u5c0f \uff1a" + (predictDetaiBeforTwoDays != null ? predictDetaiBeforTwoDays.size() : 0));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("\u83b7\u53d6\u9884\u6d4b\u8be6\u60c5\u5f02\u5e38 ", (Throwable)e);
                baseJsonVoObject.setStatus(500);
                baseJsonVoObject.setMessage("\u83b7\u53d6\u9884\u6d4b\u8be6\u60c5\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            try {
                timenew12 = System.currentTimeMillis();
                baseJsonVoallocation = (BaseJsonVo)threadUtilIcAllotDetailPro.toRunTask("threadUtilIcAllotDetailPro");
                if (baseJsonVoallocation.getStatus() == 200) {
                    allocationMaterials = (List)baseJsonVoallocation.getValue();
                }
                timenew2 = System.currentTimeMillis();
                this.log.info("\u83b7\u53d6WMS\u6570\u636e\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew2 - timenew12) + " \u6beb\u79d2 \u5927\u5c0f \uff1a" + (allocationMaterials != null ? allocationMaterials.size() : 0));
            }
            catch (Exception e) {
                e.printStackTrace();
                baseJsonVoObject.setStatus(500);
                this.log.error("WMS\u6570\u636e\u83b7\u53d6\u5f02\u5e38 ", (Throwable)e);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u8c03\u62e8\u5355\u6570\u636e\u83b7\u53d6\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            try {
                timenew12 = System.currentTimeMillis();
                baseJsonVoTransportAllocation = (BaseJsonVo)threadUtilbaseJsonVoTransportAllocation.toRunTask("threadUtilbaseJsonVoTransportAllocation");
                if (baseJsonVoTransportAllocation.getStatus() == 200) {
                    transportAllocationDatas = (List)baseJsonVoTransportAllocation.getValue();
                }
                timenew2 = System.currentTimeMillis();
                this.log.info("\u83b7\u53d6\u8c03\u62e8\u8ba1\u5212\u6570\u636e\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew2 - timenew12) + " \u6beb\u79d2 \u5927\u5c0f \uff1a" + (transportAllocationDatas != null ? transportAllocationDatas.size() : 0));
            }
            catch (Exception e) {
                e.printStackTrace();
                baseJsonVoObject.setStatus(500);
                this.log.error("\u8c03\u62e8\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458 ", (Throwable)e);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u8c03\u62e8\u8ba1\u5212\u914d\u7f6e\u6570\u636e\u83b7\u53d6\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            long time7 = System.currentTimeMillis();
            this.log.info("\u5e93\u5b58\u5e73\u8861 \u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u8017\u65f6 =============\u300b " + (time7 - time3) + " \u6beb\u79d2");
            this.checkProMatClassId(storeMaterials);
            List list = null;
            try {
                list = BalancEinventoryBuildData.addBalancEinventorys((List)storeMaterials, (List)saleMaterials, (List)predictMaterialsBeforTwoDays, (List)allocationMaterials, (List)transportAllocationDatas, (List)predictDetaiBeforTwoDays, (String)flag);
            }
            catch (Exception e) {
                baseJsonVoObject.setStatus(500);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5e93\u5b58\u5e73\u8861\u6570\u636e\u5904\u7406\u5f02\u5e38\n");
                this.log.error("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458 ", (Throwable)e);
                return baseJsonVoObject;
            }
            this.proBalancEinventoryRelationMapper.deleteAll();
            if (list != null && list.size() > 0) {
                timenew1 = System.currentTimeMillis();
                this.proBalancEinventoryRelationMapper.addRecordsBatch(list);
                long timenew24 = System.currentTimeMillis();
                this.log.info("\u5e73\u8861\u6570\u636e\u63d2\u5165\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew24 - timenew1) + " \u6beb\u79d2");
                this.proBalancEinventoryRelationMapper.updatedispatch();
                this.proBalancEinventoryRelationMapper.updateallot();
                this.proBalancEinventoryRelationMapper.updatePredictSum();
                this.proBalancEinventoryRelationMapper.updatePredict();
                long timenew3 = System.currentTimeMillis();
                this.log.info("\u53cd\u66f4\u5e73\u8861\u6570\u636e\u63d2\u5165\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew3 - timenew24) + " \u6beb\u79d2");
            }
            timenew1 = System.currentTimeMillis();
            List loadList = this.proBalancEinventoryRelationMapper.toRelationData(null);
            this.changeproDatas(storeMaterials, loadList);
            if (storeMaterials != null && storeMaterials.size() > 0) {
                this.proStoreMaterialMapper.updateMatchingBatch(storeMaterials);
                this.log.info("\u66f4\u65b0\u521d\u59cb\u91cf\u6709\u6548\u91cf\u5927\u5c0f==============\u300b\u300b\u300b\u300b\u300b\u300b " + storeMaterials.size());
            }
            long timenew25 = System.currentTimeMillis();
            this.log.info("\u66f4\u65b0\u53ef\u652f\u6301\u91cf\u8017\u65f6==============\u300b\u300b\u300b\u300b\u300b\u300b " + (timenew25 - timenew1) + " \u6beb\u79d2");
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJsonVoObject.setStatus(500);
            baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\n" + e.getMessage());
            baseJsonVoObject.setError_msg(System.err.toString());
        }
        long time4 = System.currentTimeMillis();
        this.log.info("=====balancEinventoryService=====\u5e93\u5b58\u6279\u6b21\u5339\u914d\u8017\u65f6  ==\u300b" + (time4 - time3) + "\u6beb\u79d2");
        return baseJsonVoObject;
    }

    private List<ProStoreMaterialEntity> initializeDatas(List<ProStoreMaterialEntity> storeMaterials) throws Exception {
        ArrayList<ProStoreMaterialEntity> list = new ArrayList<ProStoreMaterialEntity>();
        if (storeMaterials != null && storeMaterials.size() > 0) {
            for (ProStoreMaterialEntity proStoreMaterial : storeMaterials) {
                if (proStoreMaterial.getEdbInitialnum() <= 0) continue;
                proStoreMaterial.setInitialnum(null);
                proStoreMaterial.setSurplusnum(null);
                proStoreMaterial.setSiltCargonum(proStoreMaterial.getEdbInitialnum());
                proStoreMaterial.setOccupynum(null);
                proStoreMaterial.setMatchingOccupynum(Integer.valueOf(0));
                if (proStoreMaterial.getProdtime() == null || proStoreMaterial.getEdbInitialnum() == null || proStoreMaterial.getEdbInitialnum() <= 0) continue;
                list.add(proStoreMaterial);
            }
        }
        return list;
    }

    private synchronized void changeproDatas(List<ProStoreMaterialEntity> storeMaterials, List<EinventoryRelationV> loadList) throws Exception {
        this.initialnumDatas(storeMaterials);
        HashMap<String, String> todayMap = new HashMap<String, String>();
        Date today = new Date();
        String startDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)today, (int)1), (String)"yyyyMMdd");
        todayMap.put("startDate", startDate);
        int days = 3;
        String endDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)startDate, (String)"yyyyMMdd"), (int)days), (String)"yyyyMMdd");
        todayMap.put("endDate", endDate);
        LinkedList proFactoryCalendarBuilds = this.proFactoryCalendarBuildMapper.loadList(todayMap);
        for (ProStoreMaterialEntity proStoreMaterialEntity : storeMaterials) {
            LinkedList<ProFactoryCalendarBuildEntity> proFactoryCalendarBuildsNewT = new LinkedList<ProFactoryCalendarBuildEntity>();
            if (proFactoryCalendarBuilds.size() < 1) continue;
            for (ProFactoryCalendarBuildEntity proFactoryCalendar : proFactoryCalendarBuilds) {
                if (!proStoreMaterialEntity.getStoreid().equals(proFactoryCalendar.getStoreid()) || null == proStoreMaterialEntity.getPodMatClassId() || proStoreMaterialEntity.getPodMatClassId().trim().equals("") || !proStoreMaterialEntity.getPodMatClassId().equals(proFactoryCalendar.getPodMatClassId())) continue;
                proFactoryCalendarBuildsNewT.add(proFactoryCalendar);
            }
            if (proFactoryCalendarBuildsNewT.size() < 1) continue;
            int initialnum = this.sumInitialnum(proStoreMaterialEntity, proFactoryCalendarBuildsNewT, loadList);
            if (proStoreMaterialEntity.getTpsmid().equals("1131333995623747699")) {
                StringBuffer sb = new StringBuffer();
                sb.append("========initialnum (" + initialnum + ")= >>>>>  ========>>>>>>>> \n");
                for (EinventoryRelationV einventoryRelationV : loadList) {
                    if (!einventoryRelationV.getEinventoryid().equals("1131333995623747699") || !einventoryRelationV.getRelationtype().equals("t_pro_predict_detail") || einventoryRelationV.getOccupynum() != 40) continue;
                    sb.append(new Gson().toJson((Object)einventoryRelationV) + "\n");
                }
                sb.append(new Gson().toJson((Object)proStoreMaterialEntity) + "\n" + new Gson().toJson(proFactoryCalendarBuildsNewT));
                this.log.info(sb.toString());
            }
            if (initialnum == 0) {
                proStoreMaterialEntity.setInitialnum(Integer.valueOf(initialnum));
                proStoreMaterialEntity.setSurplusnum(null);
                proStoreMaterialEntity.setSurplusnum(Integer.valueOf(initialnum));
                continue;
            }
            proStoreMaterialEntity.setInitialnum(Integer.valueOf(initialnum));
            proStoreMaterialEntity.setSurplusnum(Integer.valueOf(initialnum));
        }
    }

    private void checkProMatClassId(List<ProStoreMaterialEntity> storeMaterials) throws Exception {
        String message = "";
        HashSet<String> matids = new HashSet<String>();
        if (storeMaterials != null && storeMaterials.size() > 0) {
            for (ProStoreMaterialEntity proStoreMateria : storeMaterials) {
                if (null != proStoreMateria.getPodMatClassId() && !proStoreMateria.getPodMatClassId().trim().equals("") || matids.contains(proStoreMateria.getMatid())) continue;
                message = message + "( \u540d\u79f0 :  " + proStoreMateria.getMatname() + "  id : " + proStoreMateria.getMatid() + "  code : " + proStoreMateria.getMatcode() + " )\n<br>";
                matids.add(proStoreMateria.getMatid());
            }
        }
        if (!message.equals("")) {
            throw new RuntimeException(message + "\n \u4ee5\u4e0a\u7269\u54c1\u672a\u8bbe\u7f6e\u751f\u4ea7\u5206\u7c7b,\u8bf7\u5230\u7269\u54c1\u751f\u4ea7\u5c5e\u6027\u914d\u7f6e\u9875\u8fdb\u884c\u914d\u7f6e\u3002<br>");
        }
    }

    private void initialnumDatas(List<ProStoreMaterialEntity> storeMaterials) throws Exception {
        if (storeMaterials != null && storeMaterials.size() > 0) {
            for (ProStoreMaterialEntity proStoreMaterialEntity : storeMaterials) {
                proStoreMaterialEntity.setInitialnum(null);
                proStoreMaterialEntity.setSurplusnum(null);
                proStoreMaterialEntity.setOccupynum(null);
            }
        }
    }

    private synchronized int sumInitialnum(ProStoreMaterialEntity proStoreMaterialEntity, List<ProFactoryCalendarBuildEntity> proFactoryCalendarBuildsNewT, List<EinventoryRelationV> loadList) throws Exception {
        int sum = 0;
        block0: for (EinventoryRelationV einventoryRelation : loadList) {
            if (!proStoreMaterialEntity.getStoreid().equals(einventoryRelation.getStoreid()) || !einventoryRelation.getStoreid().equals(einventoryRelation.getBalancStoreid()) || !proStoreMaterialEntity.getMatid().equals(einventoryRelation.getMatid()) || !DateUtils.formatDate((Date)proStoreMaterialEntity.getProdtime(), (String)"yyyyMMdd").equals(einventoryRelation.getProDate()) || !einventoryRelation.getEinventoryid().equals(proStoreMaterialEntity.getTpsmid()) || einventoryRelation.getType() != 2 || proStoreMaterialEntity.getDatatpye() != einventoryRelation.getDatatpye() || proFactoryCalendarBuildsNewT == null || proFactoryCalendarBuildsNewT.size() < 1) continue;
            Long pickupdate = Long.valueOf(einventoryRelation.getPickupdate());
            for (ProFactoryCalendarBuildEntity proFactoryCalendarBuild : proFactoryCalendarBuildsNewT) {
                Long startTimeL = Long.valueOf(proFactoryCalendarBuild.getStartdate());
                Long endTimeL = Long.valueOf(proFactoryCalendarBuild.getEnddate());
                if (pickupdate < startTimeL || pickupdate > endTimeL) continue;
                sum += einventoryRelation.getOccupynum().intValue();
                continue block0;
            }
        }
        return sum;
    }

    public BaseJsonVo<List<EinventoryRelationV>> findRelationData(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            List loadList = this.proBalancEinventoryRelationMapper.findRelationData(param);
            Collections.sort(loadList, new /* Unavailable Anonymous Inner Class!! */);
            baseJsonVo.setValue((Object)loadList);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<FreshnessStatisticsV>> freshnessStatistics(Map<String, Object> param) {
        BaseJsonVo bseJsonVo = new BaseJsonVo();
        bseJsonVo.setStatus(200);
        Date date = new Date();
        String today = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
        try {
            List freshnessStatistics = this.freshnessStatisticsDao.getFreshnessStatisticsByProStoreMaterial(param);
            List list1 = this.proStoreMaterialMapper.findList(param);
            this.sumSiltCargonum(freshnessStatistics, list1, today, date);
            this.sumEinventoryRelationV(freshnessStatistics, today, date);
            List proMaterialPlanHistoryOccupys = this.proMaterialPlanHistoryOccupyDao.findTosupportAmount(today);
            this.PlanHistoryOccupyToFreshnessStatisticsV(freshnessStatistics, proMaterialPlanHistoryOccupys, today);
            bseJsonVo.setValue((Object)freshnessStatistics);
        }
        catch (Exception e) {
            e.printStackTrace();
            bseJsonVo.setStatus(500);
            bseJsonVo.setMessage(e.getMessage());
        }
        return bseJsonVo;
    }

    private void sumSiltCargonum(List<FreshnessStatisticsV> freshnessStatistics, List<ProStoreMaterialEntity> list1, String today, Date date) {
        if (freshnessStatistics.size() > 0) {
            for (FreshnessStatisticsV freshnessStatisticsV : freshnessStatistics) {
                int satrtTime = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)(-freshnessStatisticsV.getFreshness().intValue())), (String)"yyyyMMdd"));
                int endTime = Integer.valueOf(today);
                int sum = 0;
                for (ProStoreMaterialEntity proStoreMaterial : list1) {
                    int datenew = Integer.valueOf(DateUtils.formatDate((Date)proStoreMaterial.getProdtime(), (String)"yyyyMMdd"));
                    if (satrtTime > datenew || datenew > endTime || !freshnessStatisticsV.getMatId().equals(proStoreMaterial.getMatid()) || !freshnessStatisticsV.getStoreId().equals(proStoreMaterial.getStoreid())) continue;
                    sum += proStoreMaterial.getSiltCargonum().intValue();
                }
                freshnessStatisticsV.setSum(Integer.valueOf(sum));
            }
        }
    }

    private void sumEinventoryRelationV(List<FreshnessStatisticsV> freshnessStatistics, String today, Date date) throws Exception {
        HashMap<String, ProFactoryCalendarBuildV> map = new HashMap<String, ProFactoryCalendarBuildV>();
        if (freshnessStatistics != null && freshnessStatistics.size() > 0) {
            for (FreshnessStatisticsV freshnessStatistic : freshnessStatistics) {
                String key = today + freshnessStatistic.getPodMatClassId() + freshnessStatistic.getStoreId();
                ProFactoryCalendarBuildV proFactoryCalendarBuilsNew = null;
                if (map.keySet().contains(key)) {
                    proFactoryCalendarBuilsNew = (ProFactoryCalendarBuildV)map.get(key);
                } else {
                    proFactoryCalendarBuilsNew = this.proFactoryCalendarBuilDao.findMaxProFactoryCalendarBuilsByToday(today, freshnessStatistic.getPodMatClassId(), freshnessStatistic.getStoreId());
                    map.put(key, proFactoryCalendarBuilsNew);
                }
                if (proFactoryCalendarBuilsNew == null) continue;
                String enddate = proFactoryCalendarBuilsNew.getEnddate();
                String startTime = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)enddate, (String)"yyyyMMdd"), (int)1), (String)"yyyyMMdd");
                List list2 = this.proBalancEinventoryRelationDao.findSumUnnecessaryOccupy(null, freshnessStatistic.getStoreId(), freshnessStatistic.getMatId(), startTime);
                if (list2.size() < 1) continue;
                int satrtTime = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)(-freshnessStatistic.getFreshness().intValue())), (String)"yyyyMMdd"));
                int endTime = Integer.valueOf(today);
                int sum = 0;
                for (EinventoryRelationV einventoryRelationv : list2) {
                    int datenew;
                    if (einventoryRelationv.getType() != 2 || satrtTime > (datenew = Integer.valueOf(einventoryRelationv.getProDate()).intValue()) || datenew > endTime || !freshnessStatistic.getMatId().equals(einventoryRelationv.getMatid()) || !freshnessStatistic.getStoreId().equals(einventoryRelationv.getStoreid())) continue;
                    sum += einventoryRelationv.getOccupynum().intValue();
                }
                freshnessStatistic.setSum(Integer.valueOf(freshnessStatistic.getSum() + sum));
            }
        }
    }

    private void PlanHistoryOccupyToFreshnessStatisticsV(List<FreshnessStatisticsV> set, List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, String today) {
        if (set != null && set.size() > 0) {
            for (FreshnessStatisticsV freshnessStatistics : set) {
                Integer freshness = freshnessStatistics.getFreshness();
                if (proMaterialPlanHistoryOccupys != null && proMaterialPlanHistoryOccupys.size() > 0) {
                    for (ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy : proMaterialPlanHistoryOccupys) {
                        if (!proMaterialPlanHistoryOccupy.getMatid().equals(freshnessStatistics.getMatId()) || !proMaterialPlanHistoryOccupy.getStoreid().equals(freshnessStatistics.getStoreId()) || !this.checkTimePlanHistoryOccupy(freshness, proMaterialPlanHistoryOccupy.getCbatchname(), today)) continue;
                        freshnessStatistics.setOccupynum(Integer.valueOf((freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0) + proMaterialPlanHistoryOccupy.getOccupynum()));
                        freshnessStatistics.setPlanaddnum(Integer.valueOf((freshnessStatistics.getPlanaddnum() != null ? freshnessStatistics.getPlanaddnum() : 0) + (proMaterialPlanHistoryOccupy.getPlanaddnum() != null ? proMaterialPlanHistoryOccupy.getPlanaddnum() : 0)));
                    }
                }
                freshnessStatistics.setSum_occupynum_planaddnum(Integer.valueOf((freshnessStatistics.getSum() != null ? freshnessStatistics.getSum() : 0) - (freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0)));
                int occupynum = freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0;
                int planaddnum = freshnessStatistics.getPlanaddnum() != null ? freshnessStatistics.getPlanaddnum() : 0;
                int C = 0;
                C = planaddnum >= occupynum ? occupynum : planaddnum;
                freshnessStatistics.setSum_occupynum_planaddnum(Integer.valueOf(freshnessStatistics.getSum_occupynum_planaddnum() + C));
            }
        }
    }

    private boolean checkTimePlanHistoryOccupy(Integer freshness, String cbatchname, String today) {
        int startTimeString = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)today, (String)"yyyyMMdd"), (int)(-freshness.intValue())), (String)"yyyyMMdd"));
        int endTimeString = Integer.valueOf(today);
        int timeString = Integer.valueOf(cbatchname);
        return startTimeString <= timeString && timeString <= endTimeString;
    }

    private Set<String> checkPredictDetailFreshness(List<ProPredictDetailEntity> list) {
        HashSet<String> rreturnMsg = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (ProPredictDetailEntity p : list) {
                Boolean flag = true;
                StringBuffer sb = new StringBuffer();
                if (p.getFreshness() != null) continue;
                if (StringUtils.isBlank((CharSequence)p.getCtype())) {
                    rreturnMsg.add("\u8bf7\u5728\u9500\u552e\u7ba1\u7406/\u5ba2\u6237\u6863\u6848~\u8bbe\u7f6e\u5ba2\u6237(" + p.getBctname() + ") - \u7684\u53d1\u8d27\u6a21\u5f0f");
                }
                if (StringUtils.isBlank((CharSequence)p.getPlanningtype())) {
                    rreturnMsg.add("\u8bf7\u5728\u57fa\u7840\u6570\u636e/\u7269\u54c1/\u4e2d\u8bbe\u7f6e~\u7269\u54c1(" + p.getMatname() + ") - \u7684\u8ba1\u5212\u5206\u7c7b");
                    continue;
                }
                if (!p.getConfigureflag().equals("\u5426")) continue;
                rreturnMsg.add("\u8bf7\u5728\u8ba1\u5212\u7ba1\u7406/\u65b0\u9c9c\u5ea6\u914d\u7f6e/\u4e2d\u8bbe\u7f6e~(" + p.getStorename() + "/" + p.getCtype() + "/" + p.getPlanningtype() + ") - \u4ed3\u5e93/\u53d1\u8d27\u6a21\u5f0f/\u7269\u54c1\u8ba1\u5212\u5206\u7c7b/\u65b0\u9c9c\u5ea6");
            }
        }
        return rreturnMsg;
    }

    private Set<String> checkPredictSumFreshness(List<ProPredictSumEntity> list) {
        HashSet<String> rreturnMsg = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (ProPredictSumEntity p : list) {
                Boolean flag = true;
                StringBuffer sb = new StringBuffer();
                if (p.getFreshness() != null) continue;
                rreturnMsg.add("\u9884\u6d4b\u9700\u6c42\u6c47\u603b\u8868(" + p.getMatname() + ") - \u65b0\u9c9c\u5ea6\u4e3a\u7a7a");
            }
        }
        return rreturnMsg;
    }

    static /* synthetic */ ProStoreMaterialMapper access$000(BalancEinventoryServiceImpl x0) {
        return x0.proStoreMaterialMapper;
    }

    static /* synthetic */ OmsServiceClient access$100(BalancEinventoryServiceImpl x0) {
        return x0.omsServiceClient;
    }

    static /* synthetic */ ProPredictSumMapper access$200(BalancEinventoryServiceImpl x0) {
        return x0.proPredictSumMapper;
    }

    static /* synthetic */ ProPredictDetailMapper access$300(BalancEinventoryServiceImpl x0) {
        return x0.proPredictDetailMapper;
    }

    static /* synthetic */ WmsServiceClient access$400(BalancEinventoryServiceImpl x0) {
        return x0.wmsServiceClient;
    }

    static /* synthetic */ ProTransportCalendarService access$500(BalancEinventoryServiceImpl x0) {
        return x0.proTransportCalendarService;
    }
}

