/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.bd.entity.vo.EdbMaterialRelationEntityV;
import cc.lechun.bd.entity.vo.EdbWarehouseRelationEntityV;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.impl.GetEdbDatasDao;
import cc.lechun.pro.dao.impl.ProStoreMaterialDao;
import cc.lechun.pro.entity.FormEdianBaoGetStoreMateral;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.service.GetEdbDataService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GetEdbDataServiceImpl
implements GetEdbDataService {
    @Autowired
    private GetEdbDatasDao getEdbDatasDao;
    @Autowired
    private ProStoreMaterialDao proStoreMaterialDao;
    private Logger log = LoggerFactory.getLogger(GetEdbDataServiceImpl.class);

    @Transactional(rollbackFor={Exception.class})
    public synchronized BaseJsonVo saveEdbAndloclStoreData() {
        long time3 = System.currentTimeMillis();
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        List edBstoreDatas = this.getEdbDatasDao.getEDBstoreDatas();
        if (edBstoreDatas == null || edBstoreDatas.size() < 1) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u672a\u83b7\u53d6\u5230\u6613\u5e97\u5b9d\u7684\u6570\u636e");
            return baseJsonVo;
        }
        List warehouseRelations = this.getEdbDatasDao.getWarehouseRelations();
        if (warehouseRelations == null || warehouseRelations.size() < 1) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u4e3a\u83b7\u53d6\u5230\u4ed3\u5e93\u6620\u5c04\u6570\u636e");
            return baseJsonVo;
        }
        List materialRelations = this.getEdbDatasDao.getMaterialRelations();
        if (warehouseRelations == null || warehouseRelations.size() < 1) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u672a\u83b7\u53d6\u5230\u7269\u54c1\u6620\u5c04\u6570\u636e");
            return baseJsonVo;
        }
        try {
            this.updateDatas(edBstoreDatas, warehouseRelations, materialRelations);
        }
        catch (Exception e) {
            this.log.error("\u540e\u53f0\u5f02\u5e38 \uff1a", (Throwable)e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u540e\u53f0\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        long time4 = System.currentTimeMillis();
        this.log.info("=====saveEdbAndloclStoreData=====edb\u6570\u636e\u8f6c\u6362\u4e3a\u672c\u5730\u6570\u636e\u5e76\u5165\u5e93  ==\u300b" + (time4 - time3) + "\u6beb\u79d2");
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized void updateDatas(List<FormEdianBaoGetStoreMateral> edBstoreDatas, List<EdbWarehouseRelationEntityV> warehouseRelations, List<EdbMaterialRelationEntityV> materialRelations) throws Exception {
        this.getEdbDatasDao.deleteEdbDatasAll();
        if (edBstoreDatas != null && edBstoreDatas.size() > 0) {
            this.getEdbDatasDao.addRecordsBatch(edBstoreDatas);
        }
        List list = this.getEdbDatasDao.gropSumEdbDatas();
        List proStoreMaterials = this.getEdbDatasDao.edbToloclDatas(list, warehouseRelations, materialRelations);
        List proStoreMaterialsmerge = this.mergeErpStoreDatas(proStoreMaterials);
        this.proStoreMaterialDao.deleteAll();
        if (proStoreMaterialsmerge != null && proStoreMaterialsmerge.size() > 0) {
            this.proStoreMaterialDao.addRecordsBatch(proStoreMaterialsmerge);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized BaseJsonVo addAllMatnAndProMat() {
        long time3 = System.currentTimeMillis();
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proStoreMaterialDao.addAllMatnAndProMat();
        }
        catch (Exception e) {
            this.log.error("\u540e\u53f0\u5f02\u5e38 \uff1a", (Throwable)e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u540e\u53f0\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        long time4 = System.currentTimeMillis();
        this.log.info("=====addAllMatnAndProMat====\u83b7\u53d6\u5728\u9014\u5728\u4ea7\u6570\u636e\u5e76\u5165\u5e93  ==\u300b" + (time4 - time3) + "\u6beb\u79d2");
        return baseJsonVo;
    }

    public synchronized List<ProStoreMaterialEntity> mergeErpStoreDatas(List<ProStoreMaterialEntity> proStoreMaterials) throws Exception {
        ArrayList<ProStoreMaterialEntity> list = new ArrayList<ProStoreMaterialEntity>();
        HashMap<String, ProStoreMaterialEntity> map = new HashMap<String, ProStoreMaterialEntity>();
        if (proStoreMaterials != null && proStoreMaterials.size() > 0) {
            for (ProStoreMaterialEntity proStoreMaterial : proStoreMaterials) {
                if (map.containsKey(proStoreMaterial.toOnlyconditions())) {
                    if (((ProStoreMaterialEntity)map.get(proStoreMaterial.toOnlyconditions())).getEdbInitialnum() != null) {
                        if (proStoreMaterial.getEdbInitialnum() == null) continue;
                        ((ProStoreMaterialEntity)map.get(proStoreMaterial.toOnlyconditions())).setEdbInitialnum(Integer.valueOf(((ProStoreMaterialEntity)map.get(proStoreMaterial.toOnlyconditions())).getEdbInitialnum() + proStoreMaterial.getEdbInitialnum()));
                        continue;
                    }
                    if (proStoreMaterial.getEdbInitialnum() == null) continue;
                    ((ProStoreMaterialEntity)map.get(proStoreMaterial.toOnlyconditions())).setEdbInitialnum(proStoreMaterial.getEdbInitialnum());
                    continue;
                }
                map.put(proStoreMaterial.toOnlyconditions(), proStoreMaterial);
            }
        }
        for (Map.Entry value : map.entrySet()) {
            list.add((ProStoreMaterialEntity)value.getValue());
        }
        return list;
    }
}

