/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.apiinvoke.WmsServiceClient;
import cc.lechun.pro.dao.ProAllocationPredictMapper;
import cc.lechun.pro.dao.ProAllocationPredictStoreMaterialMapper;
import cc.lechun.pro.dao.ProAllocationSumMapper;
import cc.lechun.pro.dao.ProFactoryCalendarMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.dao.ProTransportCalendarMapper;
import cc.lechun.pro.dao.ProductAllocationMapper;
import cc.lechun.pro.entity.ProAllocationOccupyRelationEntity;
import cc.lechun.pro.entity.ProAllocationSumEntity;
import cc.lechun.pro.entity.ProFactoryCalendarEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.vo.ProAllocationSumEntityVo;
import cc.lechun.pro.service.ProAllocationSumService;
import cc.lechun.pro.util.AllocationBulidData;
import cc.lechun.pro.util.classfile.AllocationDataIntegration;
import cc.lechun.pro.util.classfile.Allocationbuild;
import cc.lechun.wms.entity.IcAllotDetailEntity;
import cc.lechun.wms.entity.IcAllotEntity;
import cc.lechun.wms.entity.vo.IcAllotVO;
import com.github.pagehelper.PageHelper;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Service
public class ProAllocationSumServiceImpl
implements ProAllocationSumService {
    private Logger log = LoggerFactory.getLogger((String)ProAllocationSumServiceImpl.class.getName());
    @Autowired
    private ProAllocationSumMapper proAllocationSumMapper;
    @Autowired
    private ProTransportCalendarMapper proTransportCalendarMapper;
    @Autowired
    private ProductAllocationMapper productAllocationMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;
    @Autowired
    private ProFactoryCalendarMapper proFactoryCalendarMapper;
    @Autowired
    private ProAllocationPredictStoreMaterialMapper proAllocationPredictStoreMaterialMapper;
    @Autowired
    private ProAllocationPredictMapper proAllocationPredictMapper;
    @Autowired
    private WmsServiceClient wmsServiceClient;

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProAllocationSumEntity> proAllocationSumEntitys, List<String> deleteids) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProAllocationSumEntity> listAdd = new ArrayList<ProAllocationSumEntity>();
            ArrayList<ProAllocationSumEntity> listUpdate = new ArrayList<ProAllocationSumEntity>();
            if (null != proAllocationSumEntitys && proAllocationSumEntitys.size() > 0) {
                for (ProAllocationSumEntity proAllocationSum : proAllocationSumEntitys) {
                    if (StringUtils.isNotBlank((String)proAllocationSum.getId())) {
                        listUpdate.add(proAllocationSum);
                        continue;
                    }
                    proAllocationSum.setId(IDGenerate.getUniqueIdStr());
                    listAdd.add(proAllocationSum);
                }
            }
            if (listAdd.size() > 0) {
                this.proAllocationSumMapper.addRecordsBatch(listAdd);
            }
            if (listUpdate.size() > 0) {
                this.proAllocationSumMapper.updateBatch(listUpdate);
            }
            if (deleteids != null && deleteids.size() > 0) {
                this.proAllocationSumMapper.deleteByIds(deleteids);
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProAllocationSumEntity>> findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            param.put("status", 1);
            baseJsonVo.setValue((Object)this.proAllocationSumMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteByIds(@RequestBody List<String> deleteIds) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (deleteIds != null && deleteIds.size() > 0) {
                this.proAllocationSumMapper.deleteByIds(deleteIds);
            } else {
                baseJsonVo.setStatus(500);
                baseJsonVo.setError_msg("deleteIds is null");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo countProMaterialAllocationPlan() {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            Date date = new Date();
            String today = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dytoday", today);
            List proTransportCalendars = this.proTransportCalendarMapper.loadList(map);
            map.clear();
            map.put("startTime", today);
            List productAllocations = this.productAllocationMapper.getProductAllocations(map);
            List proPredictSums = this.proPredictSumMapper.findList(null);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("beforeToday", today);
            paramMap.put("status", 2);
            List proAllocationSumEntitysOld = this.proAllocationSumMapper.loadList(paramMap);
            List proStoreMaterialEntitysA = this.proStoreMaterialMapper.findAll();
            List proStoreMaterialEntits = this.filerDatas(proStoreMaterialEntitysA);
            Allocationbuild allocationbuild = new Allocationbuild();
            AllocationDataIntegration allocationDataIntegration = AllocationBulidData.buildTransportCalendarAndProductAllocation((List)proTransportCalendars, (List)productAllocations, (List)proAllocationSumEntitysOld, (Allocationbuild)allocationbuild, (Date)date);
            List proAllocationSumEntitySuns = AllocationBulidData.buildneedDate((AllocationDataIntegration)allocationDataIntegration, (List)proPredictSums);
            AllocationBulidData.buildAllocationSumpredict((List)proAllocationSumEntitySuns, (List)proPredictSums, (Allocationbuild)allocationbuild);
            AllocationBulidData.buildAllocationSumpredictStore((List)proStoreMaterialEntits, (Allocationbuild)allocationbuild);
            this.proAllocationSumMapper.deleteByParam(null);
            if (allocationbuild.getProAllocationSumEntitys() != null && allocationbuild.getProAllocationSumEntitys().size() > 0) {
                this.proAllocationSumMapper.addRecordsBatch(allocationbuild.getProAllocationSumEntitys());
            }
            if (allocationbuild.getProAllocationPredictEntitys() != null && allocationbuild.getProAllocationPredictEntitys().size() > 0) {
                this.proAllocationPredictMapper.deleteAll();
                this.proAllocationPredictMapper.addRecordsBatch(allocationbuild.getProAllocationPredictEntitys());
            }
            if (allocationbuild.getProAllocationPredictStoreMaterialEntitys() != null && allocationbuild.getProAllocationPredictStoreMaterialEntitys().size() > 0) {
                this.proAllocationPredictStoreMaterialMapper.deleteAll();
                this.proAllocationPredictStoreMaterialMapper.addRecordsBatch(allocationbuild.getProAllocationPredictStoreMaterialEntitys());
            }
            if (allocationbuild.getProStoreMaterialEntitys() != null && allocationbuild.getProStoreMaterialEntitys().size() > 0) {
                this.proStoreMaterialMapper.updateBatch(allocationbuild.getProStoreMaterialEntitys());
            }
            if (allocationbuild.getProAllocationSumEntitys() != null && allocationbuild.getProAllocationSumEntitys().size() > 0) {
                this.proAllocationSumMapper.updateAllocationSum();
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo completeProAllocation(BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            String today = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
            Integer statusNew = 2;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("today", today);
            map.put("status", statusNew);
            baseJsonVo = this.sendAllocationBille(user);
            if (baseJsonVo.getStatus() == 200) {
                this.proAllocationSumMapper.updateByTodayAndStauts(map);
            } else {
                this.log.error(" sendAllocationBille  ===== >" + new Gson().toJson((Object)baseJsonVo));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    private BaseJsonVo sendAllocationBille(BaseUser user) throws Exception {
        BaseJsonVo baseJson = new BaseJsonVo();
        baseJson.setStatus(200);
        Date date = new Date();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("today", DateUtils.formatDate((Date)date, (String)"yyyyMMdd"));
        List list = this.proAllocationSumMapper.findBuildAllocation(map);
        if (list == null || list.size() == 0) {
            baseJson.setStatus(500);
            baseJson.setMessage("\u65e0\u751f\u6210\u8c03\u62e8\u5355\u6240\u9700\u7684\u8c03\u62e8\u8ba1\u5212\u6570\u636e");
            return baseJson;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (ProAllocationSumEntityVo pas : list) {
            if (newMap.keySet().contains(pas.getOnlyOne())) {
                if (newMap.get(pas.getOnlyOne()) != null) {
                    ((List)newMap.get(pas.getOnlyOne())).add(pas);
                    continue;
                }
                newMap.put(pas.getOnlyOne(), new ArrayList());
                ((List)newMap.get(pas.getOnlyOne())).add(pas);
                continue;
            }
            ArrayList listnew = new ArrayList();
            listnew.add(pas);
            newMap.put(pas.getOnlyOne(), listnew);
        }
        ArrayList<IcAllotVO> newIcAllotVOs = new ArrayList<IcAllotVO>();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : newMap.entrySet()) {
            IcAllotVO icAllotVOs = new IcAllotVO();
            IcAllotEntity icAllot = new IcAllotEntity();
            icAllot.setDdate(date);
            if (user != null) {
                icAllot.setEmpid(user.getEmployeeId());
                icAllot.setCcreator(user.getId());
            }
            icAllot.setDcreatetime(date);
            icAllot.setCremark("\u7531\u8c03\u62e8\u7cfb\u7edf\u751f\u6210\u7684\u5355\u636e");
            icAllot.setAllottype(Integer.valueOf(2));
            icAllot.setIstatus(Integer.valueOf(0));
            ArrayList<IcAllotDetailEntity> add = new ArrayList<IcAllotDetailEntity>();
            for (ProAllocationSumEntityVo proAllocationSumEntity : (List)entry.getValue()) {
                icAllot.setLeadtime(proAllocationSumEntity.getLeadtime());
                icAllot.setLogisticsdate(proAllocationSumEntity.getPlanStartTime());
                icAllot.setEndlogisticsdate(proAllocationSumEntity.getPlanEndTime());
                icAllot.setStoreinid(proAllocationSumEntity.getStoreinId());
                icAllot.setStoreoutid(proAllocationSumEntity.getStoreoutId());
                String endTime = proAllocationSumEntity.getPlanStartTime();
                Integer T = -2;
                String startTime = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)endTime, (String)"yyyyMMdd"), (int)T), (String)"yyyyMMdd");
                String matClass = proAllocationSumEntity.getMatClassId();
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("startTime", startTime);
                param.put("endTime", endTime);
                param.put("matClass", matClass);
                ProFactoryCalendarEntity proFactoryCalendarEntity = this.proFactoryCalendarMapper.findOne(param);
                if (proFactoryCalendarEntity == null) {
                    sb.append("\u7269\u54c1\uff08" + proAllocationSumEntity.getMatName() + "\uff09 \u5206\u7c7b(" + (proAllocationSumEntity.getMatClassName() != null ? proAllocationSumEntity.getMatClassName() : "\u4e3a\u7a7a") + ")  \u672a\u5e76\u914d\u7f6e \u65f6\u95f4\u8303\u56f4\uff08" + startTime + "-" + endTime + "\uff09\u5185\u7684\u751f\u4ea7\u65e5\u5386\u3002<br>");
                }
                if (StringUtils.isNotBlank((String)sb.toString()) || (double)proAllocationSumEntity.getAllocationSum().intValue() < 1.0E-8) continue;
                IcAllotDetailEntity iad = new IcAllotDetailEntity();
                iad.setCmatid(proAllocationSumEntity.getMatId());
                iad.setIqty(new BigDecimal(proAllocationSumEntity.getAllocationSum()));
                iad.setUnitid(proAllocationSumEntity.getUnitId());
                iad.setCbatchname(proFactoryCalendarEntity.getProDay());
                iad.setCremark("\u65e0\u5e93\u5b58\u6570\u636e");
                add.add(iad);
            }
            icAllotVOs.setIcAllot(icAllot);
            icAllotVOs.setAdd(add);
            newIcAllotVOs.add(icAllotVOs);
        }
        if (StringUtils.isNotBlank((String)sb.toString())) {
            baseJson.setStatus(500);
            baseJson.setMessage(sb.toString());
            return baseJson;
        }
        try {
            baseJson = this.wmsServiceClient.saveOrUpdateFromPro(user.getId(), newIcAllotVOs);
            if (baseJson.getStatus() != 200) {
                this.log.error(" wmsServiceClient.saveOrUpdateFromPro  ===== >" + new Gson().toJson((Object)baseJson));
            }
            return baseJson;
        }
        catch (Exception e) {
            this.log.error("\u5fae\u670d\u52a1\u5f02\u5e38WMS", (Throwable)e);
            baseJson.setStatus(500);
            baseJson.setMessage(e.getMessage());
            return baseJson;
        }
    }

    public BaseJsonVo<List<ProAllocationOccupyRelationEntity>> findListrelation(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proAllocationPredictStoreMaterialMapper.findList(param));
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    private List<ProStoreMaterialEntity> filerDatas(List<ProStoreMaterialEntity> proStoreMaterialEntitys) {
        ArrayList<ProStoreMaterialEntity> proStoreMaterialEntitysA = new ArrayList<ProStoreMaterialEntity>();
        if (proStoreMaterialEntitys != null && proStoreMaterialEntitys.size() > 0) {
            for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterialEntitys) {
                if (proStoreMaterialEntity.getInitialnum() == null || proStoreMaterialEntity.getInitialnum() <= 0 || proStoreMaterialEntity.getDatatpye() != 2) continue;
                proStoreMaterialEntity.setSiltCargonum(null);
                proStoreMaterialEntity.setMatchingOccupynum(null);
                proStoreMaterialEntitysA.add(proStoreMaterialEntity);
            }
        }
        return proStoreMaterialEntitysA;
    }
}

