/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.bd.entity.bo.MaterialEntityBO;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.serviceresult.Message;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.apiinvoke.CodingSchemeServiceClient;
import cc.lechun.pro.apiinvoke.MaterialServiceClient;
import cc.lechun.pro.apiinvoke.WmsServiceClient;
import cc.lechun.pro.dao.ProMaterialPlanMapper;
import cc.lechun.pro.dao.ProStoreOccupyRelationMapper;
import cc.lechun.pro.dao.impl.ProFactoryCalendarBuilDao;
import cc.lechun.pro.dao.impl.ProMaterialPlanHistoryOccupyDao;
import cc.lechun.pro.dao.impl.ProPredictDetailDao;
import cc.lechun.pro.entity.ProMaterialPlanEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.vo.ProFactoryCalendarBuildV;
import cc.lechun.pro.entity.vo.ProMaterialPlanV;
import cc.lechun.pro.service.ProMaterialPlanService;
import cc.lechun.pro.service.ProStoreMaterialService;
import cc.lechun.wms.entity.OutPutDetailEntity;
import cc.lechun.wms.entity.OutPutEntity;
import cc.lechun.wms.entity.vo.OutPutVO;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Service
public class ProMaterialPlanServiceImpl
implements ProMaterialPlanService {
    @Autowired
    private ProMaterialPlanMapper proMaterialPlanMapper;
    @Autowired
    private WmsServiceClient wmsServiceClient;
    @Autowired
    private MaterialServiceClient materialServiceClient;
    @Autowired
    private CodingSchemeServiceClient codingSchemeServiceClient;
    @Autowired
    private ProStoreOccupyRelationMapper proStoreOccupyRelationMapper;
    @Autowired
    private ProMaterialPlanHistoryOccupyDao proMaterialPlanHistoryOccupyDao;
    @Autowired
    private ProStoreMaterialService proStoreMaterialService;
    @Autowired
    private ProFactoryCalendarBuilDao proFactoryCalendarBuilDao;
    @Autowired
    private ProPredictDetailDao proPredictDetailDao;
    private Logger log = LoggerFactory.getLogger(ProMaterialPlanServiceImpl.class);

    public BaseJsonVo findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            List loadList = this.proMaterialPlanMapper.loadList(param);
            if (param != null && param.get("panstatusNo") != null && param.get("panstatusNo").equals("1") && loadList != null && loadList.size() > 0) {
                for (ProMaterialPlanEntity proMaterialPlanEntity : loadList) {
                    if (proMaterialPlanEntity.getActuallyfinishnum() != null) continue;
                    proMaterialPlanEntity.setActuallyfinishnum(proMaterialPlanEntity.getPlannum());
                }
            }
            if (loadList.size() > 0) {
                String today = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
                for (ProMaterialPlanV proMaterialPlanV : loadList) {
                    List proFactoryCalendarBuildVs;
                    if (Integer.valueOf(proMaterialPlanV.getPantime()) < Integer.valueOf(today) || (proFactoryCalendarBuildVs = this.proFactoryCalendarBuilDao.loadListByPro(proMaterialPlanV.getFactoryid(), proMaterialPlanV.getPantime(), proMaterialPlanV.getMatpodclassid())).size() <= 0) continue;
                    Integer sum = 0;
                    for (ProFactoryCalendarBuildV proFactoryCalendarBuildV : proFactoryCalendarBuildVs) {
                        Integer sum2 = this.proPredictDetailDao.findSumProPredictNumByPro(proFactoryCalendarBuildV.getStoreid(), proFactoryCalendarBuildV.getStartdate(), proFactoryCalendarBuildV.getEnddate(), proMaterialPlanV.getMatid());
                        if (sum2 == null) continue;
                        sum = sum + sum2;
                    }
                    if (sum <= 0) continue;
                    proMaterialPlanV.setMaxiAddmum(sum);
                }
            }
            baseJsonVo.setValue((Object)loadList);
        }
        catch (Exception e) {
            this.log.error("\u5f02\u5e38 \uff1a ", (Throwable)e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdate(BaseUser user, @RequestBody List<ProMaterialPlanV> proMaterialPlanEntitys, List<String> ids) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (proMaterialPlanEntitys != null && proMaterialPlanEntitys.size() > 0) {
                ArrayList<ProMaterialPlanV> adlist = new ArrayList<ProMaterialPlanV>();
                ArrayList<ProMaterialPlanV> updates = new ArrayList<ProMaterialPlanV>();
                for (ProMaterialPlanV proMaterialPlanEntity : proMaterialPlanEntitys) {
                    if (StringUtils.isNotBlank((String)proMaterialPlanEntity.getPlanid())) {
                        updates.add(proMaterialPlanEntity);
                        continue;
                    }
                    proMaterialPlanEntity.setPlanid(IDGenerate.getUniqueIdStr());
                    proMaterialPlanEntity.setPanstatus(Integer.valueOf(1));
                    proMaterialPlanEntity.setCreattime(new Date());
                    adlist.add(proMaterialPlanEntity);
                }
                if (updates.size() > 0) {
                    this.proMaterialPlanMapper.updateBatch(updates);
                    this.saveProMaterialPlanHistoryOccupy(updates);
                }
                if (adlist.size() > 0) {
                    this.proMaterialPlanMapper.addRecordsBatch(adlist);
                }
            }
            if (ids != null && ids.size() > 0) {
                this.proMaterialPlanMapper.deleteListByIds(ids);
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    private void saveProMaterialPlanHistoryOccupy(List<ProMaterialPlanV> proMaterialPlanEntitys) throws Exception {
        if (proMaterialPlanEntitys != null && proMaterialPlanEntitys.size() > 0) {
            for (ProMaterialPlanV proMaterialPlan : proMaterialPlanEntitys) {
                if (!proMaterialPlan.getSource().equals("system")) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("proDateTime", proMaterialPlan.getPantime());
                map.put("matid", proMaterialPlan.getMatid());
                List proStoreOccupyRelations = this.proStoreOccupyRelationMapper.findAll(map);
                List list = this.proStoreMaterialService.saveProMaterialPlanHistoryOccupy(proMaterialPlan, proStoreOccupyRelations);
                this.proMaterialPlanHistoryOccupyDao.savesFromChangePlan(list);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo issuedUpdateList(BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            String dateAddOneDay = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (user != null) {
                map.put("plantime", dateAddOneDay);
                map.put("userName", user.getEmployeeName());
                map.put("date", new Date());
                this.proMaterialPlanMapper.updateIssued(map);
            } else {
                map.put("plantime", dateAddOneDay);
                map.put("userName", null);
                map.put("date", new Date());
                this.proMaterialPlanMapper.updateIssued(map);
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseJsonVo finishInToStoreUpdateList(BaseUser user, @RequestBody List<ProMaterialPlanV> proMaterialPlanEntitys) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            for (ProMaterialPlanV proMaterialPlanEntity : proMaterialPlanEntitys) {
                Date date = new Date();
                proMaterialPlanEntity.setVerifier(user.getEmployeeName());
                proMaterialPlanEntity.setVerifytime(date);
                proMaterialPlanEntity.setActuallyfinishtime(date);
                proMaterialPlanEntity.setPanstatus(Integer.valueOf(3));
            }
            OutPutVO outPutVO = this.toOutPutVO(user, proMaterialPlanEntitys);
            Message message = null;
            try {
                message = this.wmsServiceClient.saveOrUpdateFormMaterialPlan(user.getId(), outPutVO);
            }
            catch (Exception e) {
                e.printStackTrace();
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u63a8\u9001\u8c03\u62e8\u5355\u6570\u636e\u53d1\u9001\u5931\u8d25");
                return baseJsonVo;
            }
            this.proMaterialPlanMapper.updateBatch(proMaterialPlanEntitys);
            if (StringUtils.isBlank((String)user.getCtenantid())) {
                this.codingSchemeServiceClient.updategenerateCode("043", user.getCtenantid());
            } else {
                this.codingSchemeServiceClient.updategenerateCode("043", user.getCtenantid());
            }
            if (message.getSuccess()) return baseJsonVo;
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    private OutPutVO toOutPutVO(BaseUser user, List<ProMaterialPlanV> proMaterialPlanEntitys) {
        OutPutVO outPutVO = new OutPutVO();
        ArrayList<OutPutDetailEntity> add = new ArrayList<OutPutDetailEntity>();
        ArrayList<String> ids = new ArrayList<String>();
        for (ProMaterialPlanV proMaterialPlanEntity : proMaterialPlanEntitys) {
            OutPutDetailEntity outPutDetailEntity = new OutPutDetailEntity();
            outPutDetailEntity.setcTenantId(user.getCtenantid());
            outPutDetailEntity.setMat_id(proMaterialPlanEntity.getMatid());
            ids.add(proMaterialPlanEntity.getMatid());
            outPutDetailEntity.setStore_id(proMaterialPlanEntity.getStoreid());
            if (proMaterialPlanEntity.getActuallyfinishnum() != null) {
                outPutDetailEntity.setiQty(new BigDecimal(proMaterialPlanEntity.getActuallyfinishnum()));
            } else {
                outPutDetailEntity.setiQty(new BigDecimal(0));
            }
            add.add(outPutDetailEntity);
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("ids", ids);
        try {
            List getlist = this.materialServiceClient.getMaterialsByToParam("0", "0", map);
            if (getlist != null && getlist.size() > 0 && add.size() > 0) {
                block3: for (OutPutDetailEntity outPutDetailEntity : add) {
                    for (MaterialEntityBO materialEntityBO : getlist) {
                        if (!outPutDetailEntity.getMat_id().equals(materialEntityBO.getCguid())) continue;
                        outPutDetailEntity.setUnit_id(materialEntityBO.getCunitid());
                        continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        outPutVO.setAdd(add);
        OutPutEntity outPut = new OutPutEntity();
        if (StringUtils.isBlank((String)user.getCtenantid())) {
            outPut.setcBillCode(this.codingSchemeServiceClient.generateCode("043", "300846"));
        } else {
            outPut.setcBillCode(this.codingSchemeServiceClient.generateCode("043", user.getCtenantid()));
        }
        outPut.setdDate(DateUtils.currentDate());
        outPut.setiType(Integer.valueOf(3));
        outPut.setOsType(Integer.valueOf(1));
        outPut.setEmp_id(user.getEmployeeId());
        outPut.setcRemark("\u7531\u751f\u4ea7\u5165\u5e93\u63a8\u9001\u6570\u636e,\u804c\u5458\u9ed8\u8ba4\u4e3a\u63a8\u9001\u8d26\u6237\u5173\u8054\u804c\u5458\u4fe1\u606f(\u8bf7\u6309\u5b9e\u9645\u9700\u6c42\u53d8\u66f4\u804c\u5458),\u5355\u4f4d\u9ed8\u8ba4\u4e3a\u76d2(\u81ea\u52a8\u5339\u914d\u7269\u54c1\u7269\u54c1\u8ba1\u91cf\u5355\u4f4d,\u5982\u4e0d\u662f\u76d2,\u8bf7\u53d8\u66f4\u4e3a\u76d2)");
        outPutVO.setOutPut(outPut);
        return outPutVO;
    }

    public BaseJsonVo<List<ProStoreMaterialEntity>> checkPlanSum() {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            String dateAddOneDay = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
            List list = this.proMaterialPlanMapper.findCheckPlanSum(dateAddOneDay);
            if (list != null && list.size() > 0) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage("\u5f53\u65e5\u6392\u4ea7\u6570\u636e\u5df2\u7ecf\u751f\u6210\u4e0b\u8fbe\u6570\u636e,\u6545\u65e0\u6cd5\u518d\u6b21\u8ba1\u7b97");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<String> crateProPlanMailContent() {
        BaseJsonVo basejson = new BaseJsonVo();
        basejson.setStatus(200);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("panstatus", 2);
        param.put("pantimeBefore", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd"));
        List list = this.proMaterialPlanMapper.loadList(param);
        List list2 = this.filterProMaterialPlanPlannumEq0(list);
        Map map = this.gtoCrateProPlanMailContentDatas(list2);
        StringBuffer sb = new StringBuffer();
        for (Map.Entry mapObj : map.entrySet()) {
            int sum = 0;
            sb.append((String)mapObj.getKey() + " \u751f\u4ea7\u6570\u91cf<br>");
            for (Map.Entry mapObj2 : ((Map)mapObj.getValue()).entrySet()) {
                sb.append((String)mapObj2.getKey() + " \uff1a ");
                for (ProMaterialPlanV proMaterialPlan : (LinkedList)mapObj2.getValue()) {
                    sb.append(proMaterialPlan.getMatname() + " [" + proMaterialPlan.getPlannum() + "] ,");
                    sum += proMaterialPlan.getPlannum().intValue();
                }
            }
            sb.append("<br>");
            sb.append("\u5408\u8ba1 \uff1a" + sum + "<br>");
        }
        basejson.setValue((Object)sb.toString());
        return basejson;
    }

    public Map<String, Map<String, LinkedList<ProMaterialPlanV>>> gtoCrateProPlanMailContentDatas(List<ProMaterialPlanV> list) {
        LinkedHashMap<String, Map<String, LinkedList<ProMaterialPlanV>>> map = new LinkedHashMap<String, Map<String, LinkedList<ProMaterialPlanV>>>();
        if (list != null && list.size() > 0) {
            for (ProMaterialPlanV proMaterialPlan : list) {
                LinkedHashMap<String, Object> mapnew;
                if (map.containsKey(proMaterialPlan.getPantime())) {
                    if (((Map)map.get(proMaterialPlan.getPantime())).containsKey(proMaterialPlan.getMatpodclassName())) {
                        ((LinkedList)((Map)map.get(proMaterialPlan.getPantime())).get(proMaterialPlan.getMatpodclassName())).add(proMaterialPlan);
                        continue;
                    }
                    mapnew = new LinkedHashMap();
                    mapnew.put(proMaterialPlan.getMatpodclassName(), new /* Unavailable Anonymous Inner Class!! */);
                    map.put(proMaterialPlan.getPantime(), mapnew);
                    continue;
                }
                mapnew = new LinkedHashMap<String, Object>();
                mapnew.put(proMaterialPlan.getMatpodclassName(), new /* Unavailable Anonymous Inner Class!! */);
                map.put(proMaterialPlan.getPantime(), mapnew);
            }
        }
        return map;
    }

    private List<ProMaterialPlanV> filterProMaterialPlanPlannumEq0(List<ProMaterialPlanV> list) {
        ArrayList<ProMaterialPlanV> listNew = new ArrayList<ProMaterialPlanV>();
        if (list != null && list.size() > 0) {
            for (ProMaterialPlanV proMaterialPlan : list) {
                if (proMaterialPlan.getPlannum() == null || proMaterialPlan.getPlannum() < 1) continue;
                listNew.add(proMaterialPlan);
            }
        }
        return listNew;
    }
}

