/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.api.ProPredictMatSumService;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.entity.ProPredictSumEntity;
import cc.lechun.pro.entity.vo.ProPredictSumV;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Service
public class ProPredictMatSumServiceImpl
implements ProPredictMatSumService {
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProPredictSumEntity> mtFreshnessEntitys) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProPredictSumEntity> ListAdd = new ArrayList<ProPredictSumEntity>();
            ArrayList<ProPredictSumEntity> ListUpdate = new ArrayList<ProPredictSumEntity>();
            if (mtFreshnessEntitys != null && mtFreshnessEntitys.size() > 0) {
                String preordercode = "";
                for (ProPredictSumEntity matFreshnessEntity : mtFreshnessEntitys) {
                    if (StringUtils.isNotBlank((CharSequence)matFreshnessEntity.getGuid())) {
                        ListUpdate.add(matFreshnessEntity);
                    } else {
                        matFreshnessEntity.setGuid(IDGenerate.getUniqueIdStr());
                        ListAdd.add(matFreshnessEntity);
                    }
                    if (!preordercode.equals("")) continue;
                    preordercode = matFreshnessEntity.getPreordercode();
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("preordercode", preordercode);
                this.proPredictSumMapper.deleteByParam(paramMap);
                if (ListAdd.size() > 0) {
                    this.proPredictSumMapper.addRecordsBatch(ListAdd);
                }
                if (ListUpdate.size() > 0) {
                    this.proPredictSumMapper.updateBatch(ListUpdate);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            throw e;
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdate(@RequestBody ProPredictSumEntity mtFreshnessEntity) {
        ArrayList<ProPredictSumEntity> List2 = new ArrayList<ProPredictSumEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @RequestMapping(value={"/ppmss/save"})
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo save(@RequestBody ProPredictSumEntity mtFreshnessEntity) {
        ArrayList<ProPredictSumEntity> List2 = new ArrayList<ProPredictSumEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo update(@RequestBody ProPredictSumEntity mtFreshnessEntity) {
        ArrayList<ProPredictSumEntity> List2 = new ArrayList<ProPredictSumEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    public BaseJsonVo<List<ProPredictSumV>> findList(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        if (pageNo == null) {
            pageNo = 0;
        }
        if (pageSize == null) {
            pageSize = 0;
        }
        if (pageNo > 0 && pageSize > 0) {
            PageHelper.startPage((int)pageNo, (int)pageSize);
        }
        try {
            baseJsonVo.setValue((Object)this.proPredictSumMapper.findListNew(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<ProPredictSumV> findById(String guid) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("guid", guid);
        BaseJsonVo result = this.findList(null, null, param);
        if (result.getStatus() == 200) {
            List list = (List)result.getValue();
            if (list != null && list.size() > 0) {
                baseJsonVo.setValue(list.get(0));
            }
        } else {
            baseJsonVo.setStatus(result.getStatus());
            baseJsonVo.setMessage(result.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProPredictSumV>> findByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("guids", guids);
        return this.findList(null, null, param);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo delete(@RequestBody Map<String, Object> pacam) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proPredictSumMapper.deleteByParam(pacam);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteById(String guid) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(guid);
        return this.deleteByIds(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> pacam = new HashMap<String, List<String>>();
        pacam.put("guids", guids);
        return this.delete(pacam);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteByPreordercode(List<String> preordercodes) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("preordercodes", preordercodes);
        try {
            this.delete(map);
            baseJsonVo.setStatus(200);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }
}

