/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.bd.entity.Warehouse;
import cc.lechun.bd.entity.vo.EdbMaterialRelationEntityV;
import cc.lechun.bd.entity.vo.EdbWarehouseRelationEntityV;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.apiinvoke.EdbClient;
import cc.lechun.pro.apiinvoke.EdbMaterialRelationClient;
import cc.lechun.pro.apiinvoke.EdbWarehouseRelationClient;
import cc.lechun.pro.apiinvoke.WarehouseClient;
import cc.lechun.pro.apiinvoke.getdata.pro.edbstoredatas.Edbstoredatas;
import cc.lechun.pro.dao.FormEdianBaoGetStoreMateralMapper;
import cc.lechun.pro.dao.MaterialProdMapper;
import cc.lechun.pro.dao.ProMaterialPlanMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.dao.ProStoreMaterialTypeBuildDataMapper;
import cc.lechun.pro.dao.impl.ProFactoryCalendarBuilDao;
import cc.lechun.pro.dao.impl.ProMaterialPlanHistoryOccupyDao;
import cc.lechun.pro.dao.impl.ProStoreOccupyRelationDao;
import cc.lechun.pro.entity.FormEdianBaoGetStoreMateral;
import cc.lechun.pro.entity.MaterialProdEntity;
import cc.lechun.pro.entity.ProFactoryCalendarEntity;
import cc.lechun.pro.entity.ProMaterialPlanEntity;
import cc.lechun.pro.entity.ProMaterialPlanHistoryOccupyEntity;
import cc.lechun.pro.entity.ProPredictSumEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.ProStoreOccupyRelationEntity;
import cc.lechun.pro.entity.ProStorePredictRangeEntity;
import cc.lechun.pro.entity.ProTransportAllocationData;
import cc.lechun.pro.entity.vo.ProMaterialPlanV;
import cc.lechun.pro.entity.vo.ProStoreOccupyRelationV;
import cc.lechun.pro.service.ProStoreMaterialService;
import cc.lechun.pro.service.ProTransportCalendarService;
import cc.lechun.pro.util.PlanBulidData;
import com.github.pagehelper.PageHelper;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ProStoreMaterialServiceImpl
implements ProStoreMaterialService {
    @Autowired
    private ProStoreMaterialTypeBuildDataMapper proStoreMaterialTypeBuildDataMapper;
    @Autowired
    private WarehouseClient warehouseClient;
    @Autowired
    private MaterialProdMapper materialProdMapper;
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;
    @Autowired
    private ProMaterialPlanMapper proMaterialPlanMapper;
    @Autowired
    private ProStoreOccupyRelationDao proStoreOccupyRelationDao;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private FormEdianBaoGetStoreMateralMapper formEdianBaoGetStoreMateralMapper;
    @Autowired
    private ProFactoryCalendarBuilDao proFactoryCalendarBuilDao;
    @Autowired
    private EdbClient edbClient;
    @Autowired
    private EdbMaterialRelationClient edbMaterialRelationClient;
    @Autowired
    private EdbWarehouseRelationClient edbWarehouseRelationClient;
    @Autowired
    private ProTransportCalendarService proTransportCalendarService;
    @Autowired
    private ProMaterialPlanHistoryOccupyDao proMaterialPlanHistoryOccupyDao;
    private Logger log = LoggerFactory.getLogger((String)ProStoreMaterialServiceImpl.class.getName());

    @RequestMapping(value={"/psm/addRecords"})
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo addRecords(@RequestBody List<ProStoreMaterialEntity> proStoreMaterialEntitys) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProStoreMaterialEntity> listAdd = new ArrayList<ProStoreMaterialEntity>();
            if (null != proStoreMaterialEntitys && proStoreMaterialEntitys.size() > 0) {
                for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterialEntitys) {
                    proStoreMaterialEntity.setTpsmid(IDGenerate.getUniqueIdStr());
                    proStoreMaterialEntity.setSurplusnum(proStoreMaterialEntity.getInitialnum());
                    listAdd.add(proStoreMaterialEntity);
                }
            }
            if (listAdd.size() > 0) {
                this.proStoreMaterialMapper.deleteAll();
                this.proStoreMaterialMapper.addRecordsBatch(listAdd);
            }
            this.proPredictSumToproStoreMaterial(null);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public List<ProStoreOccupyRelationV> findStoreOccupyNum(Map<String, Object> map) {
        List list = this.proStoreOccupyRelationDao.findAll(map);
        List proMaterialPlanEntitysA = this.proStoreOccupyRelationDao.findSumPlanToOccupy();
        block0: for (ProStoreOccupyRelationV proStoreOccupyRelationEntity : list) {
            for (ProMaterialPlanV proMaterialPlanEntity : proMaterialPlanEntitysA) {
                if (!proStoreOccupyRelationEntity.getProdatetime().equals(proMaterialPlanEntity.getPantime()) || !proStoreOccupyRelationEntity.getMatid().equals(proMaterialPlanEntity.getMatid()) || !proStoreOccupyRelationEntity.getFactoryid().equals(proMaterialPlanEntity.getFactoryid())) continue;
                proStoreOccupyRelationEntity.setSurplusneedsumAll(proMaterialPlanEntity.getNetrequirement());
                continue block0;
            }
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo<List<ProStoreOccupyRelationV>> proPredictSumToproStoreMaterial(BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        LinkedList storePredictMaterialOccupyDetails = null;
        try {
            List fhindListToMaterial = this.proPredictSumMapper.findListToMaterial();
            Set checkPredictSums = this.checkPredictSumFreshness(fhindListToMaterial);
            if (checkPredictSums.size() > 0) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage(new Gson().toJson((Object)checkPredictSums));
                return baseJsonVo;
            }
            List fhindListToMaterialPlan = this.proPredictSumMapper.findListToMaterialPlan();
            Set checkPredictSums2 = this.checkPredictSumFreshness(fhindListToMaterialPlan);
            if (checkPredictSums2.size() > 0) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage(new Gson().toJson((Object)checkPredictSums2));
                return baseJsonVo;
            }
            LinkedList proFactoryCalendarBuilds = this.proFactoryCalendarBuilDao.findProFactoryCalendarBuilsByProFactorys();
            if (proFactoryCalendarBuilds != null && proFactoryCalendarBuilds.size() == 0) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage("\u6392\u4ea7\u65e5\u5386\u4e3a\u7a7a");
                return baseJsonVo;
            }
            storePredictMaterialOccupyDetails = PlanBulidData.buildProFactoryCalendarBuildAndProPredictSumData((LinkedList)proFactoryCalendarBuilds, (List)fhindListToMaterial, (List)fhindListToMaterialPlan);
            for (ProStoreOccupyRelationEntity storePredictMaterialOccupy : storePredictMaterialOccupyDetails) {
                storePredictMaterialOccupy.setSorid(IDGenerate.getUniqueIdStr());
                storePredictMaterialOccupy.setSurplusneedsum(storePredictMaterialOccupy.getNeedsum());
            }
            PlanBulidData.sort1((List)storePredictMaterialOccupyDetails);
            List proStoreMaterialEntitysA = this.proStoreMaterialMapper.findAll();
            List proStoreMaterialEntitys = this.filerDatas(proStoreMaterialEntitysA);
            if (proStoreMaterialEntitys != null && proStoreMaterialEntitys.size() > 0) {
                for (ProStoreMaterialEntity proStoreMaterial : proStoreMaterialEntitys) {
                    proStoreMaterial.setSurplusnum(proStoreMaterial.getInitialnum());
                }
                this.proStoreMaterialMapper.updateBatch(proStoreMaterialEntitys);
            }
            for (int i = 0; i < storePredictMaterialOccupyDetails.size(); ++i) {
                ProStoreOccupyRelationEntity storePredictMaterialOccupyDetailA = (ProStoreOccupyRelationEntity)storePredictMaterialOccupyDetails.get(i);
                PlanBulidData.getProOccupyRelationEntity((List)storePredictMaterialOccupyDetails, (ProStoreOccupyRelationEntity)storePredictMaterialOccupyDetailA, (List)proStoreMaterialEntitys);
            }
            PlanBulidData.sort2((List)storePredictMaterialOccupyDetails);
            this.proStoreOccupyRelationDao.addRecordsBatch((List)storePredictMaterialOccupyDetails, null);
            if (proStoreMaterialEntitys != null && proStoreMaterialEntitys.size() > 0 && storePredictMaterialOccupyDetails.size() > 0) {
                this.proStoreMaterialMapper.updateBatch(proStoreMaterialEntitys);
            }
            LinkedList proMaterialPlanEntitys = new LinkedList();
            this.getProMaterialPlanEntitys(proMaterialPlanEntitys);
            List panTimes = this.getPanTimes(proMaterialPlanEntitys);
            if (panTimes.size() > 0) {
                HashMap<String, List> param = new HashMap<String, List>();
                param.put("panTimes", panTimes);
                this.proMaterialPlanMapper.deleteByPanstatus(param);
            }
            Date date = new Date();
            for (ProMaterialPlanV proMaterialPlan : proMaterialPlanEntitys) {
                proMaterialPlan.setCreattime(date);
                if (user == null) continue;
                proMaterialPlan.setCreator(user.getEmployeeName());
            }
            List newproMaterialPlanEntitys = this.filterProMaterialPlans(proMaterialPlanEntitys);
            this.log.info("\u751f\u6210\u6392\u4ea7\u8ba1\u5212   : proMaterialPlanEntitys \u5927\u5c0f =  " + proMaterialPlanEntitys.size());
            if (newproMaterialPlanEntitys != null && newproMaterialPlanEntitys.size() > 0) {
                this.proMaterialPlanMapper.addRecordsBatch(newproMaterialPlanEntitys);
            } else {
                this.log.info("\u751f\u6210\u6392\u4ea7\u8ba1\u5212   : proMaterialPlanEntitys \u5927\u5c0f \u4e3a\u7a7a");
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage("\u751f\u6210\u6392\u4ea7\u8ba1\u5212    : proMaterialPlanEntitys \u5927\u5c0f \u4e3a\u7a7a");
            }
            List saveProMaterialPlanHistoryOccupys = this.saveProMaterialPlanHistoryOccupy(newproMaterialPlanEntitys, (List)storePredictMaterialOccupyDetails);
            this.proMaterialPlanHistoryOccupyDao.saveFromToBuildPlans(saveProMaterialPlanHistoryOccupys);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u751f\u6210\u6392\u4ea7\u8ba1\u5212   : \u5f02\u5e38" + e.getMessage());
            e.printStackTrace();
            this.log.info("\u751f\u6210\u6392\u4ea7\u8ba1\u5212   : \u5f02\u5e38" + e);
        }
        baseJsonVo.setValue(storePredictMaterialOccupyDetails);
        return baseJsonVo;
    }

    public List<ProMaterialPlanHistoryOccupyEntity> saveProMaterialPlanHistoryOccupy(ProMaterialPlanV newproMaterialPlanEntity, List<ProStoreOccupyRelationV> storePredictMaterialOccupyDetails) {
        ArrayList<ProMaterialPlanV> newproMaterialPlanEntitys = new ArrayList<ProMaterialPlanV>();
        newproMaterialPlanEntitys.add(newproMaterialPlanEntity);
        return this.saveProMaterialPlanHistoryOccupy(newproMaterialPlanEntitys, storePredictMaterialOccupyDetails);
    }

    private List<ProMaterialPlanHistoryOccupyEntity> saveProMaterialPlanHistoryOccupy(List<ProMaterialPlanV> newproMaterialPlanEntitys, List<ProStoreOccupyRelationV> storePredictMaterialOccupyDetailsOld) {
        if (null != newproMaterialPlanEntitys && newproMaterialPlanEntitys.size() > 0 && null != storePredictMaterialOccupyDetailsOld && storePredictMaterialOccupyDetailsOld.size() > 0) {
            ArrayList<ProStoreOccupyRelationV> storePredictMaterialOccupyDetails = new ArrayList<ProStoreOccupyRelationV>();
            for (ProStoreOccupyRelationV proStoreOccupyRelationV : storePredictMaterialOccupyDetailsOld) {
                if (null == proStoreOccupyRelationV.getOccupynum() || proStoreOccupyRelationV.getOccupynum() < 1) continue;
                storePredictMaterialOccupyDetails.add(proStoreOccupyRelationV);
            }
            if (storePredictMaterialOccupyDetails.size() < 1) {
                return null;
            }
            Collections.sort(storePredictMaterialOccupyDetails, new /* Unavailable Anonymous Inner Class!! */);
            HashMap<String, ProMaterialPlanHistoryOccupyEntity> onlyOnes = new HashMap<String, ProMaterialPlanHistoryOccupyEntity>();
            for (ProMaterialPlanEntity proMaterialPlanEntity : newproMaterialPlanEntitys) {
                int diffnum = proMaterialPlanEntity.getPlannum() - (proMaterialPlanEntity.getNetrequirement() + (proMaterialPlanEntity.getSafetystock() != null ? proMaterialPlanEntity.getSafetystock() : 0));
                if (storePredictMaterialOccupyDetails.isEmpty()) continue;
                for (ProStoreOccupyRelationEntity proStoreOccupyRelationEntity : storePredictMaterialOccupyDetails) {
                    if (null == proStoreOccupyRelationEntity || !proMaterialPlanEntity.getMatid().equals(proStoreOccupyRelationEntity.getMatid()) || !proMaterialPlanEntity.getPantime().equals(proStoreOccupyRelationEntity.getProdatetime()) || null == proStoreOccupyRelationEntity.getOccupynum() || proStoreOccupyRelationEntity.getOccupynum() < 1) continue;
                    ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupyEntity = new ProMaterialPlanHistoryOccupyEntity();
                    proMaterialPlanHistoryOccupyEntity.setMatid(proMaterialPlanEntity.getMatid());
                    proMaterialPlanHistoryOccupyEntity.setProdatetime(proMaterialPlanEntity.getPantime());
                    proMaterialPlanHistoryOccupyEntity.setStoreid(proStoreOccupyRelationEntity.getStoreid());
                    proMaterialPlanHistoryOccupyEntity.setCbatchname(proStoreOccupyRelationEntity.getCbatchname());
                    if (onlyOnes.containsKey(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())) {
                        ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).setOccupynum(Integer.valueOf(((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getOccupynum() + proStoreOccupyRelationEntity.getOccupynum()));
                    } else {
                        proMaterialPlanHistoryOccupyEntity.setOccupynum(proStoreOccupyRelationEntity.getOccupynum());
                        onlyOnes.put(proMaterialPlanHistoryOccupyEntity.toOnlyParameters(), proMaterialPlanHistoryOccupyEntity);
                    }
                    if (diffnum <= 0) continue;
                    if (proStoreOccupyRelationEntity.getOccupynum() - diffnum >= 0) {
                        ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).setPlanaddnum(Integer.valueOf((((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getPlanaddnum() != null ? ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getPlanaddnum() : 0) + diffnum));
                        ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).setOccupyreleasenum(Integer.valueOf(((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getOccupynum() - ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getPlanaddnum()));
                        diffnum = 0;
                        continue;
                    }
                    ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).setPlanaddnum(Integer.valueOf((((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getPlanaddnum() != null ? ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getPlanaddnum() : 0) + proStoreOccupyRelationEntity.getOccupynum()));
                    ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).setOccupyreleasenum(Integer.valueOf(((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getOccupynum() - ((ProMaterialPlanHistoryOccupyEntity)onlyOnes.get(proMaterialPlanHistoryOccupyEntity.toOnlyParameters())).getPlanaddnum()));
                    diffnum -= proStoreOccupyRelationEntity.getOccupynum().intValue();
                }
            }
            if (onlyOnes.values() != null && onlyOnes.size() > 0) {
                ArrayList<ProMaterialPlanHistoryOccupyEntity> arrayList = new ArrayList<ProMaterialPlanHistoryOccupyEntity>();
                for (Map.Entry map : onlyOnes.entrySet()) {
                    arrayList.add((ProMaterialPlanHistoryOccupyEntity)map.getValue());
                }
                return arrayList;
            }
        }
        return null;
    }

    private List<String> getPanTimes(List<ProMaterialPlanV> proMaterialPlanEntitys) {
        ArrayList<String> list = new ArrayList<String>();
        if (proMaterialPlanEntitys != null && proMaterialPlanEntitys.size() > 0) {
            for (ProMaterialPlanV proMaterialPlanE : proMaterialPlanEntitys) {
                if (list.contains(proMaterialPlanE.getPantime())) continue;
                list.add(proMaterialPlanE.getPantime());
            }
        }
        return list;
    }

    private List<ProMaterialPlanV> filterProMaterialPlans(List<ProMaterialPlanV> filterProMaterialPlans) {
        ArrayList<ProMaterialPlanV> filterProMaterialPlansNew = new ArrayList<ProMaterialPlanV>();
        for (ProMaterialPlanV proMaterialPlanEntity : filterProMaterialPlans) {
            if (proMaterialPlanEntity.getGrossrequirement() == null || proMaterialPlanEntity.getGrossrequirement() <= 0) continue;
            filterProMaterialPlansNew.add(proMaterialPlanEntity);
        }
        return filterProMaterialPlansNew;
    }

    private List<ProMaterialPlanEntity> checkCanAddProMaterialPlans(List<ProMaterialPlanEntity> findList, List<ProMaterialPlanEntity> proMaterialPlanEntitys) {
        ArrayList<ProMaterialPlanEntity> list = new ArrayList<ProMaterialPlanEntity>();
        for (ProMaterialPlanEntity proMaterialPlanEntity : proMaterialPlanEntitys) {
            boolean flag = true;
            for (ProMaterialPlanEntity proMaterialPlan : findList) {
                if (!proMaterialPlan.equals((Object)proMaterialPlanEntity) || proMaterialPlan.getPanstatus().equals(1)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            proMaterialPlanEntity.setSource("system");
            list.add(proMaterialPlanEntity);
        }
        return list;
    }

    public BaseJsonVo<List<ProStoreMaterialEntity>> findList(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proStoreMaterialMapper.findList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    private boolean toGetProFactoryCalendarMaterial(List<ProFactoryCalendarEntity> proFactoryCalendarEntitys, ProStoreOccupyRelationEntity proStoreOccupyRelationEntity) {
        List materialProdEntitys = this.materialProdMapper.loadList(null);
        boolean flag = false;
        if (proFactoryCalendarEntitys != null && proFactoryCalendarEntitys.size() > 0) {
            for (ProFactoryCalendarEntity proFactoryCalendarEntity : proFactoryCalendarEntitys) {
                if (!proStoreOccupyRelationEntity.getProdatetime().equals(proFactoryCalendarEntity.getProDay())) continue;
                String podMatClassId = this.getMatpodclassId(materialProdEntitys, proStoreOccupyRelationEntity);
                if (StringUtils.isBlank((String)podMatClassId)) {
                    flag = true;
                } else {
                    if (!StringUtils.isNotBlank((String)podMatClassId) || !proFactoryCalendarEntity.getPodMatClassId().equals(podMatClassId)) continue;
                    flag = true;
                }
                break;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    private String getMatpodclassId(List<MaterialProdEntity> materialProdEntitys, ProStoreOccupyRelationEntity proStoreOccupyRelationEntity) {
        String matpodclassId = "";
        for (MaterialProdEntity materialProdEntity : materialProdEntitys) {
            if (!materialProdEntity.getCguid().equals(proStoreOccupyRelationEntity.getMatid())) continue;
            matpodclassId = materialProdEntity.getMatpodclassid();
            break;
        }
        return matpodclassId;
    }

    private void getProMaterialPlanEntitys(List<ProMaterialPlanV> proMaterialPlanEntitys) {
        Date date = new Date();
        List proMaterialPlanEntitysA = this.proStoreOccupyRelationDao.tofindSumPlan();
        List materialProdEntitys = this.materialProdMapper.loadList(null);
        Map materialmap = this.materialProdToMap(materialProdEntitys);
        if (proMaterialPlanEntitysA != null) {
            this.log.info("\u751f\u6210\u6392\u4ea7\u8ba1\u5212   : getProMaterialPlanEntitys proMaterialPlanEntitysA \u5927\u5c0f \u4e3a " + proMaterialPlanEntitysA.size());
            for (ProMaterialPlanV proMaterialPlanEntity : proMaterialPlanEntitysA) {
                proMaterialPlanEntity.setPlanid(IDGenerate.getUniqueIdStr());
                proMaterialPlanEntity.setCreattime(date);
                proMaterialPlanEntity.setPanstatus(Integer.valueOf(1));
                proMaterialPlanEntity.setSafetystock(this.toGetSafetystock((ProMaterialPlanEntity)proMaterialPlanEntity, materialProdEntitys));
                proMaterialPlanEntity.setPlannum(this.toGetPlannum((ProMaterialPlanEntity)proMaterialPlanEntity, materialmap));
                proMaterialPlanEntity.setSource("system");
                proMaterialPlanEntitys.add(proMaterialPlanEntity);
            }
        } else {
            this.log.info("\u751f\u6210\u6392\u4ea7\u8ba1\u5212   : getProMaterialPlanEntitys proMaterialPlanEntitysA \u5927\u5c0f \u4e3a\u7a7a");
        }
    }

    private Map<String, MaterialProdEntity> materialProdToMap(List<MaterialProdEntity> materialProdEntitys) {
        HashMap<String, MaterialProdEntity> map = new HashMap<String, MaterialProdEntity>();
        if (materialProdEntitys != null && materialProdEntitys.size() > 0) {
            for (MaterialProdEntity materialProd : materialProdEntitys) {
                map.put(materialProd.getCguid(), materialProd);
            }
        }
        return map;
    }

    private Integer toGetSafetystock(ProMaterialPlanEntity proMaterialPlanEntity, List<MaterialProdEntity> materialProdEntitys) {
        int num = 0;
        if (materialProdEntitys != null && materialProdEntitys.size() > 0 && proMaterialPlanEntity != null) {
            for (MaterialProdEntity materialProdEntity : materialProdEntitys) {
                if (materialProdEntity.getCguid() == null || proMaterialPlanEntity.getMatid() == null || !materialProdEntity.getCguid().equals(proMaterialPlanEntity.getMatid())) continue;
                if (materialProdEntity.getIsafetystock() == null) break;
                num = materialProdEntity.getIsafetystock();
                break;
            }
        }
        return num;
    }

    private Integer toGetPlannum(ProMaterialPlanEntity proMaterialPlanEntity, Map<String, MaterialProdEntity> materialmap) {
        int num = 0;
        if (proMaterialPlanEntity != null) {
            if (proMaterialPlanEntity.getNetrequirement() != null && proMaterialPlanEntity.getSafetystock() != null) {
                num = proMaterialPlanEntity.getNetrequirement() + proMaterialPlanEntity.getSafetystock();
            } else if (proMaterialPlanEntity.getNetrequirement() == null && proMaterialPlanEntity.getSafetystock() != null) {
                num = proMaterialPlanEntity.getSafetystock();
            } else if (proMaterialPlanEntity.getNetrequirement() != null && proMaterialPlanEntity.getSafetystock() == null) {
                num = proMaterialPlanEntity.getNetrequirement();
            }
        }
        Integer numRound = 1;
        if (materialmap.get(proMaterialPlanEntity.getMatid()) != null && materialmap.get(proMaterialPlanEntity.getMatid()).getNumRound() != null) {
            numRound = materialmap.get(proMaterialPlanEntity.getMatid()).getNumRound();
        }
        if (numRound > 0 && numRound != 1) {
            Integer numRoundnew = numRound;
            Integer a = num / numRoundnew;
            return (a + 1) * numRoundnew;
        }
        if (numRound != 1) {
            Integer numRoundnew = numRound * -1;
            Integer b = num / numRoundnew;
            return b * numRoundnew;
        }
        return num;
    }

    private void getProPredictSumToproStoreMaterial(ProPredictSumEntity proPredictSumEntity, List<ProStorePredictRangeEntity> proStorePredictRangeEntitys, List<ProStoreOccupyRelationEntity> storePredictMaterialTimes, List<ProPredictSumEntity> proPredictSumEntitysA) {
        Date date = new Date();
        for (ProStorePredictRangeEntity proStorePredictRangeEntity : proStorePredictRangeEntitys) {
            if (!proStorePredictRangeEntity.getStoreid().equals(proPredictSumEntity.getStoreid())) continue;
            for (int i = 0; i < proStorePredictRangeEntity.getProscheduling(); ++i) {
                String proSchedDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)i), (String)"yyyyMMdd");
                LinkedList<String> predictCoverDays = new LinkedList<String>();
                for (int b = 0; b < proStorePredictRangeEntity.getPredictcoverdays(); ++b) {
                    predictCoverDays.add(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)proSchedDate, (String)"yyyyMMdd"), (int)(b + proStorePredictRangeEntity.getIntervalnum())), (String)"yyyyMMdd"));
                }
                for (String predCoverDay : predictCoverDays) {
                    boolean flag = true;
                    for (ProPredictSumEntity proPredictSumEntityA : proPredictSumEntitysA) {
                        if (!proPredictSumEntity.getStoreid().equals(proPredictSumEntityA.getStoreid()) || !proPredictSumEntity.getMatid().equals(proPredictSumEntityA.getMatid()) || !proPredictSumEntityA.getPickupdate().equals(predCoverDay)) continue;
                        flag = false;
                        ProStoreOccupyRelationEntity storePredictMaterial = new ProStoreOccupyRelationEntity();
                        storePredictMaterial.setMatid(proPredictSumEntity.getMatid());
                        storePredictMaterial.setMatcode(proPredictSumEntity.getMatcode());
                        storePredictMaterial.setMatname(proPredictSumEntity.getMatname());
                        storePredictMaterial.setStoreid(proPredictSumEntity.getStoreid());
                        storePredictMaterial.setStorecode(proPredictSumEntity.getStorecode());
                        storePredictMaterial.setStorename(proPredictSumEntity.getStorename());
                        storePredictMaterial.setCoverdatetime(predCoverDay);
                        storePredictMaterial.setNeedsum(proPredictSumEntityA.getNeedsum());
                        storePredictMaterial.setFreshness(proPredictSumEntityA.getFreshness());
                        storePredictMaterial.setProdatetime(proSchedDate);
                        storePredictMaterialTimes.add(storePredictMaterial);
                    }
                    if (!flag) continue;
                    ProStoreOccupyRelationEntity storePredictMaterial = new ProStoreOccupyRelationEntity();
                    storePredictMaterial.setMatid(proPredictSumEntity.getMatid());
                    storePredictMaterial.setMatcode(proPredictSumEntity.getMatcode());
                    storePredictMaterial.setMatname(proPredictSumEntity.getMatname());
                    storePredictMaterial.setStoreid(proPredictSumEntity.getStoreid());
                    storePredictMaterial.setStorecode(proPredictSumEntity.getStorecode());
                    storePredictMaterial.setStorename(proPredictSumEntity.getStorename());
                    storePredictMaterial.setCoverdatetime(predCoverDay);
                    storePredictMaterial.setProdatetime(proSchedDate);
                    storePredictMaterialTimes.add(storePredictMaterial);
                }
            }
        }
    }

    public List<FormEdianBaoGetStoreMateral> getEDBstoreDatas() {
        List formEdianBaoGetStoreMaterals = null;
        Date date = new Date();
        String jsonstr = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("format", "json");
            long time5 = System.currentTimeMillis();
            jsonstr = this.edbClient.edbRequstPost("edbProductGet_LC", map);
            long time6 = System.currentTimeMillis();
            this.log.info("==========\u83b7\u53d6edb\u539f\u59cb\u6570\u636e\u4ecesys\u8017\u65f6======" + (time6 - time5) + "\u6beb\u79d2");
            long time7 = System.currentTimeMillis();
            Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
            Edbstoredatas Edbstoredatas2 = (Edbstoredatas)new Gson().fromJson(jsonstr, type);
            formEdianBaoGetStoreMaterals = Edbstoredatas2.getSuccess().getItems().getItem();
            for (FormEdianBaoGetStoreMateral formE : formEdianBaoGetStoreMaterals) {
                formE.setId(IDGenerate.getUniqueIdStr());
                formE.setUpdateTime(date);
            }
            long time8 = System.currentTimeMillis();
            this.log.info("==========\u83b7\u53d6edb\u539f\u59cb\u6570\u636e\u7531\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u5b9e\u4f53\u7c7b\u8017\u65f6======" + (time8 - time7) + "\u6beb\u79d2");
            this.formEdianBaoGetStoreMateralMapper.deleteAll();
            long time1 = System.currentTimeMillis();
            int length = formEdianBaoGetStoreMaterals.size() / 500 + 1;
            int mod = formEdianBaoGetStoreMaterals.size() % 500;
            for (int i = 0; i < length; ++i) {
                int end = (i + 1) * 500 > formEdianBaoGetStoreMaterals.size() ? i * 500 + mod : 500 * (i + 1);
                List sub = formEdianBaoGetStoreMaterals.subList(i * 500, end);
                this.formEdianBaoGetStoreMateralMapper.addRecordsBatch(sub);
            }
            long time2 = System.currentTimeMillis();
            this.log.info("==========\u83b7\u53d6edb\u539f\u59cb\u6570\u636e\u5b58\u5e93\u8017\u65f6======" + (time2 - time1) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u6613\u5e97\u5b9d\uff1a \u83b7\u53d6\u6570\u636e  \uff1a " + jsonstr);
            this.log.error("\u6613\u5e97\u5b9d\uff1a \u83b7\u53d6\u6570\u636e\u5f02\u5e38 \uff1a " + e);
            this.log.error("\u6613\u5e97\u5b9d\uff1a \u83b7\u53d6\u6570\u636e\u5f02\u5e38 \uff1a " + e.getMessage());
        }
        return formEdianBaoGetStoreMaterals;
    }

    private void getDatas(List<FormEdianBaoGetStoreMateral> listA, List<EdbWarehouseRelationEntityV> warehouseRelationsA, List<EdbMaterialRelationEntityV> materialRelationsA) {
        long time1 = System.currentTimeMillis();
        try {
            long time3 = System.currentTimeMillis();
            List list = this.getEDBstoreDatas();
            long time4 = System.currentTimeMillis();
            this.log.info("======\u83b7\u53d6\u6613\u5e97\u5b9d\u6570\u636e======  " + (time4 - time3) + "\u6beb\u79d2 \u5927\u5c0f \uff1a" + (list != null ? list.size() : 0));
            List materialRelations = this.getMaterialRelations();
            this.log.info("======\u83b7\u53d6\u7269\u54c1\u5173\u8054\u5173\u7cfb====== \u5927\u5c0f \uff1a" + (materialRelations != null ? materialRelations.size() : 0));
            List warehouseRelations = this.getWarehouseRelations();
            this.log.info("======\u83b7\u53d6\u4ed3\u5e93\u5173\u8054\u5173\u7cfb====== \u5927\u5c0f \uff1a" + (warehouseRelations != null ? warehouseRelations.size() : 0));
            if (list != null && list.size() > 0) {
                for (FormEdianBaoGetStoreMateral aa : list) {
                    listA.add(aa);
                }
            }
            if (materialRelations != null && materialRelations.size() > 0) {
                for (EdbMaterialRelationEntityV bb : materialRelations) {
                    materialRelationsA.add(bb);
                }
            }
            if (warehouseRelations != null && warehouseRelations.size() > 0) {
                for (EdbWarehouseRelationEntityV cc : warehouseRelations) {
                    warehouseRelationsA.add(cc);
                }
            }
            long time2 = System.currentTimeMillis();
            this.log.info("======\u83b7\u53d6\u6613\u5e97\u5b9d\u6570\u636e,\u53ca\u6240\u9700\u7ec4\u5408\u6570\u636e\u8017\u65f6======" + (time2 - time1) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ProStoreMaterialEntity> edbStoreDatasToMyProStoreMaterials() {
        long time1 = System.currentTimeMillis();
        ArrayList<ProStoreMaterialEntity> formEdianBaoGetStoreMaterals = new ArrayList<ProStoreMaterialEntity>();
        ArrayList list = new ArrayList();
        ArrayList warehouseRelations = new ArrayList();
        ArrayList materialRelations = new ArrayList();
        this.getDatas(list, warehouseRelations, materialRelations);
        if (list.size() < 1) {
            return formEdianBaoGetStoreMaterals;
        }
        List listNew = this.formEdianBaoGetStoreMateralMapper.findGropSum();
        this.log.info("\u521d\u59cb\u5316\u6570\u636e\u4e3a : listNew  \u5927\u5c0f \uff1a" + (listNew != null ? listNew.size() : 0));
        int i = 0;
        if (listNew != null && listNew.size() > 0) {
            for (FormEdianBaoGetStoreMateral pebgsm : listNew) {
                ProStoreMaterialEntity psm;
                block13: {
                    psm = null;
                    if (pebgsm == null) {
                        this.log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a pebgsm" + pebgsm.getBar_code() + "  " + i++);
                        continue;
                    }
                    try {
                        block12: {
                            try {
                                psm = pebgsm.myToProStoreMaterialEntity(pebgsm);
                                if (psm == null) {
                                    this.log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a " + pebgsm.getBar_code() + "  " + i++);
                                }
                                break block12;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.log.info("\u8f6c\u6362\u4ed3\u5e93\u4fe1\u606f\u5f02\u5e38  pebgsm.myToProStoreMaterialEntity" + e.getMessage() + "  " + i++);
                            }
                            continue;
                        }
                        EdbMaterialRelationEntityV edbMaterialRelation = this.getMaterialRelationByEdbCode(pebgsm, materialRelations);
                        if (edbMaterialRelation == null) {
                            this.log.info("\u7269\u54c1\u6c92\u6709\u5339\u914d\u4e0a code " + pebgsm.getBar_code());
                            continue;
                        }
                        psm.setMatid(edbMaterialRelation.getCmatid());
                        psm.setMatcode(edbMaterialRelation.getCmatcode());
                        psm.setMatname(edbMaterialRelation.getCmatname());
                        EdbWarehouseRelationEntityV warehouseRelation = this.getWarehouseRelationByEdbCode(pebgsm, warehouseRelations);
                        if (warehouseRelation != null) {
                            psm.setStoreid(warehouseRelation.getCwarehouseid());
                            psm.setStorecode(warehouseRelation.getCwarehousecode());
                            psm.setStorename(warehouseRelation.getCwarehousename());
                            break block13;
                        }
                        this.log.info("\u4ed3\u5e93\u6c92\u6709\u5339\u914d\u4e0a code " + pebgsm.getWarehouse_id());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.info("======\u83b7\u53d6\u6613\u5e97\u5b9d\u6570\u636e\u7ec4\u5408\u6210erp\u5e93\u5b58\u6240\u9700\u6570\u636e \u5f02\u5e38 " + e.getMessage());
                    }
                    continue;
                }
                formEdianBaoGetStoreMaterals.add(psm);
            }
        } else {
            this.log.info("======\u83b7\u53d6\u6613\u5e97\u5b9d\u6570\u636elistNew \u4e3a\u7a7a ");
        }
        long time2 = System.currentTimeMillis();
        this.log.info("======\u83b7\u53d6\u6613\u5e97\u5b9d\u6570\u636e\u7ec4\u5408\u6210erp\u5e93\u5b58\u6240\u9700\u6570\u636e======" + (time2 - time1) + "\u6beb\u79d2 \u5927\u5c0f" + formEdianBaoGetStoreMaterals.size());
        return formEdianBaoGetStoreMaterals;
    }

    private List<EdbWarehouseRelationEntityV> getWarehouseRelations() {
        List list = null;
        try {
            BaseJsonVo basejson = this.edbWarehouseRelationClient.findAll();
            if (basejson.getStatus() == 200 && basejson.getValue() != null) {
                list = (List)basejson.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(e.getMessage());
            this.log.error("\u83b7\u53d6\u4ed3\u5e93\u6620\u5c04\u5173\u7cfb\u5f02\u5e38");
        }
        return list;
    }

    private synchronized EdbWarehouseRelationEntityV getWarehouseRelationByEdbCode(FormEdianBaoGetStoreMateral pebgsm, List<EdbWarehouseRelationEntityV> list) {
        EdbWarehouseRelationEntityV relation = null;
        if (list != null && list.size() > 0) {
            for (EdbWarehouseRelationEntityV relationV : list) {
                if (null == relationV.getEdbwarehousecode()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a getEdbwarehousecode()" + new Gson().toJson((Object)relationV));
                    continue;
                }
                if (null == pebgsm.getWarehouse_id()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a(pebgsm.getWarehouse_id()) " + new Gson().toJson((Object)pebgsm));
                    continue;
                }
                if (null == relationV.getType()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a  relationV.getType()  " + new Gson().toJson((Object)relationV));
                    continue;
                }
                if (!relationV.getEdbwarehousecode().equals(pebgsm.getWarehouse_id()) || relationV.getType() != 1 && !(relationV.getType() + "").equals("1")) continue;
                relation = relationV;
                break;
            }
        }
        return relation;
    }

    private List<EdbMaterialRelationEntityV> getMaterialRelations() {
        List<Object> list = new ArrayList<EdbMaterialRelationEntityV>();
        try {
            BaseJsonVo basejson = this.edbMaterialRelationClient.findAll();
            if (basejson.getStatus() == 200 && basejson.getValue() != null) {
                list = (List)basejson.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(e.getMessage());
            this.log.error("\u83b7\u53d6\u7269\u54c1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38");
        }
        return list;
    }

    private synchronized EdbMaterialRelationEntityV getMaterialRelationByEdbCode(FormEdianBaoGetStoreMateral pebgsm, List<EdbMaterialRelationEntityV> list) {
        EdbMaterialRelationEntityV relation = null;
        if (list != null && list.size() > 0) {
            for (EdbMaterialRelationEntityV relationV : list) {
                if (null == relationV.getEdbmatcode()) {
                    this.log.info("\u7269\u54c1\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a (relationV.getEdbmatcode())" + new Gson().toJson((Object)relationV));
                    continue;
                }
                if (null == pebgsm.getBar_code()) {
                    this.log.info("\u7269\u54c1\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a(pebgsm.getBar_code()) " + new Gson().toJson((Object)pebgsm));
                    continue;
                }
                if (!relationV.getEdbmatcode().equals(pebgsm.getBar_code())) continue;
                relation = relationV;
                break;
            }
        }
        return relation;
    }

    public BaseJsonVo<List<ProStoreOccupyRelationV>> checkIfHasProClassId() {
        BaseJsonVo object = new BaseJsonVo();
        object.setStatus(200);
        try {
            List fhindListToMaterial = this.proPredictSumMapper.findGroupByMaterial();
            if (fhindListToMaterial != null && fhindListToMaterial.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (ProPredictSumEntity pp : fhindListToMaterial) {
                    sb.append(pp.getMatname() + "\uff0c \u6b64\u6570\u636e\u672a\u914d\u7f6e\u751f\u4ea7\u5206\u7c7b\u3002<br>");
                }
                object.setStatus(500);
                object.setMessage(sb.toString());
            }
        }
        catch (Exception e) {
            object.setStatus(500);
            object.setMessage("\u6570\u636e\u5f02\u5e38,\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            object.setError_msg(e.getMessage());
        }
        return object;
    }

    public List<ProStoreMaterialEntity> getAllocationData() throws Exception {
        Date date = new Date();
        String today = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
        List transportAllocationDatas = null;
        List proStoreMaterials = null;
        try {
            BaseJsonVo baseJsonVoTransportAllocation = this.proTransportCalendarService.getProTransportAllocationData();
            if (baseJsonVoTransportAllocation.getStatus() == 200) {
                transportAllocationDatas = (List)baseJsonVoTransportAllocation.getValue();
            }
            boolean isIfAllocationDay = false;
            if (transportAllocationDatas != null && transportAllocationDatas.size() > 0) {
                for (ProTransportAllocationData proTransportAllocationData : transportAllocationDatas) {
                    if (!ProStoreMaterialServiceImpl.matchingIcAllotDetail((ProTransportAllocationData)proTransportAllocationData, (String)today)) continue;
                    isIfAllocationDay = true;
                    break;
                }
            }
            if (isIfAllocationDay) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("beforDays", today);
                proStoreMaterials = this.proStoreMaterialTypeBuildDataMapper.findAllocationData(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return proStoreMaterials;
    }

    public static boolean matchingIcAllotDetail(ProTransportAllocationData proTransportAllocationData, String today) throws Exception {
        String icAllotDetail_Prodtime = proTransportAllocationData.getLogisticsDate();
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)icAllotDetail_Prodtime) && today.equals(icAllotDetail_Prodtime);
    }

    public List<ProStoreMaterialEntity> getProData() throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("ccode", "00004");
        Warehouse warehouse = this.warehouseClient.getWarehouseByParam(param);
        String nowDate = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("beforDays", nowDate);
        List proStoreMaterials = this.proStoreMaterialTypeBuildDataMapper.findProData(map);
        for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterials) {
            if (warehouse != null) {
                proStoreMaterialEntity.setStoreid(warehouse.getCguid());
                proStoreMaterialEntity.setStorecode(warehouse.getCcode());
                proStoreMaterialEntity.setStorename(warehouse.getCname());
                continue;
            }
            proStoreMaterialEntity.setStoreid("1037595826996514816");
        }
        return proStoreMaterials;
    }

    private List<ProStoreMaterialEntity> filerDatas(List<ProStoreMaterialEntity> proStoreMaterialEntitys) {
        ArrayList<ProStoreMaterialEntity> proStoreMaterialEntitysA = new ArrayList<ProStoreMaterialEntity>();
        if (proStoreMaterialEntitys != null && proStoreMaterialEntitys.size() > 0) {
            for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterialEntitys) {
                if (proStoreMaterialEntity.getInitialnum() == null || proStoreMaterialEntity.getInitialnum() <= 0 || proStoreMaterialEntity.getDatatpye() != 2) continue;
                proStoreMaterialEntitysA.add(proStoreMaterialEntity);
            }
        }
        return proStoreMaterialEntitysA;
    }

    private Set<String> checkPredictSumFreshness(List<ProPredictSumEntity> list) {
        HashSet<String> rreturnMsg = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (ProPredictSumEntity p : list) {
                Boolean flag = true;
                StringBuffer sb = new StringBuffer();
                if (p.getFreshness() != null) continue;
                rreturnMsg.add("\u9884\u6d4b\u9700\u6c42\u6c47\u603b\u8868(" + p.getMatname() + " " + p.getStorename() + " " + p.getPickupdate() + ") - \u65b0\u9c9c\u5ea6\u4e3a\u7a7a");
            }
        }
        return rreturnMsg;
    }
}

