/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.pro.domain.CustomerService;
import cc.lechun.pro.entity.CustomerEntity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class CustomerControl
implements Serializable {
    @Autowired
    private CustomerService customerService;

    @RequestMapping(value={"/customer/customerlist"})
    @ResponseBody
    public JqGridData<CustomerEntity> findCustomer(HttpServletRequest request) {
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        int pageNo = 0;
        int pageSize = 0;
        if (StringUtils.isNotBlank((CharSequence)page) && StringUtils.isNotBlank((CharSequence)rows)) {
            pageNo = Integer.valueOf(page);
            pageSize = Integer.valueOf(rows);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("classid", request.getParameter("classid"));
        params.put("search", request.getParameter("search"));
        params.put("ccheckstatus", request.getParameter("ccheckstatus"));
        params.put("apply", request.getParameter("apply"));
        params.put("bctid", request.getParameter("bctid"));
        params.put("matid", request.getParameter("matid"));
        params.put("fguid", request.getParameter("fguid"));
        List customers = this.customerService.getCustomersByParam(pageNo, pageSize, params);
        JqGridData results = new JqGridData(customers);
        return results;
    }
}

