/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import cc.lechun.pro.entity.bo.ProMaterialPlanForm;
import cc.lechun.pro.entity.vo.ProMaterialPlanV;
import cc.lechun.pro.service.ProMaterialPlanService;
import cc.lechun.pro.service.ProStoreMaterialService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class ProPlanControl {
    @Autowired
    private ProMaterialPlanService proMaterialPlanService;
    @Autowired
    private ProStoreMaterialService proStoreMaterialService;

    @RequestMapping(value={"/ProPlan/upDateList"})
    public BaseJsonVo upDateList(HttpServletRequest request, @RequestBody ProMaterialPlanForm mpForm) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList ids = new ArrayList();
        List materialFreshnesss = this.getProMaterialPlans(mpForm, user, "upDateList", ids);
        return this.proMaterialPlanService.saveOrUpdate(user, materialFreshnesss, ids);
    }

    @RequestMapping(value={"/ProPlan/findPage"})
    public Object findPage(Integer page, Integer rows, String storeid, String matNameSearch, String pantime, String actuallyfinishtime, String panstatusNo, String panstatus, String podMatClassId, String panstatusFlag, String planningtype) {
        JqGridData gridData = null;
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)storeid)) {
                param.put("storeid", storeid);
            }
            if (StringUtils.isNotBlank((CharSequence)matNameSearch)) {
                param.put("matNameSearch", matNameSearch);
            }
            if (StringUtils.isNotBlank((CharSequence)pantime)) {
                param.put("pantime", pantime.replace("-", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)actuallyfinishtime)) {
                param.put("actuallyfinishtime", actuallyfinishtime.replace("-", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)panstatus)) {
                param.put("panstatus", panstatus);
            }
            if (StringUtils.isNotBlank((CharSequence)panstatusFlag)) {
                param.put("panstatusFlag", "true");
            }
            if (StringUtils.isNotBlank((CharSequence)panstatusNo)) {
                param.put("panstatusNo", panstatusNo);
            }
            if (StringUtils.isNotBlank((CharSequence)podMatClassId)) {
                param.put("podMatClassId", podMatClassId);
            }
            if (StringUtils.isNotBlank((CharSequence)planningtype)) {
                param.put("planningtype", planningtype);
            }
            baseJsonVo = this.proMaterialPlanService.findList(page, rows, param);
            List list = null;
            if (baseJsonVo.getStatus() == 200) {
                list = (List)baseJsonVo.getValue();
            }
            gridData = new JqGridData(list);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            return baseJsonVo;
        }
        return gridData;
    }

    @RequestMapping(value={"/ProPlan/planSum"})
    public Object planSum(HttpServletRequest request) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        try {
            baseJsonVo = this.proStoreMaterialService.checkIfHasProClassId();
            if (baseJsonVo.getStatus() == 200) {
                baseJsonVo = this.proStoreMaterialService.proPredictSumToproStoreMaterial(user);
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ProPlan/checkPlanSum"})
    public Object checkPlanSum() {
        return this.proMaterialPlanService.checkPlanSum();
    }

    @RequestMapping(value={"/ProPlan/issuedUpdateList"})
    public BaseJsonVo issuedUpdateList(HttpServletRequest request) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        try {
            baseJsonVo = this.proMaterialPlanService.issuedUpdateList(user);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            return baseJsonVo;
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ProPlan/finishInToStoreUpdateList"})
    public BaseJsonVo finishInToStoreUpdateList(HttpServletRequest request, @RequestBody ProMaterialPlanForm mpForm) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        List materialFreshnesss = this.getProMaterialPlans(mpForm, user, "finishInToStoreUpdateList", null);
        try {
            baseJsonVo = this.proMaterialPlanService.finishInToStoreUpdateList(user, materialFreshnesss);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            return baseJsonVo;
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/ProPlan/findStoreOccupyNum"})
    public JqGridData findStoreOccupyNum(String storeid, String matNameSearch, String proDateTime) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("storeid", storeid);
        param.put("matNameSearch", matNameSearch);
        if (StringUtils.isNotBlank((CharSequence)proDateTime)) {
            param.put("proDateTime", proDateTime.replace("-", ""));
        }
        List storePredictMaterials = this.proStoreMaterialService.findStoreOccupyNum(param);
        JqGridData jqGridData = new JqGridData();
        jqGridData.setRows(storePredictMaterials);
        return jqGridData;
    }

    @RequestMapping(value={"/ProPlan/findStoreSurplusNum"})
    public JqGridData findStoreSurplusNum(Integer page, Integer rows, String matSarch, String storeId, String podMatClassId, String prodtime, String startProdtime, String endProdtime) {
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)matSarch)) {
            param.put("matSarch", matSarch);
        }
        if (StringUtils.isNotBlank((CharSequence)storeId)) {
            param.put("storeId", storeId);
        }
        if (StringUtils.isNotBlank((CharSequence)podMatClassId)) {
            param.put("podMatClassId", podMatClassId);
        }
        if (StringUtils.isNotBlank((CharSequence)startProdtime)) {
            param.put("startProdtime", startProdtime.replace("-", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)endProdtime)) {
            param.put("endProdtime", endProdtime.replace("-", ""));
        }
        BaseJsonVo baseJsonVo = this.proStoreMaterialService.findList(page, rows, param);
        JqGridData jqGridData = new JqGridData();
        if (baseJsonVo.getStatus() == 200) {
            jqGridData.setRows((List)baseJsonVo.getValue());
        }
        return jqGridData;
    }

    private List<ProMaterialPlanV> getProMaterialPlans(ProMaterialPlanForm materialProdForm, BaseUser user, String flag, List<String> ids) {
        ArrayList<ProMaterialPlanV> list = new ArrayList<ProMaterialPlanV>();
        Date date = new Date();
        if (null != materialProdForm.getModify() && materialProdForm.getModify().size() > 0) {
            for (ProMaterialPlanV materialProd : materialProdForm.getModify()) {
                if (StringUtils.isNotBlank((CharSequence)materialProd.getPantime())) {
                    materialProd.setPantime(materialProd.getPantime().replace("-", ""));
                }
                if (StringUtils.isBlank((CharSequence)materialProd.getPlanid())) {
                    if (user != null) {
                        materialProd.setCreator(user.getEmployeeName());
                    }
                    materialProd.setCreattime(new Date());
                } else {
                    if (user != null) {
                        materialProd.setVerifier(user.getEmployeeName());
                    }
                    materialProd.setVerifytime(new Date());
                }
                list.add(materialProd);
            }
        }
        if (null != materialProdForm.getAdd() && materialProdForm.getAdd().size() > 0) {
            for (ProMaterialPlanV materialProd : materialProdForm.getAdd()) {
                if (StringUtils.isNotBlank((CharSequence)materialProd.getPantime())) {
                    materialProd.setPantime(materialProd.getPantime().replace("-", ""));
                }
                if (flag.equals("upDateList")) {
                    if (user != null) {
                        materialProd.setCreator(user.getEmployeeName());
                    }
                    materialProd.setCreattime(date);
                }
                list.add(materialProd);
            }
        }
        if (ids != null && null != materialProdForm.getDel() && materialProdForm.getDel().size() > 0) {
            for (String id : materialProdForm.getDel()) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                ids.add(id);
            }
        }
        return list;
    }

    @RequestMapping(value={"/ProPlan/crateProPlanMailContent"})
    public BaseJsonVo<String> crateProPlanMailContent() {
        return this.proMaterialPlanService.crateProPlanMailContent();
    }

    @RequestMapping(value={"/ProPlan/findPageByBom"})
    @ResponseBody
    public JqGridData<ProMaterialPlanV> findPageByBom(HttpServletRequest request, String matNameSearch, String pantime, String panstatusNo, String panstatus, String podMatClassId, String panstatusFlag, String planningtype) {
        String page = request.getParameter("page");
        String rows = request.getParameter("rows");
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)matNameSearch)) {
            param.put("matNameSearch", matNameSearch);
        }
        if (StringUtils.isNotBlank((CharSequence)pantime)) {
            param.put("pantime", pantime.replace("-", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)panstatus)) {
            param.put("panstatus", panstatus);
        }
        if (StringUtils.isNotBlank((CharSequence)panstatusFlag)) {
            param.put("panstatusFlag", "true");
        }
        if (StringUtils.isNotBlank((CharSequence)panstatusNo)) {
            param.put("panstatusNo", panstatusNo);
        }
        if (StringUtils.isNotBlank((CharSequence)podMatClassId)) {
            param.put("podMatClassId", podMatClassId);
        }
        if (StringUtils.isNotBlank((CharSequence)planningtype)) {
            param.put("planningtype", planningtype);
        }
        int pageNo = 0;
        int pageSize = 0;
        if (StringUtils.isNotBlank((CharSequence)page) && StringUtils.isNotBlank((CharSequence)rows)) {
            pageNo = Integer.valueOf(page);
            pageSize = Integer.valueOf(rows);
        }
        List list = this.proMaterialPlanService.findPlanAndBomByPage(Integer.valueOf(pageNo), Integer.valueOf(pageSize), param);
        JqGridData gridData = new JqGridData(list);
        return gridData;
    }
}

