/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.dao.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.dao.ProTransportCalendarMapper;
import cc.lechun.pro.entity.ProTransportCalendarEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProTransportCalendarDao {
    private Logger log = LoggerFactory.getLogger(ProTransportCalendarDao.class);
    @Autowired
    private ProTransportCalendarMapper proTransportCalendarMapper;

    public void saveOrUpdate(List<ProTransportCalendarEntity> list, BaseUser user) throws Exception {
        Date today = new Date();
        if (list != null && list.size() > 0) {
            for (ProTransportCalendarEntity proTransportCalendar : list) {
                String newDate = proTransportCalendar.getLogisticsDate() + " " + proTransportCalendar.getStartTime();
                Date newDate1 = DateUtils.getDateFromString((String)newDate, (String)"yyyyMMdd HH:mm");
                Date newDatehaulCycle = DateUtils.getAddDateBySecond((Date)newDate1, (int)(proTransportCalendar.getHaulCycle() * 60 * 60));
                proTransportCalendar.setArrivetime(newDatehaulCycle);
                proTransportCalendar.setModifytime(today);
                if (user != null) {
                    proTransportCalendar.setModifier(user.getEmployeeName());
                }
                if (StringUtils.isNotBlank((CharSequence)proTransportCalendar.getId())) {
                    this.update(proTransportCalendar);
                    continue;
                }
                this.save(proTransportCalendar);
            }
        }
    }

    public void update(ProTransportCalendarEntity proTransportCalendar) throws Exception {
        this.proTransportCalendarMapper.updateByPrimaryKey((Object)proTransportCalendar);
    }

    public void save(ProTransportCalendarEntity proTransportCalendar) throws Exception {
        proTransportCalendar.setId(IDGenerate.getUniqueIdStr());
        this.proTransportCalendarMapper.deleteByproTransportCalendar(proTransportCalendar);
        this.proTransportCalendarMapper.insert((Object)proTransportCalendar);
    }

    public void deleteByIds(List<String> ids) throws Exception {
        if (ids != null && ids.size() > 0) {
            this.proTransportCalendarMapper.deleteByIds(ids);
        }
    }

    public List<ProTransportCalendarEntity> findProTransportCalendars() {
        Date date = new Date();
        String today = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dytoday", today);
        return this.proTransportCalendarMapper.loadList(map);
    }
}

