/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.api.ProPredictMatService;
import cc.lechun.pro.apiinvoke.OmsServiceClient;
import cc.lechun.pro.apiinvoke.WmsServiceClient;
import cc.lechun.pro.dao.ProBalancEinventoryRelationMapper;
import cc.lechun.pro.dao.ProFactoryCalendarBuildMapper;
import cc.lechun.pro.dao.ProPredictDetailMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.dao.impl.FreshnessStatisticsDao;
import cc.lechun.pro.dao.impl.ProAllocationSumHistoryOccupyDao;
import cc.lechun.pro.dao.impl.ProBalancEinventoryRelationDao;
import cc.lechun.pro.dao.impl.ProFactoryAllotCalendarDao;
import cc.lechun.pro.dao.impl.ProFactoryCalendarBuilDao;
import cc.lechun.pro.dao.impl.ProMaterialPlanHistoryOccupyDao;
import cc.lechun.pro.entity.ProMaterialPlanHistoryOccupyEntity;
import cc.lechun.pro.entity.ProPredictDetailEntity;
import cc.lechun.pro.entity.ProPredictSumEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.vo.EinventoryRelationV;
import cc.lechun.pro.entity.vo.FreshnessStatisticsV;
import cc.lechun.pro.entity.vo.ProAllocationSumHistoryOccupyV;
import cc.lechun.pro.entity.vo.ProFactoryAllotCalendarV;
import cc.lechun.pro.entity.vo.ProFactoryCalendarBuildV;
import cc.lechun.pro.entity.vo.ProStoreMaterialV;
import cc.lechun.pro.service.BalancEinventoryService;
import cc.lechun.pro.util.BalancEinventoryBuildData;
import cc.lechun.pro.util.BatchAddOrUpdate;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BalancEinventoryServiceImpl
implements BalancEinventoryService {
    @Autowired
    ProFactoryCalendarBuildMapper proFactoryCalendarBuildMapper;
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private ProPredictDetailMapper proPredictDetailMapper;
    @Autowired
    private ProBalancEinventoryRelationMapper proBalancEinventoryRelationMapper;
    @Autowired
    private ProFactoryAllotCalendarDao proFactoryAllotCalendarDao;
    @Autowired
    private OmsServiceClient omsServiceClient;
    @Autowired
    private WmsServiceClient wmsServiceClient;
    @Autowired
    private ProMaterialPlanHistoryOccupyDao proMaterialPlanHistoryOccupyDao;
    @Autowired
    private ProBalancEinventoryRelationDao proBalancEinventoryRelationDao;
    @Autowired
    private FreshnessStatisticsDao freshnessStatisticsDao;
    @Autowired
    private ProFactoryCalendarBuilDao proFactoryCalendarBuilDao;
    @Autowired
    private ProPredictMatService proPredictMatService;
    @Autowired
    private ProAllocationSumHistoryOccupyDao proAllocationSumHistoryOccupyDao;
    private Logger log = LoggerFactory.getLogger((String)BalancEinventoryServiceImpl.class.getName());

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo balancEinventoryService(String flag) {
        long time3 = System.currentTimeMillis();
        BaseJsonVo baseJsonVoObject = new BaseJsonVo();
        baseJsonVoObject.setStatus(200);
        try {
            Date date = new Date();
            List storeMaterials = null;
            Object storeMaterialsA = null;
            BaseJsonVo baseJsonVo = null;
            List saleMaterials = null;
            List predictDetaiBeforTwoDays = null;
            try {
                storeMaterials = this.proStoreMaterialMapper.findListByBalanc();
            }
            catch (Exception el) {
                el.printStackTrace();
                this.log.error("\u4ed3\u5e93\u6570\u636e\u83b7\u53d6\u5f02\u5e38 ", (Throwable)el);
                baseJsonVoObject.setStatus(500);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u4ed3\u5e93\u6570\u636e\u83b7\u53d6\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            long a = System.currentTimeMillis();
            try {
                baseJsonVo = this.omsServiceClient.proNeedDispatchOrder();
                if (baseJsonVo.getStatus() == 200) {
                    saleMaterials = (List)baseJsonVo.getValue();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                long b = System.currentTimeMillis();
                this.log.info("OMS\u6570\u636e\u83b7\u53d6 \u5f02\u5e38\u8017\u65f6  " + (b - a));
                baseJsonVoObject.setStatus(500);
                this.log.error("OMS\u6570\u636e\u83b7\u53d6\u5f02\u5e38 ", (Throwable)e);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u9500\u552e\u53d1\u8d27\u5355\u6570\u636e\u83b7\u53d6\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            HashMap<String, Object> param1 = new HashMap<String, Object>();
            String beforTwoDays = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)0), (String)"yyyyMMdd");
            param1.put("beforDays", beforTwoDays);
            param1.put("proIsTrue", true);
            try {
                predictDetaiBeforTwoDays = this.proPredictDetailMapper.findList(param1);
                Set checkPredictDetailFreshness = this.checkPredictDetailFreshness(predictDetaiBeforTwoDays);
                if (checkPredictDetailFreshness.size() > 0) {
                    baseJsonVoObject.setStatus(500);
                    baseJsonVoObject.setMessage(JSONObject.toJSONString((Object)checkPredictDetailFreshness));
                    return baseJsonVoObject;
                }
                Collections.sort(predictDetaiBeforTwoDays, new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("\u83b7\u53d6\u9884\u6d4b\u8be6\u60c5\u5f02\u5e38 ", (Throwable)e);
                baseJsonVoObject.setStatus(500);
                baseJsonVoObject.setMessage("\u83b7\u53d6\u9884\u6d4b\u8be6\u60c5\u5f02\u5e38\n");
                return baseJsonVoObject;
            }
            long time7 = System.currentTimeMillis();
            this.log.info("\u5e93\u5b58\u5e73\u8861 \u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u8017\u65f6 =============\u300b " + (time7 - time3) + " \u6beb\u79d2");
            this.checkProMatClassId(storeMaterials);
            List list = null;
            try {
                list = BalancEinventoryBuildData.addBalancEinventorys((List)storeMaterials, (List)saleMaterials, (WmsServiceClient)this.wmsServiceClient, (ProFactoryAllotCalendarDao)this.proFactoryAllotCalendarDao, (List)predictDetaiBeforTwoDays, (String)flag);
            }
            catch (Exception e) {
                baseJsonVoObject.setStatus(500);
                baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u5e93\u5b58\u5e73\u8861\u6570\u636e\u5904\u7406\u5f02\u5e38\n");
                this.log.error("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458 ", (Throwable)e);
                return baseJsonVoObject;
            }
            long time8 = System.currentTimeMillis();
            this.log.info("\u5e93\u5b58\u5e73\u8861\u83b7\u53d6 \u5e73\u8861\u5173\u7cfb ==============\u300b\u300b\u300b\u300b\u300b\u300b " + (time8 - time7) + " \u6beb\u79d2 \u5927\u5c0f \uff1a" + (list != null ? list.size() : 0));
            this.proBalancEinventoryRelationMapper.deleteAll();
            if (list != null && list.size() > 0) {
                new BatchAddOrUpdate(37).batch(list, (BatchAddOrUpdate.ToRunMethod)new /* Unavailable Anonymous Inner Class!! */);
                this.proBalancEinventoryRelationMapper.updatedispatch();
                this.proBalancEinventoryRelationMapper.updateallot();
                this.proBalancEinventoryRelationMapper.updatePredictSum();
                this.proBalancEinventoryRelationMapper.updatePredict();
            }
            List loadList = this.proBalancEinventoryRelationMapper.toRelationData(null);
            this.initialnumDatas(storeMaterials);
            this.changeproDatasShanghai(storeMaterials, loadList);
            this.changeproDatasBeijing(storeMaterials, loadList);
            new BatchAddOrUpdate(37).batch(storeMaterials, (BatchAddOrUpdate.ToRunMethod)new /* Unavailable Anonymous Inner Class!! */);
            long time9 = System.currentTimeMillis();
            this.log.info("\u5e93\u5b58\u5e73\u8861\u83b7\u53d6\u64cd\u4f5c\u5e73\u8861\u5173\u7cfb ==============\u300b\u300b\u300b\u300b\u300b\u300b " + (time9 - time8) + " \u6beb\u79d2");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u5f02\u5e38 ;", (Throwable)e);
            baseJsonVoObject.setStatus(500);
            baseJsonVoObject.setMessage("\u6570\u636e\u5f02\u5e38\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\n" + e.getMessage());
            baseJsonVoObject.setError_msg(System.err.toString());
        }
        long time4 = System.currentTimeMillis();
        this.log.info("=====balancEinventoryService=====\u5e93\u5b58\u6279\u6b21\u5339\u914d\u8017\u65f6  ==\u300b" + (time4 - time3) + "\u6beb\u79d2");
        return baseJsonVoObject;
    }

    private List<ProStoreMaterialV> initializeDatas(List<ProStoreMaterialV> storeMaterials) throws Exception {
        LinkedList<ProStoreMaterialV> list = new LinkedList<ProStoreMaterialV>();
        if (storeMaterials != null && storeMaterials.size() > 0) {
            for (ProStoreMaterialV proStoreMaterial : storeMaterials) {
                if (proStoreMaterial.getEdbinitialnum() <= 0 || proStoreMaterial.getProdtime() == null) continue;
                proStoreMaterial.setInitialnum(null);
                proStoreMaterial.setSurplusnum(null);
                proStoreMaterial.setSiltcargonum(proStoreMaterial.getEdbinitialnum());
                proStoreMaterial.setOccupynum(null);
                proStoreMaterial.setMatchingoccupynum(Integer.valueOf(0));
                if (proStoreMaterial.getProdtime() == null || proStoreMaterial.getEdbinitialnum() == null || proStoreMaterial.getEdbinitialnum() <= 0) continue;
                list.add(proStoreMaterial);
            }
        }
        return list;
    }

    private synchronized void changeproDatasShanghai(List<ProStoreMaterialV> storeMaterials, List<EinventoryRelationV> loadList) throws Exception {
        HashMap<String, ProFactoryAllotCalendarV> map = new HashMap<String, ProFactoryAllotCalendarV>();
        for (ProStoreMaterialV proStoreMaterialEntity : storeMaterials) {
            if (!proStoreMaterialEntity.getStoreid().equals("1069807551659380736")) continue;
            ProFactoryAllotCalendarV proFactoryAllotCalendarV = null;
            if (map.containsKey(proStoreMaterialEntity.getStoreid() + proStoreMaterialEntity.getPodMatClassId())) {
                proFactoryAllotCalendarV = (ProFactoryAllotCalendarV)map.get(proStoreMaterialEntity.getStoreid() + proStoreMaterialEntity.getPodMatClassId());
            } else {
                proFactoryAllotCalendarV = this.proFactoryAllotCalendarDao.findProFactoryAllotCalendarVByBalancEinventory(proStoreMaterialEntity.getStoreid(), proStoreMaterialEntity.getPodMatClassId());
                map.put(proStoreMaterialEntity.getStoreid() + proStoreMaterialEntity.getPodMatClassId(), proFactoryAllotCalendarV);
            }
            if (proFactoryAllotCalendarV == null) continue;
            int initialnum = 0;
            if (proStoreMaterialEntity.getDatatpye().equals(2)) {
                initialnum = this.sumInitialnumShangHai((ProStoreMaterialEntity)proStoreMaterialEntity, proFactoryAllotCalendarV.getPlanstarttime(), loadList);
            } else if (proStoreMaterialEntity.getDatatpye().equals(0)) {
                initialnum = this.sumInitialnumShangHai((ProStoreMaterialEntity)proStoreMaterialEntity, proFactoryAllotCalendarV.getPlanendtime(), loadList);
            }
            int allotpredictnum = this.allotpredictnum((ProStoreMaterialEntity)proStoreMaterialEntity, loadList);
            if (initialnum == 0) {
                proStoreMaterialEntity.setInitialnum(Integer.valueOf(initialnum));
                proStoreMaterialEntity.setSurplusnum(null);
                proStoreMaterialEntity.setSurplusnum(Integer.valueOf(initialnum));
            } else {
                proStoreMaterialEntity.setInitialnum(Integer.valueOf(initialnum));
                proStoreMaterialEntity.setSurplusnum(Integer.valueOf(initialnum));
            }
            proStoreMaterialEntity.setAllotpredictnum(Integer.valueOf(allotpredictnum));
        }
    }

    private synchronized void changeproDatasBeijing(List<ProStoreMaterialV> storeMaterials, List<EinventoryRelationV> loadList) throws Exception {
        HashMap<String, List> map = new HashMap<String, List>();
        for (ProStoreMaterialV proStoreMaterialEntity : storeMaterials) {
            if (proStoreMaterialEntity.getStoreid().equals("1069807551659380736")) continue;
            List proFactoryCalendarBuildVs = null;
            if (map.containsKey(proStoreMaterialEntity.getStoreid() + proStoreMaterialEntity.getPodMatClassId())) {
                proFactoryCalendarBuildVs = (List)map.get(proStoreMaterialEntity.getStoreid() + proStoreMaterialEntity.getPodMatClassId());
            } else {
                proFactoryCalendarBuildVs = this.proFactoryCalendarBuilDao.findFactoryCalendarBuildVByBalancEinventory(proStoreMaterialEntity.getStoreid(), proStoreMaterialEntity.getPodMatClassId());
                map.put(proStoreMaterialEntity.getStoreid() + proStoreMaterialEntity.getPodMatClassId(), proFactoryCalendarBuildVs);
            }
            if (proFactoryCalendarBuildVs == null) continue;
            int initialnum = this.sumInitialnumBeijing((ProStoreMaterialEntity)proStoreMaterialEntity, proFactoryCalendarBuildVs, loadList);
            int allotpredictnum = this.allotpredictnum((ProStoreMaterialEntity)proStoreMaterialEntity, loadList);
            if (initialnum == 0) {
                proStoreMaterialEntity.setInitialnum(Integer.valueOf(initialnum));
                proStoreMaterialEntity.setSurplusnum(null);
                proStoreMaterialEntity.setSurplusnum(Integer.valueOf(initialnum));
            } else {
                proStoreMaterialEntity.setInitialnum(Integer.valueOf(initialnum));
                proStoreMaterialEntity.setSurplusnum(Integer.valueOf(initialnum));
            }
            proStoreMaterialEntity.setAllotpredictnum(Integer.valueOf(allotpredictnum));
        }
    }

    private void checkProMatClassId(List<ProStoreMaterialV> storeMaterials) throws Exception {
        String message = "";
        HashSet<String> matids = new HashSet<String>();
        if (storeMaterials != null && storeMaterials.size() > 0) {
            for (ProStoreMaterialV proStoreMateria : storeMaterials) {
                if (null != proStoreMateria.getPodMatClassId() && !proStoreMateria.getPodMatClassId().trim().equals("") || matids.contains(proStoreMateria.getMatid())) continue;
                message = message + "( \u540d\u79f0 :  " + proStoreMateria.getMatname() + "  id : " + proStoreMateria.getMatid() + "  code : " + proStoreMateria.getMatcode() + " )\n<br>";
                matids.add(proStoreMateria.getMatid());
            }
        }
        if (!message.equals("")) {
            throw new RuntimeException(message + "\n \u4ee5\u4e0a\u7269\u54c1\u672a\u8bbe\u7f6e\u751f\u4ea7\u5206\u7c7b,\u8bf7\u5230\u7269\u54c1\u751f\u4ea7\u5c5e\u6027\u914d\u7f6e\u9875\u8fdb\u884c\u914d\u7f6e\u3002<br>");
        }
    }

    private void initialnumDatas(List<ProStoreMaterialV> storeMaterials) throws Exception {
        if (storeMaterials != null && storeMaterials.size() > 0) {
            for (ProStoreMaterialEntity proStoreMaterialEntity : storeMaterials) {
                proStoreMaterialEntity.setInitialnum(null);
                proStoreMaterialEntity.setSurplusnum(null);
                proStoreMaterialEntity.setOccupynum(null);
            }
        }
    }

    private int allotpredictnum(ProStoreMaterialEntity proStoreMaterialEntity, List<EinventoryRelationV> loadList) {
        int sum = 0;
        for (EinventoryRelationV einventoryRelation : loadList) {
            if (!proStoreMaterialEntity.getStoreid().equals(einventoryRelation.getStoreid()) || !proStoreMaterialEntity.getMatid().equals(einventoryRelation.getMatid()) || !DateUtils.formatDate((Date)proStoreMaterialEntity.getProdtime(), (String)"yyyyMMdd").equals(einventoryRelation.getProDate()) || einventoryRelation.getType() != 5 && einventoryRelation.getType() != 4) continue;
            sum += einventoryRelation.getOccupynum().intValue();
        }
        return sum;
    }

    private synchronized int sumInitialnumBeijing(ProStoreMaterialEntity proStoreMaterialEntity, List<ProFactoryCalendarBuildV> list, List<EinventoryRelationV> loadList) throws Exception {
        int sum = 0;
        block0: for (EinventoryRelationV einventoryRelation : loadList) {
            if (!proStoreMaterialEntity.getStoreid().equals(einventoryRelation.getStoreid()) || !einventoryRelation.getStoreid().equals(einventoryRelation.getBalancStoreid()) || !proStoreMaterialEntity.getMatid().equals(einventoryRelation.getMatid()) || !DateUtils.formatDate((Date)proStoreMaterialEntity.getProdtime(), (String)"yyyyMMdd").equals(einventoryRelation.getProDate()) || !einventoryRelation.getEinventoryid().equals(proStoreMaterialEntity.getTpsmid()) || einventoryRelation.getType() != 2 || proStoreMaterialEntity.getDatatpye() != einventoryRelation.getDatatpye() || list.size() <= 0) continue;
            for (ProFactoryCalendarBuildV proFactoryCalendarBuildV : list) {
                Long pickupdate = Long.valueOf(einventoryRelation.getPickupdate());
                Long startTimeL = Long.valueOf(proFactoryCalendarBuildV.getStartdate());
                Long endTimeL = Long.valueOf(proFactoryCalendarBuildV.getEnddate());
                if (pickupdate < startTimeL || pickupdate > endTimeL) continue;
                sum += einventoryRelation.getOccupynum().intValue();
                continue block0;
            }
        }
        return sum;
    }

    private synchronized int sumInitialnumShangHai(ProStoreMaterialEntity proStoreMaterialEntity, Date endTime, List<EinventoryRelationV> loadList) throws Exception {
        int sum = 0;
        for (EinventoryRelationV einventoryRelation : loadList) {
            if (!proStoreMaterialEntity.getStoreid().equals(einventoryRelation.getStoreid()) || !einventoryRelation.getStoreid().equals(einventoryRelation.getBalancStoreid()) || !proStoreMaterialEntity.getMatid().equals(einventoryRelation.getMatid()) || !DateUtils.formatDate((Date)proStoreMaterialEntity.getProdtime(), (String)"yyyyMMdd").equals(einventoryRelation.getProDate()) || !einventoryRelation.getEinventoryid().equals(proStoreMaterialEntity.getTpsmid()) || einventoryRelation.getType() != 2 || !proStoreMaterialEntity.getDatatpye().equals(einventoryRelation.getDatatpye())) continue;
            long pickupdate = Long.valueOf(einventoryRelation.getPickupdate());
            long startTime = Long.valueOf(DateUtils.formatDate((Date)endTime, (String)"yyyyMMdd"));
            if (proStoreMaterialEntity.getDatatpye().equals(2)) {
                if (pickupdate < startTime) continue;
                sum += einventoryRelation.getOccupynum().intValue();
                continue;
            }
            if (!proStoreMaterialEntity.getDatatpye().equals(0) || pickupdate <= startTime) continue;
            sum += einventoryRelation.getOccupynum().intValue();
        }
        return sum;
    }

    public BaseJsonVo<List<EinventoryRelationV>> findRelationData(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            List loadList = this.proBalancEinventoryRelationMapper.findRelationData(param);
            Collections.sort(loadList, new /* Unavailable Anonymous Inner Class!! */);
            baseJsonVo.setValue((Object)loadList);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<FreshnessStatisticsV>> freshnessStatistics(Map<String, Object> param) {
        BaseJsonVo bseJsonVo = new BaseJsonVo();
        bseJsonVo.setStatus(200);
        Date date = new Date();
        String today = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
        try {
            List freshnessStatistics = this.freshnessStatisticsDao.getFreshnessStatisticsByProStoreMaterial(param);
            this.log.info("\u9996\u6b21\u67e5\u8be2 =====================>>>>>>>>>> freshnessStatistics \u5927\u5c0f" + freshnessStatistics.size() + " \u53c2\u6570 : " + JSONObject.toJSONString(param));
            if (param != null) {
                param.put("datatpye", 2);
            } else {
                param = new HashMap<String, Object>();
                param.put("datatpye", 2);
            }
            List list1 = this.proStoreMaterialMapper.findList(param);
            this.sumASiltCargonum(freshnessStatistics, list1, today, date);
            this.log.info("\u4e8c\u6b21\u67e5\u8be2 =====================>>>>>>>>>> freshnessStatistics \u5927\u5c0f" + freshnessStatistics.size());
            this.sumBEinventoryRelationVBeijing(freshnessStatistics, today, date);
            this.sumBEinventoryRelationVShanghai(freshnessStatistics, today, date);
            this.log.info("\u4e09\u6b21\u67e5\u8be2 =====================>>>>>>>>>> freshnessStatistics \u5927\u5c0f" + freshnessStatistics.size());
            List proMaterialPlanHistoryOccupys = this.proMaterialPlanHistoryOccupyDao.findTosupportAmount(today);
            this.sumCPlanHistoryOccupyOccupyToFreshnessStatisticsVByBeijing(freshnessStatistics, proMaterialPlanHistoryOccupys, today);
            this.log.info("\u56db\u6b21\u67e5\u8be2 =====================>>>>>>>>>> freshnessStatistics \u5927\u5c0f" + freshnessStatistics.size());
            List proAllocationSumHistorys = this.proAllocationSumHistoryOccupyDao.findTosupportAmount(today);
            this.sumCAllocationHistoryOccupyToFreshnessStatisticsVByShanhai(freshnessStatistics, proAllocationSumHistorys, today);
            this.log.info("\u4e94\u6b21\u67e5\u8be2 =====================>>>>>>>>>> freshnessStatistics \u5927\u5c0f" + freshnessStatistics.size());
            bseJsonVo.setValue((Object)freshnessStatistics);
        }
        catch (Exception e) {
            this.log.error("\u516d\u6b21\u67e5\u8be2 \u5f02\u5e38=====================", (Throwable)e);
            e.printStackTrace();
            bseJsonVo.setStatus(500);
            bseJsonVo.setMessage(e.getMessage());
        }
        return bseJsonVo;
    }

    private void sumASiltCargonum(List<FreshnessStatisticsV> freshnessStatistics, List<ProStoreMaterialV> list1, String today, Date date) {
        if (freshnessStatistics.size() > 0) {
            for (FreshnessStatisticsV freshnessStatisticsV : freshnessStatistics) {
                int satrtTime = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)(-freshnessStatisticsV.getFreshness().intValue())), (String)"yyyyMMdd"));
                int endTime = Integer.valueOf(today);
                int sum = 0;
                for (ProStoreMaterialEntity proStoreMaterialEntity : list1) {
                    int datenew = Integer.valueOf(DateUtils.formatDate((Date)proStoreMaterialEntity.getProdtime(), (String)"yyyyMMdd"));
                    if (satrtTime > datenew || datenew > endTime || !freshnessStatisticsV.getMatId().equals(proStoreMaterialEntity.getMatid()) || !freshnessStatisticsV.getStoreId().equals(proStoreMaterialEntity.getStoreid())) continue;
                    sum += proStoreMaterialEntity.getSiltcargonum().intValue();
                }
                freshnessStatisticsV.setSum(Integer.valueOf(sum));
            }
        }
    }

    private void sumBEinventoryRelationVBeijing(List<FreshnessStatisticsV> freshnessStatistics, String today, Date date) throws Exception {
        HashMap<String, ProFactoryCalendarBuildV> map = new HashMap<String, ProFactoryCalendarBuildV>();
        if (freshnessStatistics != null && freshnessStatistics.size() > 0) {
            for (FreshnessStatisticsV freshnessStatistic : freshnessStatistics) {
                if (!freshnessStatistic.getStoreId().equals("1037595826996514816")) continue;
                String key = today + freshnessStatistic.getPodMatClassId() + freshnessStatistic.getStoreId();
                ProFactoryCalendarBuildV proFactoryCalendarBuilsNew = null;
                if (map.keySet().contains(key)) {
                    proFactoryCalendarBuilsNew = (ProFactoryCalendarBuildV)map.get(key);
                } else {
                    proFactoryCalendarBuilsNew = this.proFactoryCalendarBuilDao.findMaxProFactoryCalendarBuilsByToday(today, freshnessStatistic.getPodMatClassId(), freshnessStatistic.getStoreId());
                    map.put(key, proFactoryCalendarBuilsNew);
                }
                if (proFactoryCalendarBuilsNew == null) continue;
                String enddate = proFactoryCalendarBuilsNew.getEnddate();
                String startTime = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)enddate, (String)"yyyyMMdd"), (int)1), (String)"yyyyMMdd");
                List list2 = this.proBalancEinventoryRelationDao.findSumUnnecessaryOccupy(null, freshnessStatistic.getStoreId(), freshnessStatistic.getMatId(), startTime);
                if (list2.size() < 1) continue;
                this.sumB(list2, today, date, freshnessStatistic);
            }
        }
    }

    private void sumB(List<EinventoryRelationV> list2, String today, Date date, FreshnessStatisticsV freshnessStatistic) {
        int satrtTimeNwe = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)(-freshnessStatistic.getFreshness().intValue())), (String)"yyyyMMdd"));
        int endTime = Integer.valueOf(today);
        int sum = 0;
        for (EinventoryRelationV einventoryRelationv : list2) {
            int datenew;
            if (einventoryRelationv.getType() != 2 || einventoryRelationv.getDatatpye() != 2 || satrtTimeNwe > (datenew = Integer.valueOf(einventoryRelationv.getProDate()).intValue()) || datenew > endTime || !freshnessStatistic.getMatId().equals(einventoryRelationv.getMatid()) || !freshnessStatistic.getStoreId().equals(einventoryRelationv.getStoreid())) continue;
            sum += einventoryRelationv.getOccupynum().intValue();
        }
        freshnessStatistic.setSum(Integer.valueOf(freshnessStatistic.getSum() + sum));
    }

    private void sumBEinventoryRelationVShanghai(List<FreshnessStatisticsV> freshnessStatistics, String today, Date date) throws Exception {
        HashMap<String, ProFactoryAllotCalendarV> map = new HashMap<String, ProFactoryAllotCalendarV>();
        if (freshnessStatistics != null && freshnessStatistics.size() > 0) {
            for (FreshnessStatisticsV freshnessStatistic : freshnessStatistics) {
                if (!freshnessStatistic.getStoreId().equals("1069807551659380736")) continue;
                String key = today + freshnessStatistic.getPodMatClassId() + freshnessStatistic.getStoreId();
                ProFactoryAllotCalendarV ProFactoryAllotCalendarVNew = null;
                if (map.keySet().contains(key)) {
                    ProFactoryAllotCalendarVNew = (ProFactoryAllotCalendarV)map.get(key);
                } else {
                    ProFactoryAllotCalendarVNew = this.proFactoryAllotCalendarDao.findProFactoryAllotCalendarVByeqtoday(freshnessStatistic.getStoreId(), freshnessStatistic.getPodMatClassId());
                    if (ProFactoryAllotCalendarVNew != null) {
                        map.put(key, ProFactoryAllotCalendarVNew);
                    }
                }
                String startTime = "";
                startTime = ProFactoryAllotCalendarVNew == null ? DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)1), (String)"yyyyMMdd") : DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)2), (String)"yyyyMMdd");
                List list2 = this.proBalancEinventoryRelationDao.findSumUnnecessaryOccupy(null, freshnessStatistic.getStoreId(), freshnessStatistic.getMatId(), startTime);
                if (list2.size() < 1) continue;
                this.sumB(list2, today, date, freshnessStatistic);
            }
        }
    }

    private void sumCAllocationHistoryOccupyToFreshnessStatisticsVByShanhai(List<FreshnessStatisticsV> set, List<ProAllocationSumHistoryOccupyV> proAllocationSumHistorys, String today) {
        if (set != null && set.size() > 0) {
            for (FreshnessStatisticsV freshnessStatistics : set) {
                if (!freshnessStatistics.getStoreId().equals("1069807551659380736")) continue;
                Integer freshness = freshnessStatistics.getFreshness();
                if (proAllocationSumHistorys != null && proAllocationSumHistorys.size() > 0) {
                    for (ProAllocationSumHistoryOccupyV proAllocationSumHistory : proAllocationSumHistorys) {
                        if (!proAllocationSumHistory.getMatId().equals(freshnessStatistics.getMatId()) || !proAllocationSumHistory.getStoreInId().equals(freshnessStatistics.getStoreId()) || !this.checkTimePlanHistoryOccupy(freshness, proAllocationSumHistory.getCbatchname(), today)) continue;
                        freshnessStatistics.setOccupynum(Integer.valueOf((freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0) + proAllocationSumHistory.getAllotOccupyNum()));
                        freshnessStatistics.setPlanaddnum(Integer.valueOf((freshnessStatistics.getPlanaddnum() != null ? freshnessStatistics.getPlanaddnum() : 0) + (proAllocationSumHistory.getAllotReduceNum() != null ? proAllocationSumHistory.getAllotReduceNum() : 0)));
                    }
                }
                freshnessStatistics.setSum_occupynum_planaddnum(Integer.valueOf((freshnessStatistics.getSum() != null ? freshnessStatistics.getSum() : 0) - (freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0)));
                int occupynum = freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0;
                int planaddnum = freshnessStatistics.getPlanaddnum() != null ? freshnessStatistics.getPlanaddnum() : 0;
                int C = 0;
                C = planaddnum >= occupynum ? occupynum : planaddnum;
                freshnessStatistics.setSum_occupynum_planaddnum(Integer.valueOf(freshnessStatistics.getSum_occupynum_planaddnum() + C));
            }
        }
    }

    private void sumCPlanHistoryOccupyOccupyToFreshnessStatisticsVByBeijing(List<FreshnessStatisticsV> set, List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, String today) {
        if (set != null && set.size() > 0) {
            for (FreshnessStatisticsV freshnessStatistics : set) {
                if (!freshnessStatistics.getStoreId().equals("1037595826996514816")) continue;
                Integer freshness = freshnessStatistics.getFreshness();
                if (proMaterialPlanHistoryOccupys != null && proMaterialPlanHistoryOccupys.size() > 0) {
                    for (ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy : proMaterialPlanHistoryOccupys) {
                        if (!proMaterialPlanHistoryOccupy.getMatid().equals(freshnessStatistics.getMatId()) || !proMaterialPlanHistoryOccupy.getStoreid().equals(freshnessStatistics.getStoreId()) || !this.checkTimePlanHistoryOccupy(freshness, proMaterialPlanHistoryOccupy.getCbatchname(), today)) continue;
                        freshnessStatistics.setOccupynum(Integer.valueOf((freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0) + proMaterialPlanHistoryOccupy.getOccupynum()));
                        freshnessStatistics.setPlanaddnum(Integer.valueOf((freshnessStatistics.getPlanaddnum() != null ? freshnessStatistics.getPlanaddnum() : 0) + (proMaterialPlanHistoryOccupy.getPlanaddnum() != null ? proMaterialPlanHistoryOccupy.getPlanaddnum() : 0)));
                    }
                }
                freshnessStatistics.setSum_occupynum_planaddnum(Integer.valueOf((freshnessStatistics.getSum() != null ? freshnessStatistics.getSum() : 0) - (freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0)));
                int occupynum = freshnessStatistics.getOccupynum() != null ? freshnessStatistics.getOccupynum() : 0;
                int planaddnum = freshnessStatistics.getPlanaddnum() != null ? freshnessStatistics.getPlanaddnum() : 0;
                int C = 0;
                C = planaddnum >= occupynum ? occupynum : planaddnum;
                freshnessStatistics.setSum_occupynum_planaddnum(Integer.valueOf(freshnessStatistics.getSum_occupynum_planaddnum() + C));
            }
        }
    }

    private boolean checkTimePlanHistoryOccupy(Integer freshness, String cbatchname, String today) {
        int startTimeString = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)today, (String)"yyyyMMdd"), (int)(-freshness.intValue())), (String)"yyyyMMdd"));
        int endTimeString = Integer.valueOf(today);
        int timeString = Integer.valueOf(cbatchname);
        return startTimeString <= timeString && timeString <= endTimeString;
    }

    private Set<String> checkPredictDetailFreshness(List<ProPredictDetailEntity> list) {
        HashSet<String> rreturnMsg = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (ProPredictDetailEntity p : list) {
                Boolean flag = true;
                StringBuffer sb = new StringBuffer();
                if (p.getFreshness() != null) continue;
                if (StringUtils.isBlank((CharSequence)p.getCtype())) {
                    rreturnMsg.add("\u8bf7\u5728\u9500\u552e\u7ba1\u7406/\u5ba2\u6237\u6863\u6848~\u8bbe\u7f6e\u5ba2\u6237(" + p.getBctname() + ") - \u7684\u53d1\u8d27\u6a21\u5f0f");
                }
                if (StringUtils.isBlank((CharSequence)p.getPlanningtype())) {
                    rreturnMsg.add("\u8bf7\u5728\u57fa\u7840\u6570\u636e/\u7269\u54c1/\u4e2d\u8bbe\u7f6e~\u7269\u54c1(" + p.getMatname() + ") - \u7684\u8ba1\u5212\u5206\u7c7b");
                    continue;
                }
                if (!p.getConfigureflag().equals("\u5426")) continue;
                rreturnMsg.add("\u8bf7\u5728\u8ba1\u5212\u7ba1\u7406/\u65b0\u9c9c\u5ea6\u914d\u7f6e/\u4e2d\u8bbe\u7f6e~(" + p.getStorename() + "/" + p.getCtype() + "/" + p.getPlanningtype() + ") - \u4ed3\u5e93/\u53d1\u8d27\u6a21\u5f0f/\u7269\u54c1\u8ba1\u5212\u5206\u7c7b/\u65b0\u9c9c\u5ea6");
            }
        }
        return rreturnMsg;
    }

    private Set<String> checkPredictSumFreshness(List<ProPredictSumEntity> list) {
        HashSet<String> rreturnMsg = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (ProPredictSumEntity p : list) {
                if (p.getFreshness() != null) continue;
                rreturnMsg.add("\u9884\u6d4b\u9700\u6c42\u6c47\u603b\u8868(" + p.getMatname() + ") - \u65b0\u9c9c\u5ea6\u4e3a\u7a7a");
            }
        }
        return rreturnMsg;
    }

    static /* synthetic */ ProBalancEinventoryRelationMapper access$000(BalancEinventoryServiceImpl x0) {
        return x0.proBalancEinventoryRelationMapper;
    }

    static /* synthetic */ ProStoreMaterialMapper access$100(BalancEinventoryServiceImpl x0) {
        return x0.proStoreMaterialMapper;
    }
}

