/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.ProFactoryCalendarMapper;
import cc.lechun.pro.dao.impl.ProFactoryCalendarDao;
import cc.lechun.pro.entity.ProFactoryCalendarEntity;
import cc.lechun.pro.service.ProFactoryCalendarService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProFactoryCalendarServiceImpl
implements ProFactoryCalendarService {
    @Autowired
    private ProFactoryCalendarMapper proFactoryCalendarMapper;
    @Autowired
    private ProFactoryCalendarDao proFactoryCalendarDao;

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpDate(List<ProFactoryCalendarEntity> proFactoryCalendarEntitys, List<String> deleteIds) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProFactoryCalendarEntity> listAdd = new ArrayList<ProFactoryCalendarEntity>();
            ArrayList<ProFactoryCalendarEntity> listUpdate = new ArrayList<ProFactoryCalendarEntity>();
            if (proFactoryCalendarEntitys != null) {
                for (ProFactoryCalendarEntity proFactoryCalendar : proFactoryCalendarEntitys) {
                    if (StringUtils.isNotBlank((String)proFactoryCalendar.getId())) {
                        listUpdate.add(proFactoryCalendar);
                        continue;
                    }
                    proFactoryCalendar.setId(IDGenerate.getUniqueIdStr());
                    listAdd.add(proFactoryCalendar);
                }
                if (deleteIds != null && deleteIds.size() > 0) {
                    this.proFactoryCalendarMapper.deleteByIds(deleteIds);
                }
                if (listAdd.size() > 0) {
                    this.proFactoryCalendarMapper.addRecordsBatch(listAdd);
                }
                if (listUpdate.size() > 0) {
                    this.proFactoryCalendarMapper.updateBatch(listUpdate);
                }
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProFactoryCalendarEntity>> findPage(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            pageNo = pageNo == null ? 0 : pageNo;
            pageSize = pageSize == null ? 0 : pageSize;
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proFactoryCalendarMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo<List<ProFactoryCalendarEntity>> createProCalendar(List<ProFactoryCalendarEntity> proFactoryCalendarEntitys) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proFactoryCalendarDao.saveOrUpdate(proFactoryCalendarEntitys);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u540e\u53f0\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deletes(List<String> ids) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proFactoryCalendarDao.deleteByIds(ids);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }
}

