/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.ec.entity.PredictOperateHistoryEntity;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.api.ProPredictMatService;
import cc.lechun.pro.apiinvoke.OmsServiceClient;
import cc.lechun.pro.dao.ProPredictDetailMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.entity.ProPredictDetailEntity;
import cc.lechun.pro.entity.ProPredictSumEntity;
import cc.lechun.pro.util.BatchAddOrUpdate;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
@Service
public class ProPredictMatServiceImpl
implements ProPredictMatService {
    protected String cachKey = "_setCache";
    protected String cachKeyPredictDetail = "_setCachepredictDetail";
    protected String cachKeyOccupySum = "_setCacheoccupySum";
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    @Autowired
    private ProPredictDetailMapper proPredictDetailMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private OmsServiceClient omsServiceClient;
    private Logger log = LoggerFactory.getLogger((String)ProPredictMatServiceImpl.class.getName());

    @RequestMapping(value={"/ppms/saveOrUpdateList"}, method={RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public synchronized BaseJsonVo saveOrUpdateList(@RequestBody List<ProPredictDetailEntity> proPredictDetailEntitys) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        long startUseTime = System.currentTimeMillis();
        this.log.info("\u83b7\u53d6\u5916\u90e8oms \u7269\u54c1\u63a8\u9001\u6570\u636e \u5f00\u59cb \uff1a" + startUseTime);
        if (proPredictDetailEntitys == null || proPredictDetailEntitys.size() < 0) {
            this.log.info("\u83b7\u53d6\u5916\u90e8oms \u7269\u54c1\u63a8\u9001\u6570\u636e \u5927\u5c0f \uff1a\u4e3a\u7a7a");
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg("\u4f20\u8f93\u6570\u636e\u4e3a\u7a7a");
            return baseJsonVo;
        }
        this.log.info("\u83b7\u53d6\u5916\u90e8oms \u7269\u54c1\u63a8\u9001\u6570\u636e \u5927\u5c0f \uff1a" + proPredictDetailEntitys.size());
        Date today = new Date();
        String nowDate = DateUtils.formatDate((Date)today, (String)"yyyyMMdd");
        try {
            this.changeProPredictDetailEntity(proPredictDetailEntitys, nowDate);
            ArrayList predictOperateHistorys = new ArrayList();
            long time1 = System.currentTimeMillis();
            HashSet<String> set = new HashSet<String>();
            ArrayList proPredictDetailsOld = new ArrayList();
            for (ProPredictDetailEntity proPredictDetail : proPredictDetailEntitys) {
                if (set.contains(proPredictDetail.getPreordercode())) continue;
                List list = this.proPredictDetailMapper.findListBypreordercode(proPredictDetail.getPreordercode());
                if (list.size() > 0) {
                    proPredictDetailsOld.addAll(list);
                }
                set.add(proPredictDetail.getPreordercode());
            }
            if (proPredictDetailsOld.size() > 0) {
                for (ProPredictDetailEntity proPredictOld : proPredictDetailsOld) {
                    boolean flagIFExist = false;
                    for (ProPredictDetailEntity proPredictDetail : proPredictDetailEntitys) {
                        if (!proPredictDetail.getDetailToCode().equals(proPredictOld.getDetailToCode())) continue;
                        flagIFExist = true;
                    }
                    if (flagIFExist) continue;
                    this.proPredictDetailMapper.deleteByPrimaryKey((Serializable)((Object)proPredictOld.getGuid()));
                }
            }
            for (ProPredictDetailEntity proPredictDetail : proPredictDetailEntitys) {
                ProPredictDetailEntity proPredictDetailOld = this.proPredictDetailMapper.findByList(proPredictDetail);
                if (proPredictDetailOld != null) {
                    this.changeOperateHistory(proPredictDetail, proPredictDetailOld, predictOperateHistorys);
                    proPredictDetail.setGuid(proPredictDetailOld.getGuid());
                    this.proPredictDetailMapper.updateByPrimaryKey((Object)proPredictDetail);
                    continue;
                }
                proPredictDetail.setGuid(IDGenerate.getUniqueIdStr());
                this.proPredictDetailMapper.insertSelective((Object)proPredictDetail);
            }
            if (predictOperateHistorys.size() > 0) {
                this.proPredictDetailMapper.addRecordsHistoryBatch(predictOperateHistorys);
            }
            this.redisRemoveCanSellNum(proPredictDetailEntitys);
            long time2 = System.currentTimeMillis();
            this.log.info("==========\u83b7\u53d6\u5916\u90e8oms\u5b58\u5e93\u6570\u636e\u5165\u5e93\u8017\u65f6======" + (time2 - time1) + "\u6beb\u79d2 \u5927\u5c0f " + proPredictDetailEntitys.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u83b7\u53d6\u5916\u90e8oms\u751f\u6210 \u5f02\u5e38\u6570\u636e\u4e3a:" + JSONObject.toJSONString(proPredictDetailEntitys));
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
            this.log.error("\u83b7\u53d6\u5916\u90e8oms \u7269\u54c1\u63a8\u9001\u6570\u636e \u5165\u5e93\u5f02\u5e38 e\uff1a" + e);
        }
        long endUseTime = System.currentTimeMillis();
        this.log.info("\u83b7\u53d6\u5916\u90e8oms \u7269\u54c1\u63a8\u9001\u6570\u636e \u7ed3\u675f \uff1a" + endUseTime + "--\uff08" + (double)(endUseTime - startUseTime) * 1.0 / 100.0 + "\uff09");
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    @RequestMapping(value={"/ppms/deleteByPreordercode"})
    public BaseJsonVo deleteByPreordercode(@RequestBody List<String> preordercodes) {
        this.log.info("\u83b7\u53d6\u5916\u90e8oms \u7269\u54c1\u5220\u9664\u63a8\u9001\u6570\u636e \u5f00\u59cb " + JSONObject.toJSONString(preordercodes));
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        long startUseTime = System.currentTimeMillis();
        try {
            if (preordercodes != null && preordercodes.size() > 0) {
                HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
                paramMap.put("preordercodes", preordercodes);
                List list = this.proPredictDetailMapper.findList(paramMap);
                ArrayList<String> sumids = new ArrayList<String>();
                if (list != null && list.size() > 0) {
                    for (ProPredictDetailEntity proPredictDetail : list) {
                        sumids.add(proPredictDetail.getDetailToSumHashCode());
                    }
                    HashMap<String, ArrayList<String>> param = new HashMap<String, ArrayList<String>>();
                    param.put("guids", sumids);
                    List predictSums = this.proPredictSumMapper.findList(param);
                    if (predictSums != null && predictSums.size() > 0) {
                        for (ProPredictSumEntity proPredictSum : predictSums) {
                            for (ProPredictDetailEntity proPredictDetail : list) {
                                if (!proPredictSum.getGuid().equals(proPredictDetail.getDetailToSumHashCode())) continue;
                                int Predictsum = proPredictSum.getPredictsum();
                                int Shipments = proPredictDetail.getShipments();
                                int num = Predictsum - Shipments;
                                proPredictSum.setPredictsum(Integer.valueOf(num));
                                proPredictSum.setNeedsum(Integer.valueOf(num));
                            }
                        }
                        this.proPredictSumMapper.updateBatch(predictSums);
                    }
                }
                this.proPredictDetailMapper.deleteByParam(paramMap);
            } else {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage("\u8bf7\u6c42\u6570\u636e\u5355\u53f7\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        long endUseTime = System.currentTimeMillis();
        this.log.info("\u83b7\u53d6\u5916\u90e8oms \u7269\u54c1\u63a8\u9001\u6570\u636e \u7ed3\u675f \uff1a" + endUseTime + "--\uff08" + (double)(endUseTime - startUseTime) * 1.0 / 100.0 + "\uff09");
        return baseJsonVo;
    }

    public void redisRemoveCanSellNum(List<ProPredictDetailEntity> proPredictDetailEntitys) {
        for (ProPredictDetailEntity proPredictDetail : proPredictDetailEntitys) {
            this.redisRemoveCanSellNum(proPredictDetail);
        }
    }

    public void redisRemoveCanSellNum(ProPredictDetailEntity proPredictDetail) {
        String key = proPredictDetail.getMatid() + proPredictDetail.getStoreid() + proPredictDetail.getBctid() + proPredictDetail.getPickupdate();
        String key1 = this.cachKey + key;
        this.redisCacheUtil.remove(key1);
        this.log.info("\u6e05\u9664\u7f13\u5b58 ==========>>>> key" + key1);
        String key2 = this.cachKeyPredictDetail + key;
        this.redisCacheUtil.remove(key2);
        this.log.info("\u6e05\u9664\u7f13\u5b58 ==========>>>> key" + key2);
        String key3 = this.cachKeyOccupySum + key;
        this.redisCacheUtil.remove(key3);
        this.log.info("\u6e05\u9664\u7f13\u5b58 ==========>>>> key" + key3);
    }

    private void changeOperateHistory(ProPredictDetailEntity proPredictDetail, ProPredictDetailEntity proPredictDetailOld, List<PredictOperateHistoryEntity> predictOperateHistorys) {
        if (proPredictDetailOld != null) {
            PredictOperateHistoryEntity p = new PredictOperateHistoryEntity();
            p.setCguid(IDGenerate.getUniqueIdStr());
            p.setCustomerid(proPredictDetail.getBctid());
            p.setStoreid(proPredictDetail.getStoreid());
            p.setMatid(proPredictDetail.getMatid());
            p.setPickupdate(DateUtils.getDateFromString((String)proPredictDetail.getPickupdate(), (String)"yyyyMMdd"));
            p.setNewpredict(Long.valueOf((long)proPredictDetail.getShipments().intValue() + 0L));
            p.setOldpredict(Long.valueOf((long)proPredictDetailOld.getShipments().intValue() + 0L));
            p.setOperator("\u4fee\u6539-SYS(" + proPredictDetail.getPreordercode() + ")");
            p.setUpdatetime(new Date());
            predictOperateHistorys.add(p);
        }
    }

    private void changeProPredictDetailEntity(List<ProPredictDetailEntity> proPredictDetailEntitys, String nowDate) {
        for (ProPredictDetailEntity proPredictDetailEntity : proPredictDetailEntitys) {
            if (proPredictDetailEntity.getPickupdate().contains("-")) {
                String date = proPredictDetailEntity.getPickupdate().substring(0, 10);
                proPredictDetailEntity.setPickupdate(date.replace("-", ""));
            }
            proPredictDetailEntity.setInitialShipments(proPredictDetailEntity.getShipments());
            proPredictDetailEntity.setSumdatetime(nowDate);
        }
    }

    private void changeProPredictSumEntityy(List<ProPredictSumEntity> proPredictSumEntitys, String nowDate) {
        for (ProPredictSumEntity proPredictSumEntity : proPredictSumEntitys) {
            if (proPredictSumEntity.getFreshness() == null || proPredictSumEntity.getFreshness().equals(0)) continue;
            proPredictSumEntity.setSumdatetime(nowDate);
            proPredictSumEntity.setSumstatus(Integer.valueOf(1));
            proPredictSumEntity.setGuid(proPredictSumEntity.getHashCode() + "");
        }
    }

    private List<String> getPredictSumIds(List<ProPredictSumEntity> proPredictSums) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ProPredictSumEntity proPredictSum : proPredictSums) {
            ids.add(proPredictSum.getGuid());
        }
        return ids;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo predictMatSum() {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        String nowDate = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("beforDays", nowDate);
        map.put("proIsTrue", false);
        try {
            List list = this.proPredictDetailMapper.findList(map);
            Set checkFreshness = this.checkFreshness(list);
            if (checkFreshness.size() > 0) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage(JSONObject.toJSONString((Object)checkFreshness));
                return baseJsonVo;
            }
            List listsum = this.proPredictDetailMapper.findSum(map);
            if (listsum != null && listsum.size() > 0) {
                this.changeProPredictSumEntityy(listsum, nowDate);
                List listIds = this.getPredictSumIds(listsum);
                HashedMap mapNew = new HashedMap();
                mapNew.put("guids", listIds);
                this.proPredictSumMapper.deleteByParam(map);
                long time1 = System.currentTimeMillis();
                new BatchAddOrUpdate(100).batch(listsum, (BatchAddOrUpdate.ToRunMethod)new /* Unavailable Anonymous Inner Class!! */);
                long time2 = System.currentTimeMillis();
                this.log.info("========\u9884\u6d4b\u8be6\u60c5\u751f\u6210\u9884\u6d4b\u6c47\u603b========" + (time2 - time1) + "\u6beb\u79d2\u5927\u5c0f==" + listsum.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    private Set<String> checkFreshness(List<ProPredictDetailEntity> list) {
        ArrayList ListUpdate = new ArrayList();
        HashSet<String> rreturnMsg = new HashSet<String>();
        if (list != null && list.size() > 0) {
            for (ProPredictDetailEntity p : list) {
                Boolean flag = true;
                StringBuffer sb = new StringBuffer();
                if (p.getFreshness() != null) continue;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)p.getCtype())) {
                    rreturnMsg.add("\u8bf7\u5728\u9500\u552e\u7ba1\u7406/\u5ba2\u6237\u6863\u6848~\u8bbe\u7f6e\u5ba2\u6237(" + p.getBctname() + ") - \u7684\u53d1\u8d27\u6a21\u5f0f");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)p.getPlanningtype())) {
                    rreturnMsg.add("\u8bf7\u5728\u57fa\u7840\u6570\u636e/\u7269\u54c1/\u4e2d\u8bbe\u7f6e~\u7269\u54c1(" + p.getMatname() + ") - \u7684\u8ba1\u5212\u5206\u7c7b");
                    continue;
                }
                if (!p.getConfigureflag().equals("\u5426")) continue;
                rreturnMsg.add("\u8bf7\u5728\u8ba1\u5212\u7ba1\u7406/\u65b0\u9c9c\u5ea6\u914d\u7f6e/\u4e2d\u8bbe\u7f6e~(" + p.getStorename() + "/" + p.getCtype() + "/" + p.getPlanningtype() + ") - \u4ed3\u5e93/\u53d1\u8d27\u6a21\u5f0f/\u7269\u54c1\u8ba1\u5212\u5206\u7c7b \u7684 \u65b0\u9c9c\u5ea6");
            }
        }
        return rreturnMsg;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdate(@RequestBody ProPredictDetailEntity mtFreshnessEntity) {
        ArrayList<ProPredictDetailEntity> List2 = new ArrayList<ProPredictDetailEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo save(@RequestBody ProPredictDetailEntity mtFreshnessEntity) {
        ArrayList<ProPredictDetailEntity> List2 = new ArrayList<ProPredictDetailEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo update(@RequestBody ProPredictDetailEntity mtFreshnessEntity) {
        ArrayList<ProPredictDetailEntity> List2 = new ArrayList<ProPredictDetailEntity>();
        List2.add(mtFreshnessEntity);
        return this.saveOrUpdateList(List2);
    }

    public BaseJsonVo<List<ProPredictDetailEntity>> findList(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        if (pageNo == null) {
            pageNo = 0;
        }
        if (pageSize == null) {
            pageSize = 0;
        }
        try {
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proPredictDetailMapper.findList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<ProPredictDetailEntity> findById(String guid) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("guid", guid);
        BaseJsonVo result = this.findList(null, null, param);
        if (result.getStatus() == 200) {
            List list = (List)result.getValue();
            if (list != null && list.size() > 0) {
                baseJsonVo.setValue(list.get(0));
            }
        } else {
            baseJsonVo.setStatus(result.getStatus());
            baseJsonVo.setMessage(result.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProPredictDetailEntity>> findByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("guids", guids);
        return this.findList(null, null, param);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo delete(@RequestBody Map<String, Object> pacam) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proPredictDetailMapper.deleteByParam(pacam);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteById(String guid) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(guid);
        return this.deleteByIds(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteByIds(@RequestBody List<String> guids) {
        HashMap<String, List<String>> pacam = new HashMap<String, List<String>>();
        pacam.put("guids", guids);
        return this.delete(pacam);
    }

    public BaseJsonVo details(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            List list;
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            if ((list = this.proPredictDetailMapper.findList(param)) != null) {
                Date date = new Date();
                String today = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
                for (ProPredictDetailEntity proPredictDetail : list) {
                    proPredictDetail.setToday(today);
                }
            }
            baseJsonVo.setValue((Object)list);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo sum(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proPredictDetailMapper.findSum(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo sumDetails(Integer pageNo, Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proPredictDetailMapper.findListdetail(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdateDatas(List<ProPredictDetailEntity> proPredictDetails, BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProPredictDetailEntity> listAdd = new ArrayList<ProPredictDetailEntity>();
            ArrayList<ProPredictDetailEntity> listUpdate = new ArrayList<ProPredictDetailEntity>();
            if (null != proPredictDetails && proPredictDetails.size() > 0) {
                for (ProPredictDetailEntity proPredictDetail : proPredictDetails) {
                    if (StringUtils.isNotBlank((String)proPredictDetail.getGuid())) {
                        listUpdate.add(proPredictDetail);
                        continue;
                    }
                    proPredictDetail.setGuid(IDGenerate.getUniqueIdStr());
                    listAdd.add(proPredictDetail);
                }
            }
            ArrayList listAddNew = new ArrayList();
            Boolean flag = false;
            StringBuffer b = new StringBuffer();
            if (listAdd.size() > 0) {
                this.proPredictDetailMapper.addRecordsBatch(listAddNew);
            }
            ArrayList<ProPredictDetailEntity> listUpdateNew = new ArrayList<ProPredictDetailEntity>();
            if (listUpdate.size() > 0) {
                for (ProPredictDetailEntity ProPredictDetail : listUpdate) {
                    BaseJsonVo baseJson = this.omsServiceClient.updateByProPredict(ProPredictDetail.getPickupdate(), ProPredictDetail.getStoreid(), ProPredictDetail.getBctid(), ProPredictDetail.getMatid(), ProPredictDetail.getShipments(), "\u7531\u9884\u6d4b\u9700\u6c42\u660e\u7ec6\u8fdb\u884c\u6570\u91cf\u66f4\u6539(\u66f4\u6539\u4eba:" + user.getEmployeeName() + ")");
                    if (baseJson.getStatus() == 200) {
                        listUpdateNew.add(ProPredictDetail);
                        continue;
                    }
                    flag = true;
                    b.append(baseJson.getMessage() + "\n<br>");
                }
                if (flag.booleanValue()) {
                    baseJsonVo.setStatus(500);
                    baseJsonVo.setMessage(b.toString());
                }
                this.proPredictDetailMapper.updateBatch(listUpdateNew);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    static /* synthetic */ ProPredictSumMapper access$000(ProPredictMatServiceImpl x0) {
        return x0.proPredictSumMapper;
    }
}

