/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.util;

import cc.lechun.pro.util.JsonUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtils {
    private static JsonUtils instance;
    private static final ObjectMapper MAPPER;
    private CharacterIterator it;
    private char c;
    private int col;
    private static final IntegerConverter integerConverter;
    private static final BigDecimalConverter bigDecimalConverter;
    private static final DoubleConverter doubleConverter;
    private static final FloatConverter floatConverter;
    private static final LongConverter longConverter;
    private static final BooleanConverter booleanConverter;
    private static final DateConverter dateConverter;

    public static JsonUtils getInstance() {
        if (instance == null) {
            instance = new JsonUtils();
        }
        return instance;
    }

    public static String objectToJson(Object data) {
        try {
            String string = MAPPER.writeValueAsString(data);
            return string;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T jsonToPojo(String jsonData, Class<T> beanType) {
        try {
            Object t = MAPPER.readValue(jsonData, beanType);
            return (T)t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> jsonToList(String jsonData, Class<T> beanType) {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{beanType});
        try {
            List list = (List)MAPPER.readValue(jsonData, javaType);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean validate(String input) {
        input = input.trim();
        boolean ret = this.valid(input);
        return ret;
    }

    private boolean valid(String input) {
        if ("".equals(input)) {
            return false;
        }
        boolean ret = true;
        this.it = new StringCharacterIterator(input);
        this.c = this.it.first();
        this.col = 1;
        if (!this.value()) {
            ret = this.error("value", 1);
        } else {
            this.skipWhiteSpace();
            if (this.c != '\uffff') {
                ret = this.error("end", this.col);
            }
        }
        return ret;
    }

    private boolean value() {
        return this.literal("true") || this.literal("false") || this.literal("null") || this.string() || this.number() || this.object() || this.array();
    }

    private boolean literal(String text) {
        StringCharacterIterator ci = new StringCharacterIterator(text);
        char t = ci.first();
        if (this.c != t) {
            return false;
        }
        int start = this.col;
        boolean ret = true;
        t = ci.next();
        while (t != '\uffff') {
            if (t != this.nextCharacter()) {
                ret = false;
                break;
            }
            t = ci.next();
        }
        this.nextCharacter();
        if (!ret) {
            this.error("literal " + text, start);
        }
        return ret;
    }

    private boolean array() {
        return this.aggregate('[', ']', false);
    }

    private boolean object() {
        return this.aggregate('{', '}', true);
    }

    private boolean aggregate(char entryCharacter, char exitCharacter, boolean prefix) {
        if (this.c != entryCharacter) {
            return false;
        }
        this.nextCharacter();
        this.skipWhiteSpace();
        if (this.c == exitCharacter) {
            this.nextCharacter();
            return true;
        }
        while (true) {
            if (prefix) {
                int start = this.col;
                if (!this.string()) {
                    return this.error("string", start);
                }
                this.skipWhiteSpace();
                if (this.c != ':') {
                    return this.error("colon", this.col);
                }
                this.nextCharacter();
                this.skipWhiteSpace();
            }
            if (this.value()) {
                this.skipWhiteSpace();
                if (this.c != ',') {
                    if (this.c == exitCharacter) break;
                    return this.error("comma or " + exitCharacter, this.col);
                }
            } else {
                return this.error("value", this.col);
            }
            this.nextCharacter();
            this.skipWhiteSpace();
        }
        this.nextCharacter();
        return true;
    }

    private boolean number() {
        if (!Character.isDigit(this.c) && this.c != '-') {
            return false;
        }
        int start = this.col;
        if (this.c == '-') {
            this.nextCharacter();
        }
        if (this.c == '0') {
            this.nextCharacter();
        } else if (Character.isDigit(this.c)) {
            while (Character.isDigit(this.c)) {
                this.nextCharacter();
            }
        } else {
            return this.error("number", start);
        }
        if (this.c == '.') {
            this.nextCharacter();
            if (Character.isDigit(this.c)) {
                while (Character.isDigit(this.c)) {
                    this.nextCharacter();
                }
            } else {
                return this.error("number", start);
            }
        }
        if (this.c == 'e' || this.c == 'E') {
            this.nextCharacter();
            if (this.c == '+' || this.c == '-') {
                this.nextCharacter();
            }
            if (Character.isDigit(this.c)) {
                while (Character.isDigit(this.c)) {
                    this.nextCharacter();
                }
            } else {
                return this.error("number", start);
            }
        }
        return true;
    }

    private boolean string() {
        if (this.c != '\"') {
            return false;
        }
        int start = this.col;
        boolean escaped = false;
        this.nextCharacter();
        while (this.c != '\uffff') {
            if (!escaped && this.c == '\\') {
                escaped = true;
            } else if (escaped) {
                if (!this.escape()) {
                    return false;
                }
                escaped = false;
            } else if (this.c == '\"') {
                this.nextCharacter();
                return true;
            }
            this.nextCharacter();
        }
        return this.error("quoted string", start);
    }

    private boolean escape() {
        int start = this.col - 1;
        if (" \\\"/bfnrtu".indexOf(this.c) < 0) {
            return this.error("escape sequence  \\\",\\\\,\\/,\\b,\\f,\\n,\\r,\\t  or  \\uxxxx ", start);
        }
        if (!(this.c != 'u' || this.ishex(this.nextCharacter()) && this.ishex(this.nextCharacter()) && this.ishex(this.nextCharacter()) && this.ishex(this.nextCharacter()))) {
            return this.error("unicode escape sequence  \\uxxxx ", start);
        }
        return true;
    }

    private boolean ishex(char d) {
        return "0123456789abcdefABCDEF".indexOf(this.c) >= 0;
    }

    private char nextCharacter() {
        this.c = this.it.next();
        ++this.col;
        return this.c;
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.c)) {
            this.nextCharacter();
        }
    }

    private boolean error(String type, int col) {
        System.out.printf("type: %s, col: %s%s", type, col, System.getProperty("line.separator"));
        return false;
    }

    public static Object stringToInstance(Object obj, String value) {
        if (obj instanceof Integer) {
            return integerConverter.convert(Integer.class, (Object)value);
        }
        if (obj instanceof String) {
            return value;
        }
        if (obj instanceof BigDecimal) {
            return bigDecimalConverter.convert(BigDecimal.class, (Object)value);
        }
        if (obj instanceof Double) {
            return doubleConverter.convert(Double.class, (Object)value);
        }
        if (obj instanceof Float) {
            return floatConverter.convert(Float.class, (Object)value);
        }
        if (obj instanceof Long) {
            return longConverter.convert(Long.class, (Object)value);
        }
        if (obj instanceof Boolean) {
            return booleanConverter.convert(Boolean.class, (Object)value);
        }
        if (obj instanceof Date) {
            return dateConverter.convert(Date.class, (Object)value);
        }
        return value;
    }

    public static void analysisJson(Object objJson, String keys) {
        block5: {
            block4: {
                if (!(objJson instanceof JSONArray)) break block4;
                JSONArray objArray = (JSONArray)objJson;
                for (int i = 0; i < objArray.size(); ++i) {
                    JsonUtils.analysisJson((Object)objArray.get(i), (String)keys);
                }
                break block5;
            }
            if (!(objJson instanceof JSONObject)) break block5;
            JSONObject jsonObject = (JSONObject)objJson;
            Iterator it = jsonObject.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                Object object = jsonObject.get((Object)key);
                if (object instanceof JSONArray) {
                    JSONArray objArray = (JSONArray)object;
                    JsonUtils.analysisJson((Object)objArray, (String)(keys + "." + key));
                    continue;
                }
                if (object instanceof JSONObject) {
                    JsonUtils.analysisJson((Object)((JSONObject)object), (String)(keys + "." + key));
                    continue;
                }
                jsonObject.put(key, (Object)"111");
                String newkey = keys + "." + key;
                System.out.println("[" + newkey.substring(1) + "]:" + object.toString() + " ");
            }
        }
    }

    public String analysisJson(Object convertObj, String keys, Consumer<AnalysisJsonObject> action) {
        if (convertObj instanceof JSONArray) {
            JSONArray objArray = (JSONArray)convertObj;
            if (objArray.size() > 0 && !(objArray.get(0) instanceof JSONArray) && !(objArray.get(0) instanceof JSONObject)) {
                action.accept(new AnalysisJsonObject(this, "", keys, (Object)objArray, (Object)objArray));
            } else {
                for (int i = 0; i < objArray.size(); ++i) {
                    this.analysisJson(objArray.get(i), keys + ".", action);
                }
            }
            return objArray.toString();
        }
        if (convertObj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)convertObj;
            Iterator it = jsonObject.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                Object object = jsonObject.get((Object)key);
                if (object instanceof JSONArray) {
                    JSONArray objArray = (JSONArray)object;
                    this.analysisJson((Object)objArray, keys + "." + key, action);
                    continue;
                }
                if (object instanceof JSONObject) {
                    this.analysisJson((Object)((JSONObject)object), keys + "." + key, action);
                    continue;
                }
                action.accept(new AnalysisJsonObject(this, key, keys, object, (Object)jsonObject));
            }
            return jsonObject.toString();
        }
        return convertObj.toString();
    }

    static {
        MAPPER = new ObjectMapper();
        integerConverter = new IntegerConverter();
        bigDecimalConverter = new BigDecimalConverter();
        doubleConverter = new DoubleConverter();
        floatConverter = new FloatConverter();
        longConverter = new LongConverter();
        booleanConverter = new BooleanConverter();
        dateConverter = new DateConverter();
    }
}

