package cc.lechun.qimen.wms.api.wms;

import cc.lechun.framework.common.vo.BaseJsonVo;
import com.qimen.api.request.*;
import com.qimen.api.response.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 阿里奇门公共接口应用
 */
public interface QimenSendWmsApi {
    /**
     * 基础档案 (基础档案)===============================================================================
     */
    /**
     * 店铺**************************************************************
     * 店铺同步接口 - taobao.qimen.shop.synchronize 店铺同步接口
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/shop/synchronize", method = RequestMethod.POST)
    BaseJsonVo<ShopSynchronizeResponse> shopSynchronize(@RequestHeader("id") String userId, @RequestBody ShopSynchronizeRequest req) ;

    /**
     * 仓库**************************************************************
     * 仓库查询接口 - taobao.qimen.warehouseinfo.query 货主仓库资源查询接口
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/warehouseinfo/query", method = RequestMethod.POST)
    BaseJsonVo<WarehouseinfoQueryResponse> warehouseinfoQuery(@RequestHeader("id") String userId, @RequestBody WarehouseinfoQueryRequest req);

    /**
     * 仓库同步接口 - taobao.qimen.warehouseinfo.synchronize 仓库同步接口
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/warehouseinfo/synchronize", method = RequestMethod.POST)
    BaseJsonVo<WarehouseinfoSynchronizeResponse> warehouseinfoSynchronize(@RequestHeader("id") String userId, @RequestBody WarehouseinfoSynchronizeRequest req);


    /**
     * 商品 **************************************************************
     * 商品查询接口 - taobao.qimen.singleitem.query 商品查询接口
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/singleitem/query", method = RequestMethod.POST)
    BaseJsonVo<SingleitemQueryResponse> singleitemQuery(@RequestHeader("id") String userId, @RequestBody SingleitemQueryRequest req);

    /**
     * 商品同步接口 - taobao.qimen.singleitem.synchronize 商品同步接口
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/singleitem/synchronize", method = RequestMethod.POST)
    BaseJsonVo<SingleitemSynchronizeResponse> singleitemSynchronize(@RequestHeader("id") String userId, @RequestBody SingleitemSynchronizeRequest req);


    /**
     * 商品批量同步接口 - taobao.qimen.items.synchronize 商品同步接口 (批量)
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/items/synchronize", method = RequestMethod.POST)
    BaseJsonVo<ItemsSynchronizeResponse> itemsSynchronize(@RequestHeader("id") String userId, @RequestBody ItemsSynchronizeRequest req);

    /**
     * 组合商品批量同步接口 - taobao.qimen.combineitem.synchronize ( 组合商品接口 )
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/combineitem/synchronize", method = RequestMethod.POST)
    BaseJsonVo<CombineitemSynchronizeResponse> combineitemSynchronize(@RequestHeader("id") String userId, @RequestBody CombineitemSynchronizeRequest req);


    /**
     * 供应商**************************************************************
     * 供应商同步接口 - taobao.qimen.supplier.synchronize
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/supplier/synchronize", method = RequestMethod.POST)
    BaseJsonVo<SupplierSynchronizeResponse> supplierSynchronize(@RequestHeader("id") String userId, @RequestBody SupplierSynchronizeRequest req);
    /**
     * 库存单据  (库存管理)===============================================================================
     */


    /**
     * 入库单**************************************************************
     * 入库单创建接口 - taobao.qimen.entryorder.create
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/entryorder/create", method = RequestMethod.POST)
    BaseJsonVo<EntryorderCreateResponse> entryorderrCreate(@RequestHeader("id") String userId, @RequestBody EntryorderCreateRequest req);

    /**
     * 入库单查询接口 - taobao.qimen.entryorder.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/entryorder/query", method = RequestMethod.POST)
    BaseJsonVo<EntryorderQueryResponse> entryorderQuery(@RequestHeader("id") String userId, @RequestBody EntryorderQueryRequest req);


    /**
     * 出库单**************************************************************
     * 出库单创建接口 - taobao.qimen.stockout.create
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/stockout/create", method = RequestMethod.POST)
    BaseJsonVo<StockoutCreateResponse> stockoutCreate(@RequestHeader("id") String userId, @RequestBody StockoutCreateRequest req);

    /**
     * 出库单查询接口 - taobao.qimen.stockout.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/stockout/query", method = RequestMethod.POST)
    BaseJsonVo<StockoutQueryResponse> stockoutQuery(@RequestHeader("id") String userId, @RequestBody StockoutQueryRequest req);


    /**
     * 调拨单**************************************************************
     * 调拨单创建 - taobao.qimen.transferorder.create
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/transferorder/create", method = RequestMethod.POST)
    BaseJsonVo<TransferorderCreateResponse> transferorderCreate(@RequestHeader("id") String userId, @RequestBody TransferorderCreateRequest req);


    /**
     * 调拨单查询 - taobao.qimen.transferorder.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/transferorder/query", method = RequestMethod.POST)
    BaseJsonVo<TransferorderQueryResponse> transferorderQuery(@RequestHeader("id") String userId, @RequestBody TransferorderQueryRequest req);


    /**
     * 加工单**************************************************************
     * 仓内加工单创建接口 - taobao.qimen.storeprocess.create
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/storeprocess/create", method = RequestMethod.POST)
    BaseJsonVo<StoreprocessCreateResponse> storeprocessCreate(@RequestHeader("id") String userId, @RequestBody StoreprocessCreateRequest req);


    /**
     * 库存量**************************************************************
     * 库存查询接口（多商品） - taobao.qimen.inventory.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/inventory/query", method = RequestMethod.POST)
    public BaseJsonVo<InventoryQueryResponse> inventoryQuery(@RequestHeader("id") String userId, @RequestBody InventoryQueryRequest req);

    /**
     * 库存查询接口（多条件）- taobao.qimen.stock.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/stock/query", method = RequestMethod.POST)
    public BaseJsonVo<StockQueryResponse> stockQuery(@RequestHeader("id") String userId, @RequestBody StockQueryRequest req);

    /**
     * 库存盘点查询接口 - taobao.qimen.inventorycheck.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/inventorycheck/query", method = RequestMethod.POST)
    public BaseJsonVo<InventorycheckQueryResponse> inventorycheckQuery(@RequestHeader("id") String userId, @RequestBody InventorycheckQueryRequest req);
    /**
     * taobao.qimen.inventorysum.query  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 次接口无
     */
    /**
     * 渠道间库存规则设置接口 - taobao.qimen.inventoryrule.create
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/inventoryrule/create", method = RequestMethod.POST)
    BaseJsonVo<InventoryruleCreateResponse> inventoryreserveCreate(@RequestHeader("id") String userId, @RequestBody InventoryruleCreateRequest req);

    /**
     * 订单出库统计查询 - taobao.qimen.deliveryordersum.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/deliveryordersum/query", method = RequestMethod.POST)
    BaseJsonVo<DeliveryordersumQueryResponse> deliveryordersumQuery(@RequestHeader("id") String userId, @RequestBody DeliveryordersumQueryRequest req);
    /**
     * 销售发货单据 (销售发货/退货)===============================================================================
     */


    /**
     * 退货单**************************************************************
     * 退货入库单创建接口 - taobao.qimen.returnorder.create
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/returnorder/create", method = RequestMethod.POST)
    BaseJsonVo<ReturnorderCreateResponse> returnorderCreate(@RequestHeader("id") String userId, @RequestBody ReturnorderCreateRequest req);

    /**
     * 退货入库单查询接口 - taobao.qimen.returnorder.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/returnorder/query", method = RequestMethod.POST)
    public BaseJsonVo<ReturnorderQueryResponse> returnorderQuery(@RequestHeader("id") String userId, @RequestBody ReturnorderQueryRequest req);


    /**
     * 发货单**************************************************************
     * 发货单创建接口 - taobao.qimen.deliveryorder.create
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/deliveryorder/create", method = RequestMethod.POST)
    public BaseJsonVo<DeliveryorderCreateResponse> deliveryorderCreate(@RequestHeader("id") String userId, @RequestBody DeliveryorderCreateRequest req);

    /**
     * 发货单创建批量接口 - taobao.qimen.deliveryorder.batchcreate
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/deliveryorder/batchcreate", method = RequestMethod.POST)
    public BaseJsonVo<DeliveryorderBatchcreateResponse> deliveryorderBatchcreate(@RequestHeader("id") String userId, @RequestBody DeliveryorderBatchcreateRequest req);

    /**
     * 发货单查询接口 -taobao.qimen.deliveryorder.query
     *
     * @param userId
     * @param req
     * @return
     */
    // @RequestMapping(value = "/sendWms/deliveryorder/query", method = RequestMethod.POST)
    BaseJsonVo<DeliveryorderQueryResponse> deliveryorderQuery(@RequestHeader("id") String userId, @RequestBody DeliveryorderQueryRequest req);

    /**
     * 订单流水查询接口 - taobao.qimen.orderprocess.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/orderprocess/query", method = RequestMethod.POST)
    public BaseJsonVo<OrderprocessQueryResponse> orderprocessQuery(@RequestHeader("id") String userId, @RequestBody OrderprocessQueryRequest req);

    /**
     * 订单状态查询接口(批量) - taobao.qimen.orderstatus.batchquery
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/orderstatus/batchquery", method = RequestMethod.POST)
    BaseJsonVo<OrderstatusBatchqueryResponse> orderstatusBatchquery(@RequestHeader("id") String userId, @RequestBody OrderstatusBatchqueryRequest req);

    /**
     * 发货单缺货查询接口 - taobao.qimen.itemlack.query
     *
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/itemlack/query", method = RequestMethod.POST)
    BaseJsonVo<ItemlackQueryResponse> itemlackQuery(@RequestHeader("id") String userId, @RequestBody ItemlackQueryRequest req);
    /**
     * 单据取消 (公共接口)===============================================================================
     */
    /****************************************************************
     * 单据取消接口 - taobao.qimen.order.cancel
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/order/cancel", method = RequestMethod.POST)
    public BaseJsonVo<OrderCancelResponse> orderCancel(@RequestHeader("id") String userId, @RequestBody OrderCancelRequest req);
    /****************************************************************
     * 单据挂起（恢复）接口 - taobao.qimen.order.pending
     * @param userId
     * @param req
     * @return
     */
    @RequestMapping(value = "/sendWms/order/pending", method = RequestMethod.POST)
    public BaseJsonVo<OrderPendingResponse > orderPending(@RequestHeader("id") String userId, @RequestBody OrderPendingRequest  req);
}
