/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.order.TradeManagementResult;
import weixin.popular.bean.shipping.DeliveryComResult;
import weixin.popular.bean.shipping.ShipOrder;
import weixin.popular.bean.shipping.ShipOrderListResult;
import weixin.popular.bean.shipping.ShipOrderQuery;
import weixin.popular.bean.shipping.ShipOrderResult;
import weixin.popular.bean.shipping.WxDeliverGoods;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;

public class ShippingAPI
extends BaseAPI {
    public static DeliveryComResult get_delivery_list(String access_token) {
        String json = "{}";
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/get_delivery_list").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json.toString(), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, DeliveryComResult.class);
    }

    public static BaseResult shippings(String access_token, ShipOrder shipOrder) {
        String data = JsonUtil.toJSONString(shipOrder);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/user-order/orders/shippings").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(data.toString(), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult uploadShippingInfo(String access_token, WxDeliverGoods wxDeliverGoods) {
        String data = JsonUtil.toJSONString(wxDeliverGoods);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/wxa/sec/order/upload_shipping_info").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(data.toString(), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult getTradeManaged(String access_token, String appId) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/wxa/sec/order/is_trade_managed").addParameter("access_token", API.accessToken(access_token)).addParameter("appid", appId).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static TradeManagementResult getTradeManagementConfirmationCompleted(String access_token, String appId) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/wxa/sec/order/is_trade_managed").addParameter("access_token", API.accessToken(access_token)).addParameter("appid", appId).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, TradeManagementResult.class);
    }

    public static ShipOrderResult get_order(String access_token, String merchant_id, String merchant_trade_no) {
        String json = "{\"merchant_id\":\"" + merchant_id + "\",\"merchant_trade_no\":\"" + merchant_trade_no + "\"}";
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/wxa/sec/order/get_order").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ShipOrderResult.class);
    }

    public static ShipOrderListResult get_order_list(String access_token, ShipOrderQuery shipOrderQuery) {
        String data = JsonUtil.toJSONString(shipOrderQuery);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/wxa/sec/order/get_order_list").addParameter("access_token", API.accessToken(access_token)).setEntity((HttpEntity)new StringEntity(data.toString(), Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ShipOrderListResult.class);
    }
}

