/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.api.TicketAPI;
import weixin.popular.bean.ticket.Ticket;
import weixin.popular.support.TokenManager;

public class TicketManager {
    private static final Logger logger = LoggerFactory.getLogger(TicketManager.class);
    private static ScheduledExecutorService scheduledExecutorService;
    private static Map<String, String> ticketMap;
    private static Map<String, ScheduledFuture<?>> futureMap;
    private static int poolSize;
    private static boolean daemon;
    private static final String KEY_JOIN = "__";

    private static void initScheduledExecutorService() {
        logger.info("daemon:{},poolSize:{}", (Object)daemon, (Object)poolSize);
        scheduledExecutorService = Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread thread = Executors.defaultThreadFactory().newThread(arg0);
                thread.setDaemon(daemon);
                return thread;
            }
        });
    }

    public static void setPoolSize(int poolSize) {
        TicketManager.poolSize = poolSize;
    }

    public static void setDaemon(boolean daemon) {
        TicketManager.daemon = daemon;
    }

    public static void init(String appid) {
        TicketManager.init(appid, 0, 7140);
    }

    public static void init(String appid, String types) {
        TicketManager.init(appid, 0, 7140, types);
    }

    public static void init(String appid, int initialDelay, int delay) {
        TicketManager.init(appid, initialDelay, delay, "jsapi");
    }

    public static void init(final String appid, int initialDelay, int delay, String ... types) {
        for (final String type : types) {
            final String key = appid + KEY_JOIN + type;
            if (scheduledExecutorService == null) {
                TicketManager.initScheduledExecutorService();
            }
            if (futureMap.containsKey(key)) {
                futureMap.get(key).cancel(true);
            }
            if (initialDelay == 0) {
                TicketManager.doRun(appid, type, key);
            }
            ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TicketManager.doRun(appid, type, key);
                }
            }, initialDelay == 0 ? (long)delay : (long)initialDelay, delay, TimeUnit.SECONDS);
            futureMap.put(key, scheduledFuture);
        }
    }

    private static void doRun(String appid, String type, String key) {
        try {
            String access_token = TokenManager.getToken(appid);
            Ticket ticket = TicketAPI.ticketGetticket(access_token, type);
            ticketMap.put(key, ticket.getTicket());
            logger.info("TICKET refurbish with appid:{} type:{}", (Object)appid, (Object)type);
        }
        catch (Exception e) {
            logger.error("TICKET refurbish error with appid:{} type:{}", (Object)appid, (Object)type);
            e.printStackTrace();
        }
    }

    public static void destroyed() {
        scheduledExecutorService.shutdownNow();
        logger.info("destroyed");
    }

    public static void destroyed(String appid) {
        TicketManager.destroyed(appid, "jsapi", "wx_card");
    }

    public static void destroyed(String appid, String ... types) {
        for (String type : types) {
            String key = appid + KEY_JOIN + type;
            if (!futureMap.containsKey(key)) continue;
            futureMap.get(key).cancel(true);
            logger.info("destroyed appid:{} type:{}", (Object)appid, (Object)type);
        }
    }

    public static String getTicket(String appid) {
        return TicketManager.getTicket(appid, "jsapi");
    }

    public static String getTicket(String appid, String type) {
        return ticketMap.get(appid + KEY_JOIN + type);
    }

    public static String getDefaultTicket() {
        Object[] objs = ticketMap.values().toArray();
        return objs.length > 0 ? objs[0].toString() : null;
    }

    static {
        ticketMap = new LinkedHashMap<String, String>();
        futureMap = new HashMap();
        poolSize = 2;
        daemon = Boolean.TRUE;
    }
}

