/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLConverUtil {
    private static final ThreadLocal<Map<Class<?>, Marshaller>> mMapLocal = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<Class<?>, Unmarshaller>> uMapLocal = ThreadLocal.withInitial(HashMap::new);

    public static <T> T convertToObject(Class<T> clazz, String xml) {
        return XMLConverUtil.convertToObject(clazz, new StringReader(xml));
    }

    public static <T> T convertToObject(Class<T> clazz, InputStream inputStream) {
        return XMLConverUtil.convertToObject(clazz, new InputStreamReader(inputStream));
    }

    public static <T> T convertToObject(Class<T> clazz, InputStream inputStream, Charset charset) {
        return XMLConverUtil.convertToObject(clazz, new InputStreamReader(inputStream, charset));
    }

    public static <T> T convertToObject(Class<T> clazz, Reader reader) {
        try {
            Map<Class<?>, Unmarshaller> uMap = uMapLocal.get();
            Unmarshaller unmarshaller = uMap.computeIfAbsent(clazz, c -> {
                try {
                    return JAXBContext.newInstance((Class[])new Class[]{c}).createUnmarshaller();
                }
                catch (JAXBException e) {
                    throw new RuntimeException(e);
                }
            });
            return (T)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertToXML(Object object) {
        try {
            Map<Class<?>, Marshaller> mMap = mMapLocal.get();
            Marshaller marshaller = mMap.computeIfAbsent(object.getClass(), c -> {
                try {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{c});
                    Marshaller m = jaxbContext.createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)true);
                    return m;
                }
                catch (JAXBException e) {
                    throw new RuntimeException(e);
                }
            });
            final StringWriter stringWriter = new StringWriter();
            Writer cdataWriter = new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    String data = new String(cbuf, off, len);
                    stringWriter.write(data);
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
            marshaller.marshal(object, cdataWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, String> convertToMap(String xml) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new InputSource(new StringReader(xml)));
            Element root = document.getDocumentElement();
            if (root != null) {
                NodeList childNodes = root.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (node == null || node.getNodeType() != 1) continue;
                    map.put(node.getNodeName(), node.getTextContent());
                }
            }
        }
        catch (IOException | ParserConfigurationException | DOMException | SAXException e) {
            e.printStackTrace();
        }
        return map;
    }
}

