/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.customer.starter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.customer.api.expander.CustomerConfigExpander;
import cn.stylefeng.roses.kernel.customer.api.pojo.CustomerInfo;
import cn.stylefeng.roses.kernel.customer.modular.cache.CustomerMemoryCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class ProjectCustomerMemoryAutoConfiguration {
    @Bean
    public CacheOperatorApi<CustomerInfo> customerInfoCacheOperatorApi() {
        TimedCache customerInfoTimedCache = CacheUtil.newTimedCache((long)(CustomerConfigExpander.getCustomerCacheExpiredSeconds() * 1000L));
        return new CustomerMemoryCache(customerInfoTimedCache);
    }
}

