/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logger.slf4j;

import com.alibaba.nacos.client.logger.Logger;
import com.alibaba.nacos.client.logger.nop.NopLogger;
import com.alibaba.nacos.client.logger.slf4j.Slf4jLogger;
import com.alibaba.nacos.client.logger.support.ILoggerFactory;
import com.alibaba.nacos.client.logger.support.LogLog;
import org.slf4j.LoggerFactory;

public class Slf4jLoggerFactory
implements ILoggerFactory {
    public Slf4jLoggerFactory() throws ClassNotFoundException {
        Class.forName("org.slf4j.impl.StaticLoggerBinder");
    }

    @Override
    public Logger getLogger(String name) {
        try {
            return new Slf4jLogger(LoggerFactory.getLogger((String)name));
        }
        catch (Throwable t) {
            LogLog.error("Failed to get Slf4jLogger", t);
            return new NopLogger();
        }
    }

    @Override
    public Logger getLogger(Class<?> clazz) {
        try {
            return new Slf4jLogger(LoggerFactory.getLogger(clazz));
        }
        catch (Throwable t) {
            LogLog.error("Failed to get Slf4jLogger", t);
            return new NopLogger();
        }
    }
}

