/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.http.CompatibleUrlConnClient;
import com.aliyun.credentials.http.HttpRequest;
import com.aliyun.credentials.http.HttpResponse;
import com.aliyun.credentials.http.MethodType;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.credentials.utils.ParameterHelper;
import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class ECSMetadataServiceCredentialsFetcher {
    private static final String URL_IN_ECS_METADATA = "/latest/meta-data/ram/security-credentials/";
    private static final String URL_IN_METADATA_TOKEN = "/latest/api/token";
    private static final String ECS_METADAT_FETCH_ERROR_MSG = "Failed to get RAM session credentials from ECS metadata service.";
    private URL credentialUrl;
    private final String roleName;
    private final String metadataServiceHost = "100.100.100.200";
    private int connectionTimeout = 1000;
    private int readTimeout = 1000;
    private final boolean disableIMDSv1;
    private final int metadataTokenDuration = 21600;

    public ECSMetadataServiceCredentialsFetcher(String roleName, int connectionTimeout, int readTimeout) {
        if (connectionTimeout > 1000) {
            this.connectionTimeout = connectionTimeout;
        }
        if (readTimeout > 1000) {
            this.readTimeout = readTimeout;
        }
        this.disableIMDSv1 = false;
        this.roleName = roleName;
        this.setCredentialUrl();
    }

    @Deprecated
    public ECSMetadataServiceCredentialsFetcher(String roleName, boolean disableIMDSv1, int metadataTokenDuration, int connectionTimeout, int readTimeout) {
        if (connectionTimeout > 1000) {
            this.connectionTimeout = connectionTimeout;
        }
        if (readTimeout > 1000) {
            this.readTimeout = readTimeout;
        }
        this.disableIMDSv1 = disableIMDSv1;
        this.roleName = roleName;
        this.setCredentialUrl();
    }

    public ECSMetadataServiceCredentialsFetcher(String roleName, boolean disableIMDSv1, int connectionTimeout, int readTimeout) {
        if (connectionTimeout > 1000) {
            this.connectionTimeout = connectionTimeout;
        }
        if (readTimeout > 1000) {
            this.readTimeout = readTimeout;
        }
        this.disableIMDSv1 = disableIMDSv1;
        this.roleName = roleName;
        this.setCredentialUrl();
    }

    public ECSMetadataServiceCredentialsFetcher(String roleName) {
        this.roleName = roleName;
        this.disableIMDSv1 = false;
        this.setCredentialUrl();
    }

    private void setCredentialUrl() {
        try {
            this.credentialUrl = new URL("http://100.100.100.200/latest/meta-data/ram/security-credentials/" + this.roleName);
        }
        catch (MalformedURLException e) {
            throw new CredentialException(e.getMessage(), e);
        }
    }

    public String fetchRoleName(CompatibleUrlConnClient client) {
        return this.getMetadata(client);
    }

    public String getMetadata(CompatibleUrlConnClient client) {
        HttpResponse response;
        HttpRequest request = new HttpRequest(this.credentialUrl.toString());
        request.setSysMethod(MethodType.GET);
        request.setSysConnectTimeout(this.connectionTimeout);
        request.setSysReadTimeout(this.readTimeout);
        String metadataToken = this.getMetadataToken(client);
        if (metadataToken != null) {
            request.putHeaderParameter("X-aliyun-ecs-metadata-token", metadataToken);
        }
        try {
            response = client.syncInvoke(request);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect ECS Metadata Service: " + e);
        }
        finally {
            client.close();
        }
        if (response.getResponseCode() == 404) {
            throw new CredentialException("The role name was not found in the instance.");
        }
        if (response.getResponseCode() != 200) {
            throw new CredentialException("Failed to get RAM session credentials from ECS metadata service. HttpCode=" + response.getResponseCode());
        }
        return new String(response.getHttpContent());
    }

    public RefreshResult<CredentialModel> fetch(CompatibleUrlConnClient client) {
        String jsonContent = this.getMetadata(client);
        Map result = (Map)new Gson().fromJson(jsonContent, Map.class);
        if (!"Success".equals(result.get("Code"))) {
            throw new CredentialException(ECS_METADAT_FETCH_ERROR_MSG);
        }
        long expiration = ParameterHelper.getUTCDate((String)result.get("Expiration")).getTime();
        CredentialModel credential = CredentialModel.builder().accessKeyId((String)result.get("AccessKeyId")).accessKeySecret((String)result.get("AccessKeySecret")).securityToken((String)result.get("SecurityToken")).type("ecs_ram_role").expiration(expiration).build();
        return RefreshResult.builder(credential).staleTime(expiration - 180000L).build();
    }

    public URL getCredentialUrl() {
        return this.credentialUrl;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean getDisableIMDSv1() {
        return this.disableIMDSv1;
    }

    public int getMetadataTokenDuration() {
        return 21600;
    }

    private String getMetadataToken(CompatibleUrlConnClient client) {
        try {
            HttpResponse response;
            HttpRequest request = new HttpRequest("http://100.100.100.200/latest/api/token");
            request.setSysMethod(MethodType.PUT);
            request.setSysConnectTimeout(this.connectionTimeout);
            request.setSysReadTimeout(this.readTimeout);
            request.putHeaderParameter("X-aliyun-ecs-metadata-token-ttl-seconds", String.valueOf(this.metadataTokenDuration));
            try {
                response = client.syncInvoke(request);
            }
            catch (Exception e) {
                throw new CredentialException("Failed to connect ECS Metadata Service: " + e);
            }
            if (response.getResponseCode() != 200) {
                throw new CredentialException("Failed to get token from ECS Metadata Service. HttpCode=" + response.getResponseCode() + ", ResponseMessage=" + response.getHttpContentString());
            }
            return new String(response.getHttpContent());
        }
        catch (Exception ex) {
            return this.throwErrorOrReturn(ex);
        }
    }

    private String throwErrorOrReturn(Exception e) {
        if (this.getDisableIMDSv1()) {
            throw new CredentialException("Failed to get token from ECS Metadata Service, and fallback to IMDS v1 is disabled via the disableIMDSv1 configuration is turned on. Original error: " + e.getMessage());
        }
        return null;
    }
}

