/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.model.action;

import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.HttpMethod;
import com.aliyun.mq.http.common.auth.ServiceCredentials;
import com.aliyun.mq.http.common.http.RequestMessage;
import com.aliyun.mq.http.common.http.ResponseMessage;
import com.aliyun.mq.http.common.http.ServiceClient;
import com.aliyun.mq.http.common.parser.ResultParseException;
import com.aliyun.mq.http.common.parser.ResultParser;
import com.aliyun.mq.http.model.Message;
import com.aliyun.mq.http.model.action.AbstractAction;
import com.aliyun.mq.http.model.request.ConsumeMessageRequest;
import com.aliyun.mq.http.model.serialize.MessageListDeserializer;
import java.net.URI;
import java.util.Iterator;
import java.util.List;

public class ConsumeMessageAction
extends AbstractAction<ConsumeMessageRequest, List<Message>> {
    public ConsumeMessageAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.GET, "ConsumeMessage", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(ConsumeMessageRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        if (reqObject.getBatchSize() < 1) {
            throw new ClientException("Consume num should greater then 0!", "LocalCheck");
        }
        String uri = reqObject.getRequestPath() + "?" + "numOfMessages" + "=" + reqObject.getBatchSize();
        if (reqObject.getConsumer() == null || reqObject.getConsumer().length() <= 0) {
            throw new ClientException("Consumer can not be empty!", "LocalCheck");
        }
        uri = uri + "&consumer=" + reqObject.getConsumer();
        if (reqObject.getInstanceId() != null && reqObject.getInstanceId() != "") {
            uri = uri + "&ns=" + reqObject.getInstanceId();
        }
        if (reqObject.getTag() != null && reqObject.getTag().length() > 0) {
            uri = uri + "&tag=" + reqObject.getTag();
        }
        if (reqObject.getWaitSeconds() > 0) {
            uri = uri + "&waitseconds=" + reqObject.getWaitSeconds();
        }
        if (reqObject.getTrans() != null && reqObject.getTrans().length() > 0) {
            uri = uri + "&trans=" + reqObject.getTrans();
        }
        requestMessage.setResourcePath(uri);
        return requestMessage;
    }

    @Override
    protected ResultParser<List<Message>> buildResultParser() {
        return new ResultParser<List<Message>>(){

            @Override
            public List<Message> parse(ResponseMessage response) throws ResultParseException {
                MessageListDeserializer deserializer = new MessageListDeserializer();
                try {
                    Object msgs = deserializer.deserialize(response.getContent());
                    Iterator iterator = msgs.iterator();
                    while (iterator.hasNext()) {
                        Message msg = (Message)iterator.next();
                        msg.setRequestId(response.getHeader("x-mq-request-id"));
                    }
                    return msgs;
                }
                catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

