/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination.dialects;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLServer2005Dialect
implements IDialect {
    private static final Pattern pattern = Pattern.compile("\\((.)*order by(.)*\\)");

    public String getOrderByPart(String sql) {
        String order_by = "order by";
        int lastIndex = sql.toLowerCase().lastIndexOf(order_by);
        if (lastIndex == -1) {
            return "";
        }
        Matcher matcher = pattern.matcher(sql);
        if (!matcher.find()) {
            return sql.substring(lastIndex);
        }
        int end = matcher.end();
        return lastIndex < end ? "" : sql.substring(lastIndex);
    }

    @Override
    public DialectModel buildPaginationSql(String originalSql, long offset, long limit) {
        StringBuilder pagingBuilder = new StringBuilder();
        String orderby = this.getOrderByPart(originalSql);
        String distinctStr = "";
        String loweredString = originalSql.toLowerCase();
        String sqlPartString = originalSql;
        if (loweredString.trim().startsWith("select")) {
            int index = 6;
            if (loweredString.startsWith("select distinct")) {
                distinctStr = "DISTINCT ";
                index = 15;
            }
            sqlPartString = sqlPartString.substring(index);
        }
        pagingBuilder.append(sqlPartString);
        if (StringUtils.isBlank((CharSequence)orderby)) {
            orderby = "ORDER BY CURRENT_TIMESTAMP";
        }
        long firstParam = offset + 1L;
        long secondParam = offset + limit;
        String sql = "WITH selectTemp AS (SELECT " + distinctStr + "TOP 100 PERCENT  ROW_NUMBER() OVER (" + orderby + ") as __row_number__, " + pagingBuilder + ") SELECT * FROM selectTemp WHERE __row_number__ BETWEEN " + firstParam + " AND " + secondParam + " ORDER BY __row_number__";
        return new DialectModel(sql);
    }
}

