/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.common.collect.Sets;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.generic.PipeStepPair;
import com.diffplug.spotless.maven.FormatterConfig;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.maven.generic.EclipseWtp;
import com.diffplug.spotless.maven.generic.EndWithNewline;
import com.diffplug.spotless.maven.generic.Indent;
import com.diffplug.spotless.maven.generic.Jsr223;
import com.diffplug.spotless.maven.generic.LicenseHeader;
import com.diffplug.spotless.maven.generic.NativeCmd;
import com.diffplug.spotless.maven.generic.Prettier;
import com.diffplug.spotless.maven.generic.Replace;
import com.diffplug.spotless.maven.generic.ReplaceRegex;
import com.diffplug.spotless.maven.generic.ToggleOffOn;
import com.diffplug.spotless.maven.generic.TrimTrailingWhitespace;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class FormatterFactory {
    @Parameter
    private String encoding;
    @Parameter
    private LineEnding lineEndings;
    private static final String RATCHETFROM_NOT_SET_AT_FORMAT_LEVEL = " not set at format level ";
    @Parameter
    private String ratchetFrom = " not set at format level ";
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    private final List<FormatterStepFactory> stepFactories = new ArrayList<FormatterStepFactory>();
    private ToggleOffOn toggle;

    public abstract Set<String> defaultIncludes();

    public abstract String licenseHeaderDelimiter();

    public final Set<String> includes() {
        return this.includes == null ? Collections.emptySet() : Sets.newHashSet((Object[])this.includes);
    }

    public final Set<String> excludes() {
        return this.excludes == null ? Collections.emptySet() : Sets.newHashSet((Object[])this.excludes);
    }

    public final Formatter newFormatter(Supplier<Iterable<File>> filesToFormat, FormatterConfig config) {
        Charset formatterEncoding = this.encoding(config);
        LineEnding formatterLineEndings = this.lineEndings(config);
        LineEnding.Policy formatterLineEndingPolicy = formatterLineEndings.createPolicy(config.getFileLocator().getBaseDir(), filesToFormat);
        FormatterStepConfig stepConfig = this.stepConfig(formatterEncoding, config);
        List<FormatterStepFactory> factories = FormatterFactory.gatherStepFactories(config.getGlobalStepFactories(), this.stepFactories);
        List formatterSteps = factories.stream().filter(Objects::nonNull).map(factory -> factory.newFormatterStep(stepConfig)).collect(Collectors.toCollection(() -> new ArrayList()));
        if (this.toggle != null) {
            PipeStepPair pair = this.toggle.createPair();
            formatterSteps.add(0, pair.in());
            formatterSteps.add(pair.out());
        }
        return Formatter.builder().encoding(formatterEncoding).lineEndingsPolicy(formatterLineEndingPolicy).exceptionPolicy((FormatExceptionPolicy)new FormatExceptionPolicyStrict()).steps(formatterSteps).rootDir(config.getFileLocator().getBaseDir().toPath()).build();
    }

    public final void addLicenseHeader(LicenseHeader licenseHeader) {
        this.addStepFactory(licenseHeader);
    }

    public final void addEndWithNewline(EndWithNewline endWithNewline) {
        this.addStepFactory(endWithNewline);
    }

    public final void addIndent(Indent indent) {
        this.addStepFactory(indent);
    }

    public final void addJsr223(Jsr223 jsr223) {
        this.addStepFactory(jsr223);
    }

    public final void addTrimTrailingWhitespace(TrimTrailingWhitespace trimTrailingWhitespace) {
        this.addStepFactory(trimTrailingWhitespace);
    }

    public final void addReplace(Replace replace) {
        this.addStepFactory(replace);
    }

    public final void addNativeCmd(NativeCmd nativeCmd) {
        this.addStepFactory(nativeCmd);
    }

    public final void addReplaceRegex(ReplaceRegex replaceRegex) {
        this.addStepFactory(replaceRegex);
    }

    public final void addEclipseWtp(EclipseWtp eclipseWtp) {
        this.addStepFactory(eclipseWtp);
    }

    public final void addPrettier(Prettier prettier) {
        this.addStepFactory(prettier);
    }

    public final void addToggleOffOn(ToggleOffOn toggle) {
        this.toggle = toggle;
    }

    protected final void addStepFactory(FormatterStepFactory stepFactory) {
        Objects.requireNonNull(stepFactory);
        this.stepFactories.add(stepFactory);
    }

    private Charset encoding(FormatterConfig config) {
        return Charset.forName(this.encoding == null ? config.getEncoding() : this.encoding);
    }

    private LineEnding lineEndings(FormatterConfig config) {
        return this.lineEndings == null ? config.getLineEndings() : this.lineEndings;
    }

    Optional<String> ratchetFrom(FormatterConfig config) {
        if (RATCHETFROM_NOT_SET_AT_FORMAT_LEVEL.equals(this.ratchetFrom)) {
            return config.getRatchetFrom();
        }
        if ("NONE".equals(this.ratchetFrom)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.ratchetFrom);
    }

    private FormatterStepConfig stepConfig(Charset encoding, FormatterConfig config) {
        return new FormatterStepConfig(encoding, this.licenseHeaderDelimiter(), this.ratchetFrom(config), config.getProvisioner(), config.getFileLocator(), config.getSpotlessSetLicenseHeaderYearsFromGitHistory());
    }

    private static List<FormatterStepFactory> gatherStepFactories(List<FormatterStepFactory> allGlobal, List<FormatterStepFactory> allConfigured) {
        ArrayList<FormatterStepFactory> result = new ArrayList<FormatterStepFactory>();
        for (FormatterStepFactory global : allGlobal) {
            if (FormatterFactory.formatterStepOverriden(global, allConfigured)) continue;
            result.add(global);
        }
        result.addAll(allConfigured);
        return result;
    }

    private static boolean formatterStepOverriden(FormatterStepFactory global, List<FormatterStepFactory> allConfigured) {
        return allConfigured.stream().anyMatch(configured -> configured.getClass() == global.getClass());
    }
}

