/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.bot.junit5;

import com.github.dreamhead.bot.ObjectBot;
import com.github.dreamhead.bot.annotation.AnyField;
import com.github.dreamhead.bot.annotation.BooleanField;
import com.github.dreamhead.bot.annotation.Bot;
import com.github.dreamhead.bot.annotation.BotInitializer;
import com.github.dreamhead.bot.annotation.BotWith;
import com.github.dreamhead.bot.annotation.ByteField;
import com.github.dreamhead.bot.annotation.CharField;
import com.github.dreamhead.bot.annotation.ClassField;
import com.github.dreamhead.bot.annotation.DoubleField;
import com.github.dreamhead.bot.annotation.FieldFactory;
import com.github.dreamhead.bot.annotation.FloatField;
import com.github.dreamhead.bot.annotation.IntField;
import com.github.dreamhead.bot.annotation.LongField;
import com.github.dreamhead.bot.annotation.ShortField;
import com.github.dreamhead.bot.annotation.StringField;
import com.github.dreamhead.bot.reflection.ReflectionSupport;
import com.github.dreamhead.bot.util.FieldEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class BotExtension
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor {
    private static final ExtensionContext.Namespace BOT = ExtensionContext.Namespace.create((Object[])new Object[]{"com.github.dreamhead.bot"});

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        Class<?> testInstanceClass = testInstance.getClass();
        ObjectBot bot = (ObjectBot)context.getStore(BOT).get(testInstanceClass, ObjectBot.class);
        List fields = ReflectionSupport.findAnnotatedFields(testInstanceClass, Bot.class);
        for (Field field : fields) {
            Bot annotation = field.getAnnotation(Bot.class);
            List<FieldEntry<Object>> pairs = this.getModifiers(field);
            Object value = bot.of(annotation.value(), field.getType(), pairs.toArray(new FieldEntry[0]));
            ReflectionSupport.setFieldValue((Object)testInstance, (Field)field, (Object)value);
        }
    }

    private List<FieldEntry<Object>> getModifiers(Field field) {
        List<FieldEntry<Object>> stringModifiers = this.getModifiers(field, StringField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> longModifiers = this.getModifiers(field, LongField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> intModifiers = this.getModifiers(field, IntField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> doubleModifiers = this.getModifiers(field, DoubleField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> floatModifiers = this.getModifiers(field, FloatField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)Float.valueOf(annotation.value())));
        List<FieldEntry<Object>> charModifiers = this.getModifiers(field, CharField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)Character.valueOf(annotation.value())));
        List<FieldEntry<Object>> booleanModifiers = this.getModifiers(field, BooleanField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> shortModifiers = this.getModifiers(field, ShortField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> byteModifiers = this.getModifiers(field, ByteField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> classModifiers = this.getModifiers(field, ClassField.class, annotation -> ObjectBot.field((String)annotation.name()).value((Object)annotation.value()));
        List<FieldEntry<Object>> anyModifiers = this.getModifiers(field, AnyField.class, this::getAnyValue);
        return Stream.of(stringModifiers, longModifiers, intModifiers, anyModifiers, doubleModifiers, floatModifiers, charModifiers, booleanModifiers, shortModifiers, byteModifiers, classModifiers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private FieldEntry<Object> getAnyValue(AnyField annotation) {
        Class factory = annotation.factory();
        return ObjectBot.field((String)annotation.name()).value(((FieldFactory)ReflectionSupport.newInstance((Class)factory, (Object[])new Object[0])).getValue());
    }

    private <T extends Annotation> List<FieldEntry<Object>> getModifiers(Field field, Class<T> annotationClass, Function<T, FieldEntry<Object>> function) {
        Annotation[] annotations = field.getAnnotationsByType(annotationClass);
        if (annotations.length == 0) {
            return new ArrayList<FieldEntry<Object>>();
        }
        return Arrays.stream(annotations).map(annotation -> (FieldEntry)function.apply(annotation)).collect(Collectors.toList());
    }

    private ObjectBot createBot(BotWith botWith) {
        Class[] factories = botWith.value();
        BotInitializer initializer = (BotInitializer)ReflectionSupport.newInstance((Class)factories[0], (Object[])new Object[0]);
        ObjectBot bot = new ObjectBot();
        initializer.initializer(bot);
        return bot;
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        Optional<BotWith> annotation = this.findBotAnnotation(context);
        annotation.ifPresent(botWith -> {
            ObjectBot bot = this.createBot((BotWith)botWith);
            context.getStore(BOT).put((Object)testClass, (Object)bot);
        });
    }

    private Optional<BotWith> findBotAnnotation(ExtensionContext context) {
        Optional element = context.getElement();
        return element.flatMap(annotatedElement -> ReflectionSupport.findAnnotation((AnnotatedElement)annotatedElement, BotWith.class));
    }

    public void afterAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        context.getStore(BOT).remove((Object)testClass);
    }
}

