/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph.dot;

import com.github.ferstl.depgraph.graph.dot.DotEscaper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DotAttributeBuilder {
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    public DotAttributeBuilder label(String label) {
        if (StringUtils.startsWith((CharSequence)label, (CharSequence)"<") && StringUtils.endsWith((CharSequence)label, (CharSequence)">")) {
            this.attributes.put("label", label);
            return this;
        }
        return this.addAttribute("label", label);
    }

    public DotAttributeBuilder fontName(String fontName) {
        return this.addAttribute("fontname", fontName);
    }

    public DotAttributeBuilder fontSize(int fontSize) {
        if (fontSize > 0) {
            return this.addAttribute("fontsize", Integer.toString(fontSize));
        }
        if (fontSize < 0) {
            throw new IllegalArgumentException("Negative font size");
        }
        return this;
    }

    public DotAttributeBuilder fontSize(Integer fontSize) {
        return this.fontSize(fontSize != null ? fontSize : 0);
    }

    public DotAttributeBuilder fontColor(String color) {
        return this.addAttribute("fontcolor", color);
    }

    public DotAttributeBuilder style(String style) {
        return this.addAttribute("style", style);
    }

    public DotAttributeBuilder color(String color) {
        return this.addAttribute("color", color);
    }

    public DotAttributeBuilder fillColor(String color) {
        return this.addAttribute("fillcolor", color);
    }

    public DotAttributeBuilder shape(String shape) {
        return this.addAttribute("shape", shape);
    }

    public DotAttributeBuilder rankdir(String rankdir) {
        return this.addAttribute("rankdir", rankdir);
    }

    public DotAttributeBuilder addAttribute(String key, String value) {
        if (value != null) {
            this.attributes.put(key, DotEscaper.escape(value));
        }
        return this;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public String toString() {
        if (this.attributes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            sb.append(attribute.getKey()).append("=").append(attribute.getValue()).append(",");
        }
        return sb.delete(sb.length() - 1, sb.length()).append("]").toString();
    }
}

