/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.api.API;
import weixin.popular.api.BaseAPI;
import weixin.popular.api.CommentAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.component.ApiGetAuthorizerInfoResult;
import weixin.popular.bean.component.ApiQueryAuthResult;
import weixin.popular.bean.component.AuthorizerAccessToken;
import weixin.popular.bean.component.AuthorizerOption;
import weixin.popular.bean.component.ComponentAccessToken;
import weixin.popular.bean.component.PreAuthCode;
import weixin.popular.client.LocalHttpClient;

public class ComponentAPI
extends BaseAPI {
    private static Logger logger = LoggerFactory.getLogger(CommentAPI.class);

    public static String componentloginpage(String component_appid, String pre_auth_code, String redirect_uri) {
        return ComponentAPI.componentloginpage(component_appid, pre_auth_code, redirect_uri, null);
    }

    public static String componentloginpage(String component_appid, String pre_auth_code, String redirect_uri, String auth_type) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://mp.weixin.qq.com/cgi-bin/componentloginpage?").append("component_appid=").append(component_appid).append("&pre_auth_code=").append(pre_auth_code).append("&redirect_uri=").append(URLEncoder.encode(redirect_uri, "utf-8"));
            if (auth_type != null) {
                sb.append("&auth_type=").append(auth_type);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static ComponentAccessToken api_component_token(String component_appid, String component_appsecret, String component_verify_ticket) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\" ,\"component_appsecret\": \"%2$s\",\"component_verify_ticket\": \"%3$s\"}", component_appid, component_appsecret, component_verify_ticket);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_component_token").setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ComponentAccessToken.class);
    }

    public static PreAuthCode api_create_preauthcode(String component_access_token, String component_appid) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\"}", component_appid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, PreAuthCode.class);
    }

    public static ApiQueryAuthResult api_query_auth(String component_access_token, String component_appid, String authorization_code) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorization_code\":\"%2$s\"}", component_appid, authorization_code);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_query_auth").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ApiQueryAuthResult.class);
    }

    public static AuthorizerAccessToken api_authorizer_token(String component_access_token, String component_appid, String authorizer_appid, String authorizer_refresh_token) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\",\"authorizer_refresh_token\":\"%3$s\"}", component_appid, authorizer_appid, authorizer_refresh_token);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, AuthorizerAccessToken.class);
    }

    public static ApiGetAuthorizerInfoResult api_get_authorizer_info(String component_access_token, String component_appid, String authorizer_appid) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\"}", component_appid, authorizer_appid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, ApiGetAuthorizerInfoResult.class);
    }

    public static AuthorizerOption api_get_authorizer_option(String component_access_token, String component_appid, String authorizer_appid, String option_name) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\",\"option_name\":\"%3$s\"}", component_appid, authorizer_appid, option_name);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_option").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, AuthorizerOption.class);
    }

    public static BaseResult api_set_authorizer_option(String component_access_token, String component_appid, String authorizer_appid, String option_name, String option_value) {
        String postJsonData = String.format("{\"component_appid\":\"%1$s\",\"authorizer_appid\":\"%2$s\",\"option_name\":\"%3$s\",\"option_value\":\"%4$s\"}", component_appid, authorizer_appid, option_name, option_value);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/api_set_authorizer_option").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(postJsonData, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult clear_quota(String component_access_token, String component_appid) {
        String json = String.format("{\"component_appid\":\"%s\"}", component_appid);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/component/clear_quota").addParameter("component_access_token", API.componentAccessToken(component_access_token)).setEntity((HttpEntity)new StringEntity(json, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }
}

