/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import oshi.jna.platform.windows.WinNT;

public class Advapi32Util
extends com.sun.jna.platform.win32.Advapi32Util {
    public static Advapi32Util.Account getTokenPrimaryGroup(WinNT.HANDLE hToken) {
        Advapi32Util.Account group;
        IntByReference tokenInformationLength = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(hToken, 5, null, 0, tokenInformationLength)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int rc = Kernel32.INSTANCE.GetLastError();
        if (rc != 122) {
            throw new Win32Exception(rc);
        }
        WinNT.TOKEN_PRIMARY_GROUP primaryGroup = new WinNT.TOKEN_PRIMARY_GROUP(tokenInformationLength.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(hToken, 5, (Structure)primaryGroup, tokenInformationLength.getValue(), tokenInformationLength)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        try {
            group = Advapi32Util.getAccountBySid((WinNT.PSID)primaryGroup.PrimaryGroup);
        }
        catch (Exception e) {
            group = new Advapi32Util.Account();
            group.sid = primaryGroup.PrimaryGroup.getBytes();
            group.name = group.sidString = Advapi32Util.convertSidToStringSid((WinNT.PSID)primaryGroup.PrimaryGroup);
            group.fqn = group.sidString;
            group.accountType = 2;
        }
        return group;
    }
}

