/*
 * Decompiled with CFR 0.152.
 */
package com.github.emailservice.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

public class FileUtil {
    private static Pattern PATTERN_ENG = Pattern.compile("^[0-9a-zA-Z]+$");

    public static String getFileName(String url) {
        int index1;
        int index;
        String url0;
        boolean isUrl;
        if (url == null || url.isEmpty()) {
            return url;
        }
        try {
            isUrl = true;
            url0 = new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            isUrl = false;
            url0 = url;
        }
        if (url0 == null || url0.isEmpty()) {
            url0 = url;
        }
        String substring = url0;
        if (isUrl && (index = url0.lastIndexOf("/")) != -1) {
            substring = url0.substring(Math.min(index + 1, url0.length()));
        }
        String name = (index1 = substring.lastIndexOf(46)) != -1 ? substring.substring(0, index1) : substring;
        if (isUrl) {
            name = FileUtil.filterSymbol(name);
        }
        return name.replaceFirst("[.]", "");
    }

    public static String filterSymbol(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        String s = name.replaceAll("[\u201c<'>\"| %/?#:;,\u201d+*]", "");
        return s.substring(0, Math.min(s.length(), 255));
    }

    public static String getFileExtension(String fileName) {
        return FileUtil.getFileExtension(fileName, "");
    }

    public static String getFileExtension(String fileName, String def) {
        int index;
        String fileName0;
        if (fileName == null || fileName.isEmpty()) {
            return def;
        }
        try {
            fileName0 = fileName.contains(":") ? new URL(fileName).getPath() : fileName;
        }
        catch (MalformedURLException e) {
            fileName0 = fileName;
        }
        if (fileName0 == null || fileName0.isEmpty()) {
            fileName0 = fileName;
        }
        if ((index = fileName0.lastIndexOf(46)) != -1) {
            String s = fileName0.substring(index).replaceFirst("\\.", "");
            if (PATTERN_ENG.matcher(s).matches()) {
                return s.toLowerCase(Locale.ENGLISH);
            }
            return null;
        }
        return def;
    }

    public static synchronized File cacheTempFile(String cacheFileName, IOSupplier<InputStream> inputStream, boolean deleteOnExit) throws IOException {
        String completeLength;
        if (cacheFileName.length() >= 255) {
            cacheFileName = cacheFileName.hashCode() + "." + FileUtil.getFileExtension(cacheFileName);
        }
        String cacheKey = FileUtil.filterSymbol(cacheFileName);
        File tempFile = new File(System.getProperty("java.io.tmpdir"), cacheKey);
        Path path = tempFile.toPath();
        if (tempFile.exists() && (completeLength = FileUtil.getFileAttribute(path, "complete_length")) != null && Objects.equals(completeLength, String.valueOf(tempFile.length()))) {
            return tempFile;
        }
        long size = FileUtil.copy(inputStream.get(), tempFile.toPath(), 0x100000, StandardCopyOption.REPLACE_EXISTING);
        if (deleteOnExit) {
            tempFile.deleteOnExit();
        }
        FileUtil.setFileAttribute(path, "complete_length", Long.toString(size));
        return tempFile;
    }

    public static String getFileAttribute(Path file, String attrName) {
        try {
            Object value = Files.getAttribute(file, "user:" + attrName, new LinkOption[0]);
            if (value instanceof byte[]) {
                return new String((byte[])value, Charset.forName("utf-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean setFileAttribute(Path file, String attrName, String attrValue) {
        if (attrValue == null) {
            return false;
        }
        try {
            Files.setAttribute(file, "user:" + attrName, ByteBuffer.wrap(attrValue.getBytes("UTF-8")), new LinkOption[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long copy(InputStream in, Path target, int bufferSize, CopyOption ... options) throws IOException {
        OutputStream ostream;
        Objects.requireNonNull(in);
        boolean replaceExisting = false;
        for (CopyOption opt : options) {
            if (opt != StandardCopyOption.REPLACE_EXISTING) {
                if (opt == null) {
                    throw new NullPointerException("options contains 'null'");
                }
                throw new UnsupportedOperationException(opt + " not supported");
            }
            replaceExisting = true;
        }
        SecurityException se = null;
        if (replaceExisting) {
            try {
                Files.deleteIfExists(target);
            }
            catch (SecurityException x) {
                se = x;
            }
        }
        try {
            ostream = Files.newOutputStream(target, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (FileAlreadyExistsException x) {
            if (se != null) {
                throw se;
            }
            throw x;
        }
        try (OutputStream out = ostream;){
            long l = FileUtil.copy(in, out, bufferSize);
            return l;
        }
    }

    public static long copy(InputStream source, OutputStream sink, int bufferSize) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[bufferSize];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    @FunctionalInterface
    public static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

