/*
 * Decompiled with CFR 0.152.
 */
package com.github.emailservice.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class HtmlQuery<T extends Element> {
    public static final HtmlQuery EMPTY = new HtmlQuery<Object>(null);
    private final T element;

    private HtmlQuery(T element) {
        this.element = element;
    }

    public static HtmlQuery<Document> valueOf(String html) {
        if (html == null || html.isEmpty()) {
            return EMPTY;
        }
        return new HtmlQuery<Document>(Jsoup.parse((String)html));
    }

    public static <T extends Element> HtmlQuery<T> valueOf(T element) {
        if (element == null) {
            return EMPTY;
        }
        return new HtmlQuery<T>(element);
    }

    public static String inlineCss(String html) {
        String style = "style";
        Document doc = Jsoup.parse((String)html);
        Elements els = doc.select("style");
        for (Element e : els) {
            String styleRules = ((Element)e.getAllElements().get(0)).data().replaceAll("\n", "").trim();
            String delims = "{}";
            StringTokenizer st = new StringTokenizer(styleRules, delims);
            while (st.countTokens() > 1) {
                String selector = st.nextToken();
                String properties = st.nextToken();
                if (selector.contains(":")) continue;
                Elements selectedElements = doc.select(selector);
                Iterator iterator = selectedElements.iterator();
                while (iterator.hasNext()) {
                    Element selElem;
                    String oldProperties = (selElem = (Element)iterator.next()).attr("style");
                    selElem.attr("style", oldProperties.length() > 0 ? HtmlQuery.concatenateProperties(oldProperties, properties) : properties);
                }
            }
            e.remove();
        }
        return doc.toString();
    }

    private static String concatenateProperties(String oldProp, String newProp) {
        if (!(oldProp = oldProp.trim()).endsWith(";")) {
            oldProp = oldProp + ";";
        }
        return oldProp + newProp.replaceAll("\\s{2,}", "");
    }

    public T getElement() {
        return this.element;
    }

    public boolean isEmpty() {
        return this.element == null;
    }

    public HtmlQuery<Element> selectElement(String cssQuery, int index) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (index < 0) {
            return EMPTY;
        }
        if (index == 0) {
            return HtmlQuery.valueOf(this.element.selectFirst(cssQuery));
        }
        Elements elements = this.element.select(cssQuery);
        if (index >= elements.size()) {
            return EMPTY;
        }
        return HtmlQuery.valueOf((Element)elements.get(index));
    }

    public List<String> selectAttrs(String cssQuery, String attr) {
        return this.selectElements(cssQuery).stream().map(e -> e.attr(attr)).collect(Collectors.toList());
    }

    public String selectAttr(String cssQuery, String attr, int index) {
        HtmlQuery<Element> query = this.selectElement(cssQuery, index);
        return query.element != null ? query.element.attr(attr) : "";
    }

    public List<String> selectTexts(String cssQuery) {
        return this.selectElements(cssQuery).stream().map(Element::text).collect(Collectors.toList());
    }

    public String selectText(String cssQuery, int index) {
        if (this.isEmpty()) {
            return "";
        }
        T element = this.selectElement((String)cssQuery, (int)index).element;
        return element != null ? element.text() : "";
    }

    public String attr(String attributeKey) {
        if (this.isEmpty()) {
            return "";
        }
        return this.getElement().attr(attributeKey);
    }

    public String text() {
        if (this.isEmpty()) {
            return "";
        }
        return this.getElement().text();
    }

    public HtmlQuery<Element> moveIndexByTagEq(ToIntBiFunction<Elements, Element> choseIndexFn) {
        T element = this.getElement();
        if (this.isEmpty() || element.parent() == null) {
            return EMPTY;
        }
        String currentTagName = element.tagName();
        Elements elements = element.parent().children().stream().filter(o -> Objects.equals(currentTagName, o.tagName())).collect(Collectors.toCollection(Elements::new));
        int nextIndex = choseIndexFn.applyAsInt(elements, (Element)element);
        Element next = nextIndex >= 0 && nextIndex < elements.size() ? (Element)elements.get(nextIndex) : null;
        return HtmlQuery.valueOf(next);
    }

    public HtmlQuery<Element> prevByTagEq() {
        return this.moveIndexByTagEq((elements, element) -> elements.indexOf(element) - 1);
    }

    public HtmlQuery<Element> nextByTagEq() {
        return this.moveIndexByTagEq((elements, element) -> elements.indexOf(element) + 1);
    }

    public String selectTextValueContaining(String match, int index) {
        if (this.isEmpty()) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Node node : this.getElement().childNodes()) {
            String text = node instanceof Element ? ((Element)node).text() : node.toString();
            if (!text.contains(match)) continue;
            list.add(text);
        }
        return index >= 0 && index < list.size() ? (String)list.get(index) : "";
    }

    public HtmlQuery<Element> breakParentByTagName(String tagName) {
        Object element;
        for (element = this.getElement(); element != null && !Objects.equals(element.tagName(), tagName); element = element.parent()) {
        }
        return HtmlQuery.valueOf(element);
    }

    private Elements selectElements(String cssQuery) {
        if (this.isEmpty()) {
            return new Elements();
        }
        return this.getElement().select(cssQuery);
    }

    public String toString() {
        return this.isEmpty() ? "empty" : this.element.toString();
    }
}

