/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.base.Objects;
import com.google.inject.grapher.Node;
import com.google.inject.grapher.NodeId;
import java.lang.reflect.Member;
import java.util.Collection;

public class ImplementationNode
extends Node {
    private final Collection<Member> members;

    public ImplementationNode(NodeId id, Object source, Collection<Member> members) {
        super(id, source);
        this.members = members;
    }

    public Collection<Member> getMembers() {
        return this.members;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ImplementationNode)) {
            return false;
        }
        ImplementationNode other = (ImplementationNode)obj;
        return super.equals(other) && Objects.equal(this.members, other.members);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object[])new Object[]{this.members});
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.getId()));
        String string2 = String.valueOf(String.valueOf(this.getSource()));
        String string3 = String.valueOf(String.valueOf(this.members));
        return new StringBuilder(40 + string.length() + string2.length() + string3.length()).append("ImplementationNode{id=").append(string).append(" source=").append(string2).append(" members=").append(string3).append("}").toString();
    }

    @Override
    public Node copy(NodeId id) {
        return new ImplementationNode(id, this.getSource(), this.getMembers());
    }
}

