/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Signature {
    private final MethodType methodType;
    private final String[] argNames;

    Signature(Class retval) {
        this(MethodType.methodType(retval), new String[0]);
    }

    Signature(Class retval, Class[] argTypes, String ... argNames) {
        this(MethodType.methodType(retval, argTypes), argNames);
    }

    Signature(Class retval, Class firstArg, Class[] restArgs, String ... argNames) {
        this(MethodType.methodType(retval, firstArg, restArgs), argNames);
    }

    Signature(MethodType methodType, String ... argNames) {
        assert (methodType.parameterCount() == argNames.length) : "arg name count " + argNames.length + " does not match parameter count " + methodType.parameterCount();
        this.methodType = methodType;
        this.argNames = argNames;
    }

    Signature(MethodType methodType, String firstName, String ... restNames) {
        assert (methodType.parameterCount() == restNames.length + 1) : "arg name count " + (restNames.length + 1) + " does not match parameter count " + methodType.parameterCount();
        this.methodType = methodType;
        this.argNames = new String[restNames.length + 1];
        this.argNames[0] = firstName;
        System.arraycopy(restNames, 0, this.argNames, 1, restNames.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.argNames.length; ++i) {
            sb.append(((Class)this.methodType.parameterType(i)).getSimpleName()).append(' ').append(this.argNames[i]);
            if (i + 1 >= this.argNames.length) continue;
            sb.append(", ");
        }
        sb.append(")").append(((Class)this.methodType.returnType()).getSimpleName());
        return sb.toString();
    }

    public static Signature returning(Class retval) {
        Signature sig = new Signature(retval);
        return sig;
    }

    public static Signature from(Class retval, Class[] argTypes, String ... argNames) {
        assert (argTypes.length == argNames.length);
        return new Signature(retval, argTypes, argNames);
    }

    public Signature changeReturn(Class retval) {
        return new Signature(this.methodType.changeReturnType(retval), this.argNames);
    }

    public Signature asFold(Class retval) {
        return new Signature(this.methodType.changeReturnType(retval), this.argNames);
    }

    public Signature appendArg(String name, Class type) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length);
        newArgNames[this.argNames.length] = name;
        MethodType newMethodType = this.methodType.appendParameterTypes(type);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature appendArgs(String[] names, Class ... types) {
        assert (names.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length + names.length];
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length);
        System.arraycopy(names, 0, newArgNames, this.argNames.length, names.length);
        MethodType newMethodType = this.methodType.appendParameterTypes(types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature prependArg(String name, Class type) {
        String[] newArgNames = new String[this.argNames.length + 1];
        System.arraycopy(this.argNames, 0, newArgNames, 1, this.argNames.length);
        newArgNames[0] = name;
        MethodType newMethodType = this.methodType.insertParameterTypes(0, type);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature prependArgs(String[] names, Class ... types) {
        String[] newArgNames = new String[this.argNames.length + names.length];
        System.arraycopy(this.argNames, 0, newArgNames, names.length, this.argNames.length);
        System.arraycopy(names, 0, newArgNames, 0, names.length);
        MethodType newMethodType = this.methodType.insertParameterTypes(0, types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature insertArg(int index, String name, Class type) {
        return this.insertArgs(index, new String[]{name}, type);
    }

    public Signature insertArg(String beforeName, String name, Class type) {
        return this.insertArgs(this.argOffset(beforeName), new String[]{name}, type);
    }

    public Signature insertArgs(int index, String[] names, Class ... types) {
        assert (names.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length + names.length];
        System.arraycopy(names, 0, newArgNames, index, names.length);
        if (index != 0) {
            System.arraycopy(this.argNames, 0, newArgNames, 0, index);
        }
        if (this.argNames.length - index != 0) {
            System.arraycopy(this.argNames, index, newArgNames, index + names.length, this.argNames.length - index);
        }
        MethodType newMethodType = this.methodType.insertParameterTypes(index, types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature insertArgs(String beforeName, String[] names, Class ... types) {
        return this.insertArgs(this.argOffset(beforeName), names, types);
    }

    public Signature dropArg(String name) {
        String[] newArgNames = new String[this.argNames.length - 1];
        MethodType newType = this.methodType;
        int j = 0;
        for (int i = 0; i < this.argNames.length; ++i) {
            if (this.argNames[i].equals(name)) {
                newType = newType.dropParameterTypes(j, j + 1);
                continue;
            }
            newArgNames[j++] = this.argNames[i];
        }
        if (newType == null) {
            return this;
        }
        return new Signature(newType, newArgNames);
    }

    public Signature dropArg(int index) {
        assert (index < this.argNames.length);
        String[] newArgNames = new String[this.argNames.length - 1];
        if (index > 0) {
            System.arraycopy(this.argNames, 0, newArgNames, 0, index);
        }
        if (index < this.argNames.length - 1) {
            System.arraycopy(this.argNames, index + 1, newArgNames, index, this.argNames.length - (index + 1));
        }
        MethodType newType = this.methodType.dropParameterTypes(index, index + 1);
        return new Signature(newType, newArgNames);
    }

    public Signature dropLast() {
        return this.dropLast(1);
    }

    public Signature dropLast(int n) {
        return new Signature(this.methodType.dropParameterTypes(this.methodType.parameterCount() - n, this.methodType.parameterCount()), Arrays.copyOfRange(this.argNames, 0, this.argNames.length - n));
    }

    public Signature dropFirst() {
        return this.dropFirst(1);
    }

    public Signature dropFirst(int n) {
        return new Signature(this.methodType.dropParameterTypes(0, n), Arrays.copyOfRange(this.argNames, n, this.argNames.length));
    }

    public Signature replaceArg(String oldName, String newName, Class newType) {
        int offset = this.argOffset(oldName);
        String[] newArgNames = this.argNames;
        if (!oldName.equals(newName)) {
            newArgNames = Arrays.copyOf(this.argNames, this.argNames.length);
            newArgNames[offset] = newName;
        }
        TypeDescriptor.OfField oldType = this.methodType.parameterType(offset);
        MethodType newMethodType = this.methodType;
        if (!oldType.equals(newType)) {
            newMethodType = this.methodType.changeParameterType(offset, newType);
        }
        return new Signature(newMethodType, newArgNames);
    }

    public Signature spread(String[] names, Class ... types) {
        assert (names.length == types.length) : "names and types must be of the same length";
        String[] newArgNames = new String[this.argNames.length - 1 + names.length];
        System.arraycopy(names, 0, newArgNames, newArgNames.length - names.length, names.length);
        System.arraycopy(this.argNames, 0, newArgNames, 0, this.argNames.length - 1);
        MethodType newMethodType = this.methodType.dropParameterTypes(this.methodType.parameterCount() - 1, this.methodType.parameterCount()).appendParameterTypes(types);
        return new Signature(newMethodType, newArgNames);
    }

    public Signature spread(String ... names) {
        Class aryType = this.lastArgType();
        assert (this.lastArgType().isArray());
        Object[] newTypes = new Class[names.length];
        Arrays.fill(newTypes, aryType.getComponentType());
        return this.spread(names, (Class[])newTypes);
    }

    public Signature spread(String baseName, int count) {
        String[] spreadNames = new String[count];
        for (int i = 0; i < count; ++i) {
            spreadNames[i] = baseName + i;
        }
        return this.spread(spreadNames);
    }

    public Signature collect(String newName, String oldPattern) {
        int start = -1;
        int newCount = 0;
        int gatherCount = 0;
        Class type = null;
        Pattern pattern = Pattern.compile(oldPattern);
        MethodType newType = this.type();
        for (int i = 0; i < this.argNames.length; ++i) {
            if (pattern.matcher(this.argName(i)).matches()) {
                ++gatherCount;
                newType = newType.dropParameterTypes(newCount, newCount + 1);
                Class argType = this.argType(i);
                if (start == -1) {
                    start = i;
                }
                if (type == null) {
                    type = argType;
                    continue;
                }
                if (argType == type) continue;
                throw new InvalidTransformException("arguments matching " + pattern + " are not all of the same type");
            }
            ++newCount;
        }
        if (start != -1) {
            String[] newNames = new String[newCount + 1];
            System.arraycopy(this.argNames, 0, newNames, 0, start);
            newNames[start] = newName;
            newType = newType.insertParameterTypes(start, Array.newInstance(type, 0).getClass());
            if (newCount + 1 > start) {
                System.arraycopy(this.argNames, start + gatherCount, newNames, start + 1, newCount - start);
            }
            return new Signature(newType, newNames);
        }
        return this;
    }

    public MethodType type() {
        return this.methodType;
    }

    public int argCount() {
        return this.argNames.length;
    }

    public String[] argNames() {
        return this.argNames;
    }

    public String argName(int index) {
        return this.argNames[index];
    }

    public int argOffset(String name) {
        for (int i = 0; i < this.argNames.length; ++i) {
            if (!this.argNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int argOffsets(String pattern) {
        for (int i = 0; i < this.argNames.length; ++i) {
            if (!Pattern.compile(pattern).matcher(this.argNames[i]).find()) continue;
            return i;
        }
        return -1;
    }

    public String firstArgName() {
        return this.argNames[0];
    }

    public String lastArgName() {
        return this.argNames[this.argNames.length - 1];
    }

    public Signature argName(int index, String name) {
        String[] argNames = Arrays.copyOf(this.argNames(), this.argNames().length);
        argNames[index] = name;
        return new Signature(this.type(), argNames);
    }

    public Class argType(int index) {
        return this.methodType.parameterType(index);
    }

    public Class firstArgType() {
        return this.methodType.parameterType(0);
    }

    public Class lastArgType() {
        return this.argType(this.methodType.parameterCount() - 1);
    }

    public Signature argType(int index, Class type) {
        return new Signature(this.type().changeParameterType(index, type), this.argNames());
    }

    public Signature permute(String ... permuteArgs) {
        Pattern[] patterns = new Pattern[permuteArgs.length];
        for (int i = 0; i < permuteArgs.length; ++i) {
            patterns[i] = Pattern.compile(permuteArgs[i]);
        }
        ArrayList<TypeDescriptor.OfField> types = new ArrayList<TypeDescriptor.OfField>(this.argNames.length);
        ArrayList<String> names = new ArrayList<String>(this.argNames.length);
        for (Pattern pattern : patterns) {
            for (int argOffset = 0; argOffset < this.argNames.length; ++argOffset) {
                String arg = this.argNames[argOffset];
                Matcher matcher = pattern.matcher(arg);
                if (!matcher.find()) continue;
                types.add(this.methodType.parameterType(argOffset));
                names.add(arg);
            }
        }
        return new Signature(MethodType.methodType(this.methodType.returnType(), types.toArray(new Class[0])), names.toArray(new String[0]));
    }

    public Signature exclude(String ... excludeArgs) {
        Pattern[] patterns = new Pattern[excludeArgs.length];
        for (int i = 0; i < excludeArgs.length; ++i) {
            patterns[i] = Pattern.compile(excludeArgs[i]);
        }
        ArrayList<TypeDescriptor.OfField> types = new ArrayList<TypeDescriptor.OfField>(this.argNames.length);
        ArrayList<String> names = new ArrayList<String>(this.argNames.length);
        block1: for (int argOffset = 0; argOffset < this.argNames.length; ++argOffset) {
            String arg = this.argNames[argOffset];
            for (Pattern pattern : patterns) {
                Matcher matcher = pattern.matcher(arg);
                if (matcher.find()) continue block1;
            }
            types.add(this.methodType.parameterType(argOffset));
            names.add(arg);
        }
        return new Signature(MethodType.methodType(this.methodType.returnType(), types.toArray(new Class[0])), names.toArray(new String[0]));
    }

    public MethodHandle permuteWith(MethodHandle target, String ... permuteArgs) {
        return MethodHandles.permuteArguments(target, this.methodType, this.to(this.permute(permuteArgs)));
    }

    public SmartHandle permuteWith(SmartHandle target) {
        String[] argNames = target.signature().argNames();
        return new SmartHandle(this, this.permuteWith(target.handle(), argNames));
    }

    public int[] to(Signature other) {
        return this.nonMatchingTo(other.argNames);
    }

    public int[] to(String ... otherArgPatterns) {
        return this.to(this.permute(otherArgPatterns));
    }

    private int[] nonMatchingTo(String ... otherArgNames) {
        int[] offsets = new int[otherArgNames.length];
        int i = 0;
        for (String arg : otherArgNames) {
            int pos = -1;
            for (int offset = 0; offset < this.argNames.length; ++offset) {
                if (!this.argNames[offset].equals(arg)) continue;
                pos = offset;
                break;
            }
            assert (pos >= 0) : "argument not found: \"" + arg + "\"";
            offsets[i++] = pos;
        }
        return offsets;
    }
}

