/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.ChangeOrderTraceState;
import com.aliyun.enums.Status;
import com.aliyun.utils.CommonUtils;
import com.aliyun.utils.HttpUtils;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.sae.model.v20190506.DescribeChangeOrderRequest;
import com.aliyuncs.sae.model.v20190506.DescribeChangeOrderResponse;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class SaeChangeOrderManager {
    private Log logger = Context.getLogger();
    private ChangeOrderTraceState curTraceState = new ChangeOrderTraceState();

    public void trace(DefaultAcsClient defaultAcsClient, String changeOrderId, int serviceStageTimeout, int instanceStageTimeout) throws Exception {
        boolean finish;
        this.logger.info((CharSequence)("Begin to trace change order: " + changeOrderId));
        while (!(finish = this.trace0(defaultAcsClient, changeOrderId))) {
            this.sleep(5000L);
        }
    }

    private boolean trace0(DefaultAcsClient defaultAcsClient, String changeOrderId) throws Exception {
        DescribeChangeOrderRequest request = new DescribeChangeOrderRequest();
        request.setChangeOrderId(changeOrderId);
        String routeKey = CommonUtils.getPopApiRouteKey();
        if (routeKey != null) {
            request.putHeaderParameter("X-EDAS-AT-ROUTER-KEY", routeKey);
        }
        ChangeOrderTraceState beforeState = this.curTraceState.clone();
        try {
            DescribeChangeOrderResponse response = (DescribeChangeOrderResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)defaultAcsClient, request);
            if ("200".equals(response.getCode())) {
                boolean finish = this.handleSuccessResponse(response);
                if (finish) {
                    return true;
                }
            } else {
                String msg = String.format("Failed to get change order info, code:%s, message:%s", response.getCode(), response.getMessage());
                this.logger.error((CharSequence)msg);
            }
        }
        catch (ClientException ex) {
            String msg = "Failed to get change order info: " + ex.getMessage();
            this.logger.error((CharSequence)msg);
        }
        if (beforeState.equals(this.curTraceState)) {
            this.logger.info((CharSequence)"Waiting...");
        }
        return false;
    }

    private boolean handleSuccessResponse(DescribeChangeOrderResponse response) throws Exception {
        List pipelineInfos = response.getData().getPipelines();
        while (this.curTraceState.getPipelineCounter() < pipelineInfos.size()) {
            int beforePipelineCounter = this.curTraceState.getPipelineCounter();
            this.showPipeline((DescribeChangeOrderResponse.Data.Pipeline)pipelineInfos.get(this.curTraceState.getPipelineCounter()));
            if (beforePipelineCounter != this.curTraceState.getPipelineCounter()) continue;
            break;
        }
        if (this.isEndStatus(response.getData().getStatus())) {
            Status status = Status.getByVal(response.getData().getStatus());
            switch (status) {
                case SUCCESS: {
                    this.logger.info((CharSequence)"Deploy application successfully!");
                    return true;
                }
                case EXCEPTION: {
                    throw new Exception("Deploy failed due to exception");
                }
                case FAIL: {
                    throw new Exception("Deploy failed");
                }
                case ABORT: {
                    throw new Exception("Deploy failed due to abort");
                }
            }
            throw new Exception("Deploy failed for unknown reason.");
        }
        return false;
    }

    private void showPipeline(DescribeChangeOrderResponse.Data.Pipeline pipelineInfo) throws Exception {
        if (!this.curTraceState.isHadPrintPipelineInfo()) {
            String pipelineId = pipelineInfo.getPipelineId();
            String pipelineName = pipelineInfo.getPipelineName();
            this.logger.info((CharSequence)String.format("PipelineName:%s, PipelineId:%s", pipelineName, pipelineId));
            this.curTraceState.setHadPrintPipelineInfo(true);
        }
        if (this.isSuccessStatus(pipelineInfo.getStatus())) {
            this.curTraceState.setPipelineCounter(this.curTraceState.getPipelineCounter() + 1);
            this.curTraceState.resetPipelineState();
        }
    }

    private boolean isEndStatus(Integer s) {
        Status status = Status.getByVal(s);
        switch (status) {
            case SUCCESS: 
            case EXCEPTION: 
            case FAIL: 
            case ABORT: {
                return true;
            }
        }
        return false;
    }

    private boolean isSuccessStatus(Integer s) {
        return s != null && s.intValue() == Status.SUCCESS.getVal();
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

