/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;

public abstract class AbstractConfigManager<T> {
    private ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private ObjectMapper jsonMapper;

    public AbstractConfigManager(boolean snakeCase) {
        if (snakeCase) {
            this.yamlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        }
        this.yamlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper = new ObjectMapper();
        if (snakeCase) {
            this.jsonMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        }
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected T load(String configFile, String defaultFile, Class<T> clazz) throws Exception {
        File file = configFile != null ? new File(configFile) : new File(defaultFile);
        if (!file.exists()) {
            throw new Exception("No config file is found: " + file.getAbsolutePath());
        }
        return (T)this.yamlMapper.readValue(file, clazz);
    }

    protected T load(String configFile, Class<T> clazz) throws Exception {
        File file = new File(configFile);
        if (!file.exists()) {
            throw new Exception("No config file is found: " + file.getAbsolutePath());
        }
        return (T)this.yamlMapper.readValue(file, clazz);
    }
}

