/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.uploader;

import com.aliyun.Context;
import com.aliyun.uploader.BaseOssUploader;
import com.aliyun.utils.CommonUtils;
import com.aliyun.utils.HttpUtils;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.edas.model.v20170801.GetPackageStorageCredentialRequest;
import com.aliyuncs.edas.model.v20170801.GetPackageStorageCredentialResponse;
import java.io.File;
import java.util.UUID;

public class PublicOssUploader
extends BaseOssUploader {
    private static final String NAME = "Public OSS Uploader";
    private static final String OSS_KEY_PTN = "%s/apps/%s/%s/%s";
    private String edasEndpoint;
    private String regionId;
    private String appId;

    private String generateKey(File file, String keyPrefix) {
        return String.format(OSS_KEY_PTN, keyPrefix, this.appId, UUID.randomUUID().toString(), file.getName());
    }

    private GetPackageStorageCredentialResponse.Credential applyForCredential() {
        try {
            GetPackageStorageCredentialResponse response;
            DefaultAcsClient client = Context.getAcsClient();
            GetPackageStorageCredentialRequest request = new GetPackageStorageCredentialRequest();
            String routeKey = CommonUtils.getPopApiRouteKey();
            if (routeKey != null) {
                request.putHeaderParameter("X-EDAS-AT-ROUTER-KEY", routeKey);
            }
            if (CommonUtils.isEmpty(response = (GetPackageStorageCredentialResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)client, new GetPackageStorageCredentialRequest())) || CommonUtils.isEmpty(response.getCredential()) || CommonUtils.isEmpty(response.getCredential().getAccessKeyId())) {
                return null;
            }
            return response.getCredential();
        }
        catch (Exception ex) {
            return null;
        }
    }

    PublicOssUploader(String edasEndpoint, String regionId, String appId) {
        this.edasEndpoint = edasEndpoint;
        this.regionId = regionId;
        this.appId = appId;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String upload(File file) throws Exception {
        GetPackageStorageCredentialResponse.Credential credential = this.applyForCredential();
        if (CommonUtils.isEmpty(credential)) {
            throw new Exception(String.format("Can not get token for uploading, please make sure your ak/sk is correct and network(%s) is ok.", this.edasEndpoint));
        }
        String bucket = credential.getBucket();
        String key = this.generateKey(file, credential.getKeyPrefix());
        String ak = credential.getAccessKeyId();
        String sk = credential.getAccessKeySecret();
        String token = credential.getSecurityToken();
        return this.doUpload(this.edasEndpoint, this.regionId, bucket, key, file, ak, sk, token, null);
    }
}

