/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;

public class PdfLinkAnnotation
extends PdfAnnotation {
    private static final long serialVersionUID = 5795613340575331536L;
    public static final PdfName None = PdfName.N;
    public static final PdfName Invert = PdfName.I;
    public static final PdfName Outline = PdfName.O;
    public static final PdfName Push = PdfName.P;

    public PdfLinkAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfLinkAnnotation(Rectangle rect) {
        super(rect);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Link;
    }

    public PdfObject getDestinationObject() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.Dest);
    }

    public PdfLinkAnnotation setDestination(PdfObject destination) {
        return (PdfLinkAnnotation)this.put(PdfName.Dest, destination);
    }

    public PdfLinkAnnotation setDestination(PdfDestination destination) {
        return (PdfLinkAnnotation)this.put(PdfName.Dest, (PdfObject)destination.getPdfObject());
    }

    public PdfLinkAnnotation setAction(PdfDictionary action) {
        return (PdfLinkAnnotation)this.put(PdfName.A, action);
    }

    @Override
    public PdfLinkAnnotation setAction(PdfAction action) {
        return (PdfLinkAnnotation)this.put(PdfName.A, (PdfObject)action.getPdfObject());
    }

    public PdfName getHighlightMode() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.H);
    }

    public PdfLinkAnnotation setHighlightMode(PdfName hlMode) {
        return (PdfLinkAnnotation)this.put(PdfName.H, hlMode);
    }

    public PdfDictionary getUriActionObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.PA);
    }

    public PdfLinkAnnotation setUriAction(PdfDictionary action) {
        return (PdfLinkAnnotation)this.put(PdfName.PA, action);
    }

    public PdfLinkAnnotation setUriAction(PdfAction action) {
        return (PdfLinkAnnotation)this.put(PdfName.PA, (PdfObject)action.getPdfObject());
    }
}

