/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TradesSoldQueryResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradesSoldQueryRequest
extends BaseTaobaoRequest<TradesSoldQueryResponse> {
    private String queryList;

    public void setQueryList(String queryList) {
        this.queryList = queryList;
    }

    public void setQueryList(List<OrderQuery> queryList) {
        this.queryList = new JSONWriter(false, true).write(queryList);
    }

    public String getQueryList() {
        return this.queryList;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.trades.sold.query";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("query_list", this.queryList);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<TradesSoldQueryResponse> getResponseClass() {
        return TradesSoldQueryResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.queryList, 999, "queryList");
    }

    public static class OrderQuery
    extends TaobaoObject {
        private static final long serialVersionUID = 7147378395235796751L;
        @ApiField(value="end_created")
        private Date endCreated;
        @ApiField(value="receiver_mobile")
        private String receiverMobile;
        @ApiField(value="receiver_name")
        private String receiverName;
        @ApiField(value="receiver_phone")
        private String receiverPhone;
        @ApiField(value="start_created")
        private Date startCreated;

        public Date getEndCreated() {
            return this.endCreated;
        }

        public void setEndCreated(Date endCreated) {
            this.endCreated = endCreated;
        }

        public String getReceiverMobile() {
            return this.receiverMobile;
        }

        public void setReceiverMobile(String receiverMobile) {
            this.receiverMobile = receiverMobile;
        }

        public String getReceiverName() {
            return this.receiverName;
        }

        public void setReceiverName(String receiverName) {
            this.receiverName = receiverName;
        }

        public String getReceiverPhone() {
            return this.receiverPhone;
        }

        public void setReceiverPhone(String receiverPhone) {
            this.receiverPhone = receiverPhone;
        }

        public Date getStartCreated() {
            return this.startCreated;
        }

        public void setStartCreated(Date startCreated) {
            this.startCreated = startCreated;
        }
    }
}

