/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedArchaiusProperty;
import com.netflix.hystrix.strategy.properties.HystrixProperty;

public abstract class HystrixTimerThreadPoolProperties {
    private final HystrixProperty<Integer> corePoolSize;

    protected HystrixTimerThreadPoolProperties() {
        this(new Setter().withCoreSize(Runtime.getRuntime().availableProcessors()));
    }

    protected HystrixTimerThreadPoolProperties(Setter setter) {
        this.corePoolSize = HystrixTimerThreadPoolProperties.getProperty("hystrix", "coreSize", setter.getCoreSize());
    }

    private static HystrixProperty<Integer> getProperty(String propertyPrefix, String instanceProperty, Integer defaultValue) {
        return HystrixProperty.Factory.asProperty(new HystrixPropertiesChainedArchaiusProperty.IntegerProperty(new HystrixPropertiesChainedArchaiusProperty.DynamicIntegerProperty(propertyPrefix + ".timer.threadpool.default." + instanceProperty, defaultValue)));
    }

    public HystrixProperty<Integer> getCorePoolSize() {
        return this.corePoolSize;
    }

    public static Setter Setter() {
        return new Setter();
    }

    public static class Setter {
        private Integer coreSize = null;

        private Setter() {
        }

        public Integer getCoreSize() {
            return this.coreSize;
        }

        public Setter withCoreSize(int value) {
            this.coreSize = value;
            return this;
        }
    }
}

