/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpClient;
import com.doudian.open.core.DoudianOpClientHolder;
import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.core.DoudianOpRequestExecutor;
import com.doudian.open.core.DoudianOpResponse;
import com.doudian.open.core.DoudianOpResponseWrapper;
import com.doudian.open.core.GlobalConfig;
import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.utils.Logger;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class DoudianOpRequest<R>
implements DoudianOpRequestExecutor {
    private static final Logger LOG = Logger.getLogger(DoudianOpRequest.class);
    private DoudianOpClient client = DoudianOpClientHolder.getClient();
    private DoudianOpConfig config = GlobalConfig.getGlobalConfig();
    private R param;

    public abstract String getUrlPath();

    public DoudianOpRequest() {
        Class<?> paramClass = this.getSuperClassParameterClass(this.getClass());
        try {
            this.param = paramClass.newInstance();
        }
        catch (Exception e) {
            throw new DoudianOpException(DoudianOpException.Code.INIT_REQUEST_PARAM_ERROR, e);
        }
    }

    public abstract Class<? extends DoudianOpResponse<?>> getResponseClass();

    public <T> T execute(AccessToken accessToken) {
        long now = System.currentTimeMillis();
        DoudianOpResponseWrapper ret = this.client.request(this, accessToken);
        return ret.getResponse();
    }

    public <T> Future<T> asyncExecute(AccessToken accessToken) {
        Future wrapperFuture = this.client.asyncRequest(this, accessToken);
        return new FutureAdapter(wrapperFuture);
    }

    private Class<?> getSuperClassParameterClass(Class<?> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new DoudianOpException(e);
        }
    }

    public DoudianOpClient getClient() {
        return this.client;
    }

    public void setClient(DoudianOpClient client) {
        this.client = client;
    }

    public DoudianOpConfig getConfig() {
        return this.config;
    }

    public void setConfig(DoudianOpConfig config) {
        this.config = config;
    }

    public R getParam() {
        return this.param;
    }

    public void setParam(R param) {
        this.param = param;
    }

    static class FutureAdapter<T>
    implements Future<T> {
        private Future<DoudianOpResponseWrapper<T>> future;

        FutureAdapter(Future<DoudianOpResponseWrapper<T>> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.future.get().getResponse();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit).getResponse();
        }
    }
}

