/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core.material;

import com.doudian.open.api.materialgw.address.BinaryMaterialUploadAddressResponse;
import com.doudian.open.api.materialgw.auth.BinaryMaterialUploadAddressAuthData;
import com.doudian.open.api.materialgw.auth.BinaryMaterialUploadAddressAuthParam;
import com.doudian.open.api.materialgw.auth.BinaryMaterialUploadAddressAuthRequest;
import com.doudian.open.api.materialgw.auth.BinaryMaterialUploadAddressAuthResponse;
import com.doudian.open.api.materialgw.upload.BinaryMaterialUploadParam;
import com.doudian.open.api.materialgw.upload.BinaryMaterialUploadResponse;
import com.doudian.open.api.materialgw.upload.BinaryMaterialUploadResponseWrapper;
import com.doudian.open.api.materialgw.upload.BinaryMaterialUploadResponseWrapperData;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.core.DoudianOpResponseWrapper;
import com.doudian.open.core.http.DefaultHttpClient;
import com.doudian.open.core.http.HttpClient;
import com.doudian.open.core.http.HttpRequest;
import com.doudian.open.core.http.HttpResponse;
import com.doudian.open.core.material.BinaryMaterialUploadExecutor;
import com.doudian.open.core.threadpool.DoudianOpThreadPool;
import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.utils.JsonUtil;
import com.doudian.open.utils.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.CRC32;

public class BinaryMaterialUpload
implements BinaryMaterialUploadExecutor {
    private DoudianOpConfig config;
    private static final Logger LOG = Logger.getLogger(BinaryMaterialUpload.class);
    private static HttpClient httpClient = DefaultHttpClient.getDefaultClient();
    private static final BinaryMaterialUpload defaultUpload = new BinaryMaterialUpload();

    public DoudianOpConfig getConfig() {
        return this.config;
    }

    public void setConfig(DoudianOpConfig config) {
        this.config = config;
    }

    public static BinaryMaterialUpload getDefaultUpload() {
        return defaultUpload;
    }

    @Override
    public BinaryMaterialUploadResponseWrapper execute(BinaryMaterialUploadParam t, AccessToken accessToken) {
        return this.doRequest(t, accessToken);
    }

    @Override
    public Future<BinaryMaterialUploadResponseWrapper> asyncExecute(final BinaryMaterialUploadParam t, final AccessToken accessToken) {
        return DoudianOpThreadPool.getInstance(this.getConfig()).submit(new Callable<BinaryMaterialUploadResponseWrapper>(){

            @Override
            public BinaryMaterialUploadResponseWrapper call() throws Exception {
                return BinaryMaterialUpload.getDefaultUpload().doRequest(t, accessToken);
            }
        });
    }

    private BinaryMaterialUploadResponseWrapper doRequest(BinaryMaterialUploadParam t, AccessToken accessToken) {
        HttpResponse httpResponse;
        BinaryMaterialUploadResponseWrapper r = new BinaryMaterialUploadResponseWrapper();
        BinaryMaterialUploadAddressAuthRequest request = new BinaryMaterialUploadAddressAuthRequest();
        BinaryMaterialUploadAddressAuthParam param = (BinaryMaterialUploadAddressAuthParam)request.getParam();
        param.setUploadNum(1);
        param.setFileExtension(t.getExtension());
        BinaryMaterialUploadAddressAuthResponse response = (BinaryMaterialUploadAddressAuthResponse)request.execute(accessToken);
        if (!response.isSuccess()) {
            r.setCode(response.getCode());
            r.setMsg(response.getMsg());
            r.setSubCode(response.getSubCode());
            r.setSubMsg(response.getSubMsg());
            r.setLogId(response.getLogId());
            return r;
        }
        HttpRequest httpRequest = HttpRequest.build(((BinaryMaterialUploadAddressAuthData)response.getData()).getAuthQuery());
        LOG.info("material gateway uploadAddress http request url: %s", ((BinaryMaterialUploadAddressAuthData)response.getData()).getAuthQuery());
        if (request.getConfig().getMaterialGatewayHttpConnectTimeout() != null) {
            httpRequest.setConnectTimeout(request.getConfig().getMaterialGatewayHttpConnectTimeout());
        }
        if (request.getConfig().getMaterialGatewayHttpReadTimeout() != null) {
            httpRequest.setReadTimeout(request.getConfig().getMaterialGatewayHttpReadTimeout());
        }
        if ((httpResponse = httpClient.get(httpRequest)).getStatusCode() != 200) {
            throw new DoudianOpException(DoudianOpException.Code.HTTP_RESPONSE_STATUS_CODE_NOT_2XX);
        }
        String httpBody = httpResponse.getBody();
        LOG.info("material gateway uploadAddress http response: %s", httpBody);
        if (httpBody == null || "".equals(httpBody)) {
            httpBody = "{}";
        }
        String logId = httpResponse.getSingleHeader("X-Tt-Logid");
        BinaryMaterialUploadAddressResponse bmr = JsonUtil.fromJson(httpBody, BinaryMaterialUploadAddressResponse.class);
        if (bmr.getResponseMetadata() == null) {
            r.setCode("20000");
            r.setLogId(logId);
            return r;
        }
        if (bmr.getResponseMetadata().getError() != null) {
            r.setCode("20000");
            r.setLogId(logId);
            r.setMsg(String.format("code:%d msg:%s-%s", bmr.getResponseMetadata().getError().getCodeN(), bmr.getResponseMetadata().getError().getCodeN(), bmr.getResponseMetadata().getError().getMessage()));
            return r;
        }
        String uri = bmr.getResult().getUploadAddress().getStoreInfos().get(0).getStoreUri();
        BinaryMaterialUploadResponseWrapperData uriData = new BinaryMaterialUploadResponseWrapperData();
        uriData.setUri(uri);
        String auth = bmr.getResult().getUploadAddress().getStoreInfos().get(0).getAuth();
        String host = bmr.getResult().getUploadAddress().getUploadHosts().get(0);
        String crc32Result = BinaryMaterialUpload.crc32(t.getBinaryBytes());
        httpRequest = HttpRequest.build(String.format("http://%s/%s", host, uri), t.getBinaryBytes());
        httpRequest.addHeader("Host", host);
        httpRequest.addHeader("Authorization", auth);
        httpRequest.addHeader("Content-CRC32", crc32Result);
        if (request.getConfig().getMaterialGatewayHttpConnectTimeout() != null) {
            httpRequest.setConnectTimeout(request.getConfig().getMaterialGatewayHttpConnectTimeout());
        }
        if (request.getConfig().getMaterialGatewayHttpReadTimeout() != null) {
            httpRequest.setReadTimeout(request.getConfig().getMaterialGatewayHttpReadTimeout());
        }
        LOG.info("material gateway upload http request url: %s Authorization: %s Content-CRC32: %s", String.format("%s/%s", host, uri), auth, crc32Result);
        httpResponse = httpClient.put(httpRequest);
        if (httpResponse.getStatusCode() != 200) {
            throw new DoudianOpException(DoudianOpException.Code.HTTP_RESPONSE_STATUS_CODE_NOT_2XX);
        }
        logId = httpResponse.getSingleHeader("X-Tt-Logid");
        httpBody = httpResponse.getBody();
        LOG.info("material gateway upload http response: %s", httpBody);
        if (httpBody == null || "".equals(httpBody)) {
            httpBody = "{}";
        }
        try {
            BinaryMaterialUploadResponse uploadResponse = JsonUtil.fromJson(httpBody, BinaryMaterialUploadResponse.class);
            r.setLogId(logId);
            if (uploadResponse.getSuccess() != 0) {
                r.setCode("20000");
                r.setMsg(uploadResponse.getError().getError());
            } else {
                r.setCode("10000");
            }
            r.setData(uriData);
            return r;
        }
        catch (Exception e) {
            throw new DoudianOpException(DoudianOpException.Code.JSON_ERROR, e);
        }
    }

    private static String crc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        long r = crc32.getValue();
        return Long.toHexString(r);
    }

    static class FutureAdapter<T>
    implements Future<T> {
        private Future<DoudianOpResponseWrapper<T>> future;

        FutureAdapter(Future<DoudianOpResponseWrapper<T>> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.future.get().getResponse();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit).getResponse();
        }
    }
}

