/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core.msg;

import com.doudian.open.core.DoudianOpConfig;
import com.doudian.open.core.GlobalConfig;
import com.doudian.open.core.msg.DoudianOpMsgParamRecord;
import com.doudian.open.core.msg.MsgParam;
import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.gson.JsonArray;
import com.doudian.open.gson.JsonElement;
import com.doudian.open.gson.JsonObject;
import com.doudian.open.utils.JsonUtil;
import com.doudian.open.utils.SignUtil;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

public abstract class DoudianOpMsgRequest<P> {
    private final MsgParam msgParam = MsgParam.build();
    private DoudianOpConfig config = GlobalConfig.getGlobalConfig();

    public void setConfig(DoudianOpConfig config) {
        this.config = config;
    }

    public MsgParam getParam() {
        return this.msgParam;
    }

    private <T> T newObject(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new DoudianOpException(e);
        }
    }

    private Class<?> getSuperClassParameterClasses(Class<?> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new DoudianOpException(e);
        }
    }

    public List<DoudianOpMsgParamRecord<P>> getRequestBody() {
        if (this.msgParam == null || this.msgParam.getRequestBody() == null || this.msgParam.getRequestBody().length() == 0) {
            return new ArrayList<DoudianOpMsgParamRecord<P>>();
        }
        JsonArray jsonArray = JsonUtil.fromJsonAsJsonArray(this.msgParam.getRequestBody());
        if (jsonArray == null || jsonArray.size() == 0) {
            return new ArrayList<DoudianOpMsgParamRecord<P>>();
        }
        Class<?> paramClass = this.getSuperClassParameterClasses(this.getClass());
        ArrayList<DoudianOpMsgParamRecord<P>> ret = new ArrayList<DoudianOpMsgParamRecord<P>>();
        for (JsonElement element : jsonArray) {
            JsonElement msgId;
            if (!element.isJsonObject()) continue;
            JsonObject jsonObject = element.getAsJsonObject();
            JsonElement dataElement = jsonObject.get("data");
            Object paramObject = null;
            if (dataElement != null) {
                paramObject = JsonUtil.fromJson(dataElement.getAsString(), paramClass);
            }
            DoudianOpMsgParamRecord record = new DoudianOpMsgParamRecord();
            JsonElement tag = jsonObject.get("tag");
            if (tag != null) {
                record.setTag(tag.getAsString());
            }
            if ((msgId = jsonObject.get("msg_id")) != null) {
                record.setMsgId(msgId.getAsString());
            }
            record.setData(paramObject);
            ret.add(record);
        }
        return ret;
    }

    public boolean checkSign() {
        if (this.msgParam.getEventSign() == null || this.msgParam.getEventSign().length() == 0) {
            throw new DoudianOpException(DoudianOpException.Code.MSG_CHECK_SIGN_ERROR, "param\u53c2\u6570eventSign\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u4ecehttp\u8bf7\u6c42\u5934\u91cc\u83b7\u53d6\u8be5\u5b57\u6bb5\u5e76\u8bbe\u7f6e");
        }
        String signPattern = this.config.getAppKey() + this.msgParam.getRequestBody() + this.config.getAppSecret();
        return SignUtil.stringToMD5(signPattern).equals(this.msgParam.getEventSign());
    }
}

