/*
 * Decompiled with CFR 0.152.
 */
package com.archytasit.jersey.multipart;

import com.archytasit.jersey.multipart.ContentDisposition;
import com.archytasit.jersey.multipart.MultiPart;
import java.io.Closeable;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

public abstract class BodyPart
implements Closeable {
    private MultiPart parent;
    private String name;
    private MediaType contentType;
    private MultivaluedMap<String, String> headers;
    private ContentDisposition contentDisposition;

    public BodyPart(String name, MediaType contentType, MultivaluedMap<String, String> headers, ContentDisposition contentDisposition) {
        this.name = name;
        this.contentType = contentType;
        this.headers = headers;
        this.contentDisposition = contentDisposition;
    }

    protected void setParent(MultiPart parent) {
        this.parent = parent;
    }

    public void addContentTypeParameter(String paramName, String paramValue) {
        HashMap<String, String> newParams = new HashMap<String, String>(this.contentType.getParameters());
        newParams.put(paramName, paramValue);
        this.contentType = new MediaType(this.contentType.getType(), this.contentType.getSubtype(), newParams);
    }

    public MultiPart getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    @Override
    public void close() {
    }
}

